/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.config;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import com.misterpemodder.shulkerboxtooltip.impl.config.SerializationException;
import com.misterpemodder.shulkerboxtooltip.impl.config.ShulkerBoxTooltipConfigSerializer;
import com.misterpemodder.shulkerboxtooltip.impl.util.EnvironmentUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public final class ConfigurationHandler {
    private static ShulkerBoxTooltipConfigSerializer serializer;

    private ConfigurationHandler() {
    }

    public static Configuration register() {
        serializer = new ShulkerBoxTooltipConfigSerializer();
        Configuration config = ConfigurationHandler.loadFromFile();
        ConfigurationHandler.saveToFile(config);
        return config;
    }

    public static Configuration loadFromFile() {
        try {
            Configuration config = serializer.deserialize();
            Component errorMsg = ShulkerBoxTooltip.configTree.validate(config);
            if (errorMsg != null) {
                ShulkerBoxTooltip.LOGGER.error("Failed to load configuration, using default values: " + String.valueOf(errorMsg));
                return EnvironmentUtil.getInstance().makeConfiguration();
            }
            return config;
        }
        catch (SerializationException e) {
            ShulkerBoxTooltip.LOGGER.error("Failed to load configuration, using default values", e);
            return EnvironmentUtil.getInstance().makeConfiguration();
        }
    }

    public static void saveToFile(Configuration toSave) {
        if (ShulkerBoxTooltip.savedConfig != null) {
            ShulkerBoxTooltip.configTree.copy(toSave, ShulkerBoxTooltip.savedConfig);
        }
        if (ShulkerBoxTooltip.config != null) {
            CompoundTag serverConfigNbt = new CompoundTag();
            ShulkerBoxTooltip.configTree.writeToNbt(ShulkerBoxTooltip.config, serverConfigNbt);
            ShulkerBoxTooltip.configTree.copy(toSave, ShulkerBoxTooltip.config);
            ShulkerBoxTooltip.configTree.readFromNbt(ShulkerBoxTooltip.config, serverConfigNbt);
        }
        try {
            serializer.serialize(toSave);
        }
        catch (SerializationException e) {
            ShulkerBoxTooltip.LOGGER.error("Failed to save configuration", e);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void reinitClientSideSyncedValues(Configuration config) {
        config.server.clientIntegration = false;
        config.server.enderChestSyncType = Configuration.EnderChestSyncType.NONE;
    }

    public static void readFromPacketBuf(Configuration config, FriendlyByteBuf buf) {
        CompoundTag compound = buf.readNbt();
        if (compound != null) {
            ShulkerBoxTooltip.configTree.readFromNbt(config, compound);
        }
    }

    public static void writeToPacketBuf(Configuration config, FriendlyByteBuf buf) {
        CompoundTag compound = new CompoundTag();
        ShulkerBoxTooltip.configTree.writeToNbt(config, compound);
        buf.writeNbt((Tag)compound);
    }
}

