/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.entity.model;

import com.aetherteam.aether.entity.monster.dungeon.Mimic;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class MimicModel
extends EntityModel<Mimic> {
    public final ModelPart upperBody;
    public final ModelPart lowerBody;
    public final ModelPart leftLeg;
    public final ModelPart rightLeg;
    public final ModelPart knob;

    public MimicModel(ModelPart root) {
        this.upperBody = root.getChild("upper_body");
        this.lowerBody = root.getChild("lower_body");
        this.leftLeg = root.getChild("left_leg");
        this.rightLeg = root.getChild("right_leg");
        this.knob = this.upperBody.getChild("knob");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition upperBody = partDefinition.addOrReplaceChild("upper_body", CubeListBuilder.create().texOffs(0, 10).addBox(0.0f, 0.0f, 0.0f, 16.0f, 6.0f, 16.0f), PartPose.offsetAndRotation((float)-8.0f, (float)0.0f, (float)8.0f, (float)((float)Math.PI), (float)0.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("lower_body", CubeListBuilder.create().texOffs(0, 38).addBox(0.0f, 0.0f, 0.0f, 16.0f, 10.0f, 16.0f), PartPose.offset((float)-8.0f, (float)0.0f, (float)-8.0f));
        partDefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(64, 0).addBox(0.0f, 0.0f, -3.0f, 6.0f, 15.0f, 6.0f), PartPose.offset((float)1.5f, (float)9.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(64, 0).mirror().addBox(-5.1f, 0.0f, -3.0f, 6.0f, 15.0f, 6.0f), PartPose.offset((float)-2.5f, (float)9.0f, (float)0.0f));
        upperBody.addOrReplaceChild("knob", CubeListBuilder.create().texOffs(0, 0).addBox(7.0f, -2.0f, 16.0f, 2.0f, 4.0f, 1.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)128, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer consumer, int packedLight, int packedOverlay, int color) {
        this.upperBody.render(poseStack, consumer, packedLight, packedOverlay, color);
        this.lowerBody.render(poseStack, consumer, packedLight, packedOverlay, color);
        this.leftLeg.render(poseStack, consumer, packedLight, packedOverlay, color);
        this.rightLeg.render(poseStack, consumer, packedLight, packedOverlay, color);
    }

    public void setupAnim(Mimic mimic, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.upperBody.xRot = (float)Math.PI - 0.6f * (1.0f + Mth.cos((float)(ageInTicks / 10.0f * (float)Math.PI)));
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
    }
}

