/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.volume;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumeSlider;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumesScreen;
import de.maxhenkel.voicechat.gui.volume.VolumeEntry;
import de.maxhenkel.voicechat.plugins.impl.VolumeCategoryImpl;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class CategoryVolumeEntry
extends VolumeEntry {
    protected final VolumeCategoryImpl category;
    protected final ResourceLocation texture;

    public CategoryVolumeEntry(VolumeCategoryImpl category, AdjustVolumesScreen screen) {
        super(screen, new AdjustCategoryVolumeEntry(category.getId()));
        this.category = category;
        this.texture = ClientManager.getCategoryManager().getTexture(category.getId(), OTHER_VOLUME_ICON);
    }

    public VolumeCategoryImpl getCategory() {
        return this.category;
    }

    @Override
    public void renderElement(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float delta, int skinX, int skinY, int textX, int textY) {
        guiGraphics.blit(this.texture, skinX, skinY, 24, 24, 16.0f, 16.0f, 16, 16, 16, 16);
        guiGraphics.drawString(this.minecraft.font, this.category.getDisplayName(), textX, textY, PLAYER_NAME_COLOR, false);
        if (hovered && this.category.getDescription() != null) {
            this.screen.postRender(() -> guiGraphics.renderTooltip(this.minecraft.font, this.category.getDisplayDescription(), mouseX, mouseY));
        }
    }

    private static class AdjustCategoryVolumeEntry
    implements AdjustVolumeSlider.AdjustVolumeEntry {
        private final String category;

        public AdjustCategoryVolumeEntry(String category) {
            this.category = category;
        }

        @Override
        public void save(double value) {
            VoicechatClient.CATEGORY_VOLUME_CONFIG.setVolume(this.category, value, new String[0]);
            VoicechatClient.CATEGORY_VOLUME_CONFIG.save();
        }

        @Override
        public double get() {
            return VoicechatClient.CATEGORY_VOLUME_CONFIG.getVolume(this.category);
        }

        @Override
        public double getAudioLevel() {
            ClientVoicechat client = ClientManager.getClient();
            if (client == null) {
                return -127.0;
            }
            return client.getTalkCache().getCategoryAudioLevel(this.category);
        }
    }
}

