/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.linkedtransmitter;

import com.hlysine.create_connected.content.linkedtransmitter.LinkedTransmitterFrequencySlot;
import com.simibubi.create.content.redstone.link.LinkBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Pair;

public class LinkedTransmitterBlockEntity
extends SmartBlockEntity {
    private int transmittedSignal;
    public boolean containsBase = true;
    private LinkBehaviour link;

    public LinkedTransmitterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.createLink();
        behaviours.add((BlockEntityBehaviour)this.link);
    }

    protected void createLink() {
        Pair slots = ValueBoxTransform.Dual.makeSlots(LinkedTransmitterFrequencySlot::new);
        this.link = LinkBehaviour.transmitter((SmartBlockEntity)this, (Pair)slots, this::getSignal);
    }

    public void initialize() {
        super.initialize();
        this.transmit(this.getBlockState().getSignal((BlockGetter)this.getLevel(), this.getBlockPos(), (Direction)this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)));
    }

    public int getSignal() {
        return this.transmittedSignal;
    }

    public void transmit(int strength) {
        this.transmittedSignal = strength;
        if (this.link != null) {
            this.link.notifySignalChange();
        }
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        tag.putInt("Transmit", this.transmittedSignal);
        super.write(tag, registries, clientPacket);
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        if (this.level == null || this.level.isClientSide || !this.link.newPosition) {
            this.transmittedSignal = tag.getInt("Transmit");
        }
    }
}

