/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.cuisinedelight.content.item;

import dev.xkmc.cuisinedelight.content.block.CuisineSkilletBlockEntity;
import dev.xkmc.cuisinedelight.content.logic.CookingData;
import dev.xkmc.cuisinedelight.content.logic.IngredientConfig;
import dev.xkmc.cuisinedelight.init.data.CDConfig;
import dev.xkmc.cuisinedelight.init.data.LangData;
import dev.xkmc.cuisinedelight.init.registrate.CDItems;
import dev.xkmc.l2core.init.reg.ench.EnchHelper;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.item.SkilletItem;
import vectorwing.farmersdelight.common.registry.ModSounds;
import vectorwing.farmersdelight.common.tag.ModTags;

public class CuisineSkilletItem
extends SkilletItem {
    @Nullable
    public static CookingData getData(ItemStack stack) {
        CookingData.Record ans = (CookingData.Record)CDItems.COOKING.get(stack);
        return ans == null ? null : ans.mutable();
    }

    public static void setData(ItemStack stack, @Nullable CookingData data) {
        if (data == null) {
            stack.remove((DataComponentType)CDItems.COOKING.get());
        } else {
            CDItems.COOKING.set(stack, (Object)data.immutable());
        }
    }

    public static boolean canUse(ItemStack stack, Player player, Level level) {
        if (CuisineSkilletItem.getData(stack) != null) {
            return true;
        }
        if (EnchHelper.getLv((ItemStack)stack, (ResourceKey)Enchantments.FIRE_ASPECT) > 0) {
            return true;
        }
        return CuisineSkilletItem.isPlayerNearHeatSource(player, (LevelReader)level);
    }

    public static void playSound(Player player, Level level, SoundEvent event) {
        Vec3 pos = player.position();
        double x = pos.x() + 0.5;
        double y = pos.y();
        double z = pos.z() + 0.5;
        level.playLocalSound(x, y, z, event, SoundSource.BLOCKS, 0.4f, level.random.nextFloat() * 0.2f + 0.9f, false);
    }

    public CuisineSkilletItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack skilletStack = player.getItemInHand(hand);
        if (!CuisineSkilletItem.canUse(skilletStack, player, level)) {
            if (!level.isClientSide()) {
                ((ServerPlayer)player).sendSystemMessage((Component)LangData.MSG_NO_HEAT.get(new Object[0]), true);
            }
            return InteractionResultHolder.fail((Object)skilletStack);
        }
        CookingData data = CuisineSkilletItem.getData(skilletStack);
        if (data != null && data.contents.size() >= (Integer)CDConfig.SERVER.maxIngredient.get()) {
            if (!level.isClientSide()) {
                ((ServerPlayer)player).sendSystemMessage((Component)LangData.MSG_FULL.get(new Object[0]), true);
            }
            return InteractionResultHolder.fail((Object)skilletStack);
        }
        InteractionHand otherHand = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        ItemStack otherStack = player.getItemInHand(otherHand);
        if (!otherStack.isEmpty()) {
            IngredientConfig.IngredientEntry entry = IngredientConfig.get().getEntry(otherStack);
            if (entry != null) {
                if (!level.isClientSide()) {
                    long time = level.getGameTime();
                    if (data == null) {
                        data = new CookingData();
                    }
                    int amount = 1 + EnchHelper.getLv((ItemStack)skilletStack, (ResourceKey)Enchantments.EFFICIENCY);
                    int speed = EnchHelper.getLv((ItemStack)skilletStack, (ResourceKey)Enchantments.FIRE_ASPECT);
                    if (speed == 1) {
                        data.setSpeed(0.5f);
                    }
                    ItemStack toAdd = otherStack.split(amount);
                    data.addItem(toAdd, time);
                    ItemStack remain = toAdd.getCraftingRemainingItem();
                    remain.setCount(toAdd.getCount());
                    player.getInventory().placeItemBackInInventory(remain);
                    CuisineSkilletItem.setData(skilletStack, data);
                } else {
                    CuisineSkilletItem.playSound(player, level, (SoundEvent)ModSounds.BLOCK_SKILLET_ADD_FOOD.get());
                }
            } else if (!level.isClientSide()) {
                ((ServerPlayer)player).sendSystemMessage((Component)LangData.MSG_NOT_INGREDIENT.get(new Object[0]), true);
            }
        } else if (!level.isClientSide()) {
            ((ServerPlayer)player).sendSystemMessage((Component)LangData.MSG_PLACE_HELP.get(new Object[0]), true);
        }
        return InteractionResultHolder.fail((Object)skilletStack);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        Player player;
        if (level.isClientSide() && entity instanceof Player && ((player = (Player)entity).getMainHandItem() == stack || player.getOffhandItem() == stack) && level.getRandom().nextInt(10) == 0 && CuisineSkilletItem.canUse(stack, player, level) && CuisineSkilletItem.getData(stack) != null) {
            CuisineSkilletItem.playSound(player, level, (SoundEvent)ModSounds.BLOCK_SKILLET_SIZZLE.get());
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    protected boolean updateCustomBlockEntityTag(BlockPos pos, Level level, @Nullable Player player, ItemStack stack, BlockState state) {
        BlockItem.updateCustomBlockEntityTag((Level)level, (Player)player, (BlockPos)pos, (ItemStack)stack);
        BlockEntity tileEntity = level.getBlockEntity(pos);
        if (tileEntity instanceof CuisineSkilletBlockEntity) {
            CuisineSkilletBlockEntity be = (CuisineSkilletBlockEntity)tileEntity;
            be.setSkilletItem(stack);
            return true;
        }
        return false;
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        return stack;
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int count) {
    }

    private static boolean isPlayerNearHeatSource(Player player, LevelReader level) {
        if (player.isOnFire()) {
            return true;
        }
        BlockPos pos = player.blockPosition();
        for (BlockPos nearbyPos : BlockPos.betweenClosed((BlockPos)pos.offset(-1, -1, -1), (BlockPos)pos.offset(1, 1, 1))) {
            if (!level.getBlockState(nearbyPos).is(ModTags.HEAT_SOURCES)) continue;
            return true;
        }
        return false;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        if (enchantment.is(Enchantments.FIRE_ASPECT)) {
            return true;
        }
        if (enchantment.is(Enchantments.EFFICIENCY)) {
            return true;
        }
        return super.supportsEnchantment(stack, enchantment);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext level, List<Component> list, TooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            list.add((Component)LangData.ENCH_FIRE.get(new Object[0]));
            list.add((Component)LangData.ENCH_EFFICIENCY.get(new Object[0]));
        } else {
            list.add((Component)LangData.ENCH_SHIFT.get(new Object[0]));
        }
    }
}

