/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.cuisinedelight.content.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import dev.xkmc.cuisinedelight.init.CuisineDelight;
import java.util.Locale;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public record PieRenderer(GuiGraphics g, int x, int y) {
    private static final int Z = -1;

    public void fillPie(float a0, float a1, Texture type) {
        a0 += 0.75f;
        a1 += 0.75f;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)type.getID());
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Matrix4f matrix4f = this.g.pose().last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.addVertex(matrix4f, (float)this.x, (float)this.y, -1.0f).setUv(0.5f, 0.5f);
        for (int i = Mth.ceil((float)(a1 * 4.0f + 0.5f)); i >= Mth.floor((float)(a0 * 4.0f + 0.5f)); --i) {
            double a = (double)(Mth.clamp((float)((float)i * 0.25f - 0.125f), (float)a0, (float)a1) * 2.0f) * Math.PI;
            float cos = (float)Math.cos(a);
            float sin = (float)Math.sin(a);
            float r = Math.abs(cos) > Math.abs(sin) ? Math.abs(0.5f / cos) : Math.abs(0.5f / sin);
            bufferbuilder.addVertex(matrix4f, (float)this.x + 16.0f * r * cos, (float)this.y + 16.0f * r * sin, -1.0f).setUv(0.5f + r * cos, 0.5f + r * sin);
        }
        MeshData ans = bufferbuilder.build();
        if (ans != null) {
            BufferUploader.drawWithShader((MeshData)ans);
        }
    }

    public void drawNeedle(Texture needle, float a) {
        this.g.pose().pushPose();
        this.g.pose().translate((float)this.x, (float)this.y, 0.0f);
        this.g.pose().mulPose(Axis.ZP.rotationDegrees(a * 360.0f));
        this.g.blit(needle.getID(), -8, -8, 16, 16, 0.0f, 0.0f, 32, 32, 32, 32);
        this.g.pose().popPose();
    }

    public void drawIcon(Texture icon) {
        this.g.blit(icon.getID(), this.x - 8, this.y - 8, 16, 16, 0.0f, 0.0f, 32, 32, 32, 32);
    }

    public static enum Texture {
        PIE_GREEN,
        PIE_YELLOW,
        PIE_RED,
        NEEDLE_RED,
        NEEDLE_BLACK,
        COOK,
        FLIP;


        public ResourceLocation getID() {
            return CuisineDelight.loc("textures/gui/overlay/" + this.name().toLowerCase(Locale.ROOT) + ".png");
        }
    }
}

