/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.neoforged.neoforge.common.extensions.IDataComponentHolderExtension;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.inventory.StorageWrapperRepository;
import net.p3pp3rf1y.sophisticatedcore.util.BlockItemBase;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.block.IStorageBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ItemContentsStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.item.ShulkerBoxItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;

public class StackStorageWrapper
extends StorageWrapper {
    private static final String CONTENTS_TAG = "contents";
    private ItemStack storageStack;

    public StackStorageWrapper(ItemStack storageStack) {
        super(() -> () -> {}, () -> {}, () -> {});
        this.setStorageStack(storageStack);
    }

    public static StackStorageWrapper fromStack(HolderLookup.Provider registries, ItemStack stack) {
        StackStorageWrapper stackStorageWrapper = (StackStorageWrapper)StorageWrapperRepository.getStorageWrapper((ItemStack)stack, StackStorageWrapper.class, StackStorageWrapper::new);
        UUID uuid = (UUID)stack.get(ModCoreDataComponents.STORAGE_UUID);
        if (uuid != null) {
            CompoundTag compoundtag = ItemContentsStorage.get().getOrCreateStorageContents(uuid).getCompound("storageWrapper");
            stackStorageWrapper.load(compoundtag);
            stackStorageWrapper.setContentsUuid(uuid);
        }
        return stackStorageWrapper;
    }

    private UUID getNewUuid() {
        UUID newUuid = UUID.randomUUID();
        this.setContentsUuid(newUuid);
        return newUuid;
    }

    public Optional<UUID> getContentsUuid() {
        return Optional.ofNullable(this.contentsUuid);
    }

    public boolean hasContents() {
        return StorageBlockItem.getEntityWrapperTagFromStack((IDataComponentHolderExtension)this.storageStack).isPresent() || this.contentsUuid != null;
    }

    @Override
    public void setContentsUuid(@Nullable UUID contentsUuid) {
        super.setContentsUuid(contentsUuid);
        if (contentsUuid != null) {
            this.storageStack.set(ModCoreDataComponents.STORAGE_UUID, (Object)contentsUuid);
            ItemContentsStorage itemContentsStorage = ItemContentsStorage.get();
            CompoundTag storageContents = itemContentsStorage.getOrCreateStorageContents(contentsUuid);
            if (!storageContents.contains("storageWrapper")) {
                CompoundTag storageWrapperTag = new CompoundTag();
                storageWrapperTag.put(CONTENTS_TAG, (Tag)new CompoundTag());
                storageContents.put("storageWrapper", (Tag)storageWrapperTag);
            }
            this.onContentsNbtUpdated();
        }
    }

    @Override
    protected CompoundTag getContentsNbt() {
        return StorageBlockItem.getEntityWrapperTagFromStack((IDataComponentHolderExtension)this.storageStack).map(wrapperTag -> wrapperTag.getCompound(CONTENTS_TAG)).orElseGet(() -> {
            if (this.contentsUuid == null) {
                this.contentsUuid = this.getNewUuid();
            }
            return ItemContentsStorage.get().getOrCreateStorageContents(this.contentsUuid).getCompound("storageWrapper").getCompound(CONTENTS_TAG);
        });
    }

    @Override
    protected void onUpgradeRefresh() {
    }

    @Override
    public int getDefaultNumberOfInventorySlots() {
        int n;
        BlockItemBase blockItem;
        Item item = this.storageStack.getItem();
        if (item instanceof BlockItemBase && (item = (blockItem = (BlockItemBase)item).getBlock()) instanceof IStorageBlock) {
            IStorageBlock storageBlock = (IStorageBlock)item;
            n = storageBlock.getNumberOfInventorySlots();
        } else {
            n = 0;
        }
        return n;
    }

    @Override
    protected void loadSlotNumbers(CompoundTag tag) {
        StorageBlockItem.getEntityWrapperTagFromStack((IDataComponentHolderExtension)this.storageStack).ifPresentOrElse(wrapperTag -> {
            this.numberOfInventorySlots = wrapperTag.getInt("numberOfInventorySlots");
            this.numberOfUpgradeSlots = wrapperTag.getInt("numberOfUpgradeSlots");
        }, () -> {
            this.numberOfInventorySlots = (Integer)this.storageStack.getOrDefault(ModCoreDataComponents.NUMBER_OF_INVENTORY_SLOTS, (Object)0);
            this.numberOfUpgradeSlots = (Integer)this.storageStack.getOrDefault(ModCoreDataComponents.NUMBER_OF_UPGRADE_SLOTS, (Object)0);
        });
    }

    @Override
    public int getDefaultNumberOfUpgradeSlots() {
        int n;
        BlockItemBase blockItem;
        Item item = this.storageStack.getItem();
        if (item instanceof BlockItemBase && (item = (blockItem = (BlockItemBase)item).getBlock()) instanceof IStorageBlock) {
            IStorageBlock storageBlock = (IStorageBlock)item;
            n = storageBlock.getNumberOfUpgradeSlots();
        } else {
            n = 0;
        }
        return n;
    }

    protected void setStorageStack(ItemStack storageStack) {
        this.storageStack = storageStack;
    }

    @Override
    protected boolean isAllowedInStorage(ItemStack stack) {
        if (!(this.storageStack.getItem() instanceof ShulkerBoxItem)) {
            return false;
        }
        Block block = Block.byItem((Item)stack.getItem());
        return !(block instanceof net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock) && !(block instanceof ShulkerBoxBlock) && !Config.SERVER.shulkerBoxDisallowedItems.isItemDisallowed(stack.getItem());
    }

    public String getStorageType() {
        return "irrelevant";
    }

    public Component getDisplayName() {
        return Component.empty();
    }

    @Override
    public void setColors(int mainColor, int accentColor) {
        this.storageStack.set(ModCoreDataComponents.MAIN_COLOR, (Object)mainColor);
        this.storageStack.set(ModCoreDataComponents.ACCENT_COLOR, (Object)accentColor);
        this.save();
    }

    @Override
    public int getMainColor() {
        return (Integer)this.storageStack.getOrDefault(ModCoreDataComponents.MAIN_COLOR, (Object)-1);
    }

    @Override
    public boolean hasMainColor() {
        return this.storageStack.has(ModCoreDataComponents.MAIN_COLOR);
    }

    @Override
    public int getAccentColor() {
        return (Integer)this.storageStack.getOrDefault(ModCoreDataComponents.ACCENT_COLOR, (Object)-1);
    }

    @Override
    public boolean hasAccentColor() {
        return this.storageStack.has(ModCoreDataComponents.ACCENT_COLOR);
    }
}

