/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.compat.recipeviewers.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.ClientRecipeHelper;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.subtypes.PropertyBasedSubtypeInterpreter;
import net.p3pp3rf1y.sophisticatedstorage.crafting.ShulkerBoxFromChestRecipe;
import net.p3pp3rf1y.sophisticatedstorage.item.ChestBlockItem;

public class ShulkerBoxFromChestRecipesMaker {
    private ShulkerBoxFromChestRecipesMaker() {
    }

    public static <T extends PropertyBasedSubtypeInterpreter> List<RecipeHolder<CraftingRecipe>> getShapedRecipes(Function<ItemStack, Optional<T>> getSubtypeInterpreter) {
        return ShulkerBoxFromChestRecipesMaker.getShapedRecipes(getSubtypeInterpreter, RecipeHolder::new);
    }

    public static <R, T extends PropertyBasedSubtypeInterpreter> List<R> getShapedRecipes(Function<ItemStack, Optional<T>> getSubtypeInterpreter, BiFunction<ResourceLocation, CraftingRecipe, R> transformRecipe) {
        return ClientRecipeHelper.transformAllRecipesOfTypeIntoMultiple((RecipeType)RecipeType.CRAFTING, ShulkerBoxFromChestRecipe.class, originalRecipe -> {
            ArrayList recipes = new ArrayList();
            ShulkerBoxFromChestRecipesMaker.getChestItems(originalRecipe).forEach(chestItem -> {
                TransientCraftingContainer craftinginventory = new TransientCraftingContainer(new AbstractContainerMenu(null, -1){

                    public ItemStack quickMoveStack(Player player, int index) {
                        return ItemStack.EMPTY;
                    }

                    public boolean stillValid(Player playerIn) {
                        return false;
                    }
                }, 3, 3);
                NonNullList ingredients = originalRecipe.getIngredients();
                NonNullList ingredientsCopy = NonNullList.createWithCapacity((int)ingredients.size());
                int i = 0;
                for (Ingredient ingredient : ingredients) {
                    ItemStack[] ingredientItems = ingredient.getItems();
                    boolean isChestIngredient = false;
                    for (ItemStack ingredientItem : ingredientItems) {
                        if (!(ingredientItem.getItem() instanceof ChestBlockItem)) continue;
                        isChestIngredient = true;
                        break;
                    }
                    if (isChestIngredient) {
                        ingredientsCopy.add(i, (Object)Ingredient.of((ItemStack[])new ItemStack[]{chestItem}));
                        craftinginventory.setItem(i, chestItem.copy());
                    } else {
                        ingredientsCopy.add(i, (Object)ingredient);
                        craftinginventory.setItem(i, ingredientItems[0]);
                    }
                    ++i;
                }
                ItemStack result = ClientRecipeHelper.assemble((Recipe)originalRecipe, (RecipeInput)craftinginventory.asCraftInput());
                ResourceLocation newId = ResourceLocation.fromNamespaceAndPath((String)"sophisticatedstorage", (String)("shulker_from_" + ((Optional)getSubtypeInterpreter.apply((ItemStack)chestItem)).map(interpreter -> interpreter.getRegistrySanitizedItemString(chestItem)).orElse("")));
                ShapedRecipePattern pattern = new ShapedRecipePattern(originalRecipe.getWidth(), originalRecipe.getHeight(), ingredientsCopy, Optional.empty());
                recipes.add(transformRecipe.apply(newId, (CraftingRecipe)new ShapedRecipe("", CraftingBookCategory.MISC, pattern, result)));
            });
            return recipes;
        });
    }

    private static List<ItemStack> getChestItems(ShapedRecipe recipe) {
        NonNullList chestItems = NonNullList.create();
        for (Ingredient ingredient : recipe.getIngredients()) {
            ItemStack[] ingredientItems;
            for (ItemStack ingredientItem : ingredientItems = ingredient.getItems()) {
                Item item = ingredientItem.getItem();
                if (!(item instanceof ChestBlockItem)) continue;
                ChestBlockItem chestBlockItem = (ChestBlockItem)item;
                chestBlockItem.addCreativeTabItems(arg_0 -> chestItems.add(arg_0));
            }
        }
        return chestItems;
    }
}

