/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import net.mehvahdjukaar.supplementaries.common.block.IKeyLockable;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class KeyLockableTile
extends BlockEntity
implements IKeyLockable {
    private String password = null;

    public KeyLockableTile(BlockPos pos, BlockState state) {
        super(ModRegistry.KEY_LOCKABLE_TILE.get(), pos, state);
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void clearPassword() {
        this.password = null;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public boolean handleAction(Player player, InteractionHand handIn, String translName) {
        if (player.m_5833_()) {
            return false;
        }
        ItemStack stack = player.m_21120_(handIn);
        String keyPassword = IKeyLockable.getKeyPassword(stack);
        if (player.m_36341_() && keyPassword != null) {
            if (this.tryClearingKey(player, stack)) {
                return false;
            }
        } else if (this.password == null) {
            if (keyPassword != null) {
                this.setPassword(keyPassword);
                this.onKeyAssigned(this.f_58857_, this.f_58858_, player, keyPassword);
                return false;
            }
            return true;
        }
        return player.m_7500_() || this.testIfHasCorrectKey(player, this.password, true, translName);
    }

    public boolean tryClearingKey(Player player, ItemStack stack) {
        if (player.m_7500_() || this.getKeyStatus(stack) == IKeyLockable.KeyStatus.CORRECT_KEY) {
            this.clearPassword();
            this.onPasswordCleared(player, this.f_58858_);
            return true;
        }
        return false;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.password = compound.m_128441_("Password") ? compound.m_128461_("Password") : null;
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.password != null) {
            tag.m_128359_("Password", this.password);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

