/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.faucet;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.faucet.BeehiveInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.BrewingStandInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.ConcreteInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.ContainerItemInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.DataFluidInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.DataItemInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.ForgeFluidTankInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.HoneyPotInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.IFaucetBlockSource;
import net.mehvahdjukaar.supplementaries.common.block.faucet.KettleInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.LavaCauldronInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.MudInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.PowderSnowCauldronInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.SappyLogInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.SoftFluidProviderInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.SoftFluidTankInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.SpongeInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.WaterBlockInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.WaterCauldronInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.XPDroppingInteraction;
import net.mehvahdjukaar.supplementaries.common.block.tiles.FaucetBlockTile;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class FaucetBehaviorsManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final FaucetBehaviorsManager RELOAD_INSTANCE = new FaucetBehaviorsManager();
    private final Set<Object> dataInteractions = new HashSet<Object>();
    private static final Codec<Either<DataItemInteraction, DataFluidInteraction>> CODEC = Codec.either(DataItemInteraction.CODEC, DataFluidInteraction.CODEC);

    public FaucetBehaviorsManager() {
        super(GSON, "faucet_interactions");
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager resourceManager, ProfilerFiller profiler) {
        FaucetBlockTile.removeDataInteractions(this.dataInteractions);
        this.dataInteractions.clear();
        jsons.forEach((key, json) -> {
            try {
                DataResult result = CODEC.parse((DynamicOps)JsonOps.INSTANCE, json);
                Either d = (Either)result.getOrThrow(false, e -> Supplementaries.LOGGER.error("Failed to fluid interaction: {}", e));
                Optional l = d.left();
                Object o = l.isPresent() ? l.get() : d.right().get();
                this.dataInteractions.add(o);
                FaucetBlockTile.registerInteraction(o);
            }
            catch (Exception e2) {
                Supplementaries.LOGGER.error("Failed to parse JSON object for faucet interaction " + key);
            }
        });
        if (!this.dataInteractions.isEmpty()) {
            Supplementaries.LOGGER.info("Loaded  " + this.dataInteractions.size() + " custom faucet interactions");
        }
    }

    public static void registerBehaviors() {
        FaucetBlockTile.registerInteraction(new SoftFluidProviderInteraction());
        FaucetBlockTile.registerInteraction(new WaterCauldronInteraction());
        FaucetBlockTile.registerInteraction(new LavaCauldronInteraction());
        FaucetBlockTile.registerInteraction(new PowderSnowCauldronInteraction());
        FaucetBlockTile.registerInteraction(new BeehiveInteraction());
        FaucetBlockTile.registerInteraction(new SoftFluidTankInteraction());
        FaucetBlockTile.registerInteraction(new ForgeFluidTankInteraction());
        FaucetBlockTile.registerInteraction(new BrewingStandInteraction());
        FaucetBlockTile.registerInteraction(new WaterBlockInteraction());
        FaucetBlockTile.registerInteraction(new SpongeInteraction());
        FaucetBlockTile.registerInteraction(new XPDroppingInteraction());
        FaucetBlockTile.registerInteraction(new ConcreteInteraction());
        FaucetBlockTile.registerInteraction(new MudInteraction());
        FaucetBlockTile.registerInteraction(new ContainerItemInteraction());
        if (CompatHandler.BUZZIER_BEES) {
            FaucetBlockTile.registerInteraction(new HoneyPotInteraction());
        }
        if (CompatHandler.AUTUMNITY) {
            FaucetBlockTile.registerInteraction(new SappyLogInteraction());
        }
        if (CompatHandler.FARMERS_RESPRITE) {
            FaucetBlockTile.registerInteraction(new KettleInteraction());
        }
    }

    static void prepareToTransferBottle(SoftFluidTank tempFluidHolder, SoftFluid softFluid) {
        tempFluidHolder.fill(softFluid);
        tempFluidHolder.setCount(2);
    }

    static void prepareToTransferBottle(SoftFluidTank tempFluidHolder, SoftFluid softFluid, CompoundTag tag) {
        tempFluidHolder.fill(softFluid, tag);
        tempFluidHolder.setCount(2);
    }

    static void prepareToTransferBucket(SoftFluidTank tempFluidHolder, SoftFluid softFluid) {
        tempFluidHolder.fill(softFluid);
    }

    private static class MalumInteraction
    implements IFaucetBlockSource {
        private MalumInteraction() {
        }

        @Override
        public InteractionResult tryDrain(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockState state, FaucetBlockTile.FillAction fillAction) {
            return InteractionResult.PASS;
        }
    }
}

