/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.wither.feature;

import com.google.common.util.concurrent.AtomicDouble;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Blacklist;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import insane96mcp.insanelib.data.IdTagMatcher;
import insane96mcp.progressivebosses.capability.Difficulty;
import insane96mcp.progressivebosses.utils.LogHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Difficulty Settings", description="How difficulty is handled for the Wither.")
@LoadFeature(module="progressivebosses:wither")
public class DifficultyFeature
extends Feature {
    @Config(min=1.0)
    @Label(name="Max Difficulty", description="The Maximum difficulty (times spawned) reachable by Wither.")
    public static Integer maxDifficulty = 8;
    @Config(min=0.0)
    @Label(name="Starting Difficulty", description="How much difficulty will players start with when joining a world? Note that this will apply when the first Wither is spawned so if the player has already spawned one this will not apply.")
    public static Integer startingDifficulty = 0;
    @Config(min=16.0)
    @Label(name="Spawn Radius Player Check", description="How much blocks from wither will be scanned for players to check for difficulty")
    public static Integer spawnRadiusPlayerCheck = 128;
    @Config
    @Label(name="Sum Spawned Wither Difficulty", description="If false and there's more than 1 player around the Wither, difficulty will be the average of all the players' difficulty instead of summing them.")
    public static Boolean sumSpawnedWitherDifficulty = false;
    @Config(min=0.0)
    @Label(name="Bonus Difficulty per Player", description="Percentage bonus difficulty added to the Wither when more than one player is present. Each player past the first one will add this percentage to the difficulty.")
    public static Double bonusDifficultyPerPlayer = 0.25;
    @Config(min=16.0)
    @Label(name="Show First Summoned Wither Message", description="Set to false to disable the first Wither summoned message.")
    public static Boolean showFirstSummonedWitherMessage = true;
    @Config
    @Label(name="Entity Blacklist", description="Entities that extend the vanilla Wither but shouldn't be taken into account by the mod (e.g. Botania's Pink Wither).")
    public static Blacklist entityBlacklist = new Blacklist(List.of(IdTagMatcher.newId((String)"botania:pink_wither")), false);

    public DifficultyFeature(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onSpawn(EntityJoinLevelEvent event) {
        WitherBoss wither;
        Entity entity;
        if (event.getLevel().f_46443_ || !this.isEnabled() || !((entity = event.getEntity()) instanceof WitherBoss) || entityBlacklist.isEntityBlackOrNotWhitelist((Entity)(wither = (WitherBoss)entity))) {
            return;
        }
        CompoundTag witherTags = wither.getPersistentData();
        if (witherTags.m_128441_("progressivebosses:difficulty")) {
            return;
        }
        BlockPos pos1 = wither.m_20183_().m_7918_(-spawnRadiusPlayerCheck.intValue(), -spawnRadiusPlayerCheck.intValue(), -spawnRadiusPlayerCheck.intValue());
        BlockPos pos2 = wither.m_20183_().m_7918_(spawnRadiusPlayerCheck.intValue(), spawnRadiusPlayerCheck.intValue(), spawnRadiusPlayerCheck.intValue());
        AABB bb = new AABB(pos1, pos2);
        List players = event.getLevel().m_45976_(ServerPlayer.class, bb);
        if (players.size() == 0) {
            return;
        }
        AtomicDouble witherDifficulty = new AtomicDouble(0.0);
        for (ServerPlayer player : players) {
            player.getCapability(Difficulty.INSTANCE).ifPresent(difficulty -> {
                witherDifficulty.addAndGet((double)difficulty.getSpawnedWithers());
                if (difficulty.getSpawnedWithers() >= maxDifficulty) {
                    return;
                }
                if (difficulty.getSpawnedWithers() <= startingDifficulty && showFirstSummonedWitherMessage.booleanValue()) {
                    player.m_213846_((Component)Component.m_237115_((String)"wither.first_summon"));
                }
                difficulty.addSpawnedWithers(1);
            });
        }
        if (!sumSpawnedWitherDifficulty.booleanValue()) {
            witherDifficulty.set(witherDifficulty.get() / (double)players.size());
        }
        if (players.size() > 1) {
            witherDifficulty.set(witherDifficulty.get() * (1.0 + (double)(players.size() - 1) * bonusDifficultyPerPlayer));
        }
        witherTags.m_128350_("progressivebosses:difficulty", (float)witherDifficulty.get());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void setPlayerData(EntityJoinLevelEvent event) {
        if (event.getLevel().f_46443_) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        player.getCapability(Difficulty.INSTANCE).ifPresent(difficulty -> {
            if (difficulty.getSpawnedWithers() < startingDifficulty) {
                difficulty.setSpawnedWithers(startingDifficulty);
                LogHelper.info("[Progressive Bosses] %s spawned withers counter was below the set 'Starting Difficulty', Has been increased to match 'Starting Difficulty'", player.m_7755_().getString());
            }
        });
    }
}

