/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.elderguardian.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Rewards", description="Bonus Experience and Dragon Egg per player")
@LoadFeature(module="progressivebosses:elder_guardian")
public class RewardFeature
extends Feature {
    @Config(min=-1.0, max=1024.0)
    @Label(name="Base Experience", description="How much experience will an Elder Guardian drop. -1 will make the Elder Guardian drop vanilla experience.")
    public static Integer baseExperience = 40;
    @Config(min=0.0)
    @Label(name="Bonus Experience", description="How much more experience (percentage) will Elder Guardian drop per killed Elder Guardian. The percentage is additive (e.g. with this set to 100%, the last Elder will drop 200% more experience)")
    public static Double bonusExperience = 1.0;
    @Config(min=-1.0, max=1024.0)
    @Label(name="Inject Default Loot", description="If true default mod drops are added to the Elder Guardian.\nNote that replacing the Elder Guardian loot table (e.g. via DataPack) will automatically remove the Injected loot.")
    public static Boolean injectDefaultRewards = true;

    public RewardFeature(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onSpawn(EntityJoinLevelEvent event) {
        Entity entity;
        if (event.getLevel().f_46443_ || !this.isEnabled() || (double)baseExperience.intValue() == -1.0 || !((entity = event.getEntity()) instanceof ElderGuardian)) {
            return;
        }
        ElderGuardian elderGuardian = (ElderGuardian)entity;
        elderGuardian.f_21364_ = baseExperience;
    }

    @SubscribeEvent
    public void onExperienceDrop(LivingExperienceDropEvent event) {
        if (!this.isEnabled() || bonusExperience == 0.0 || !(event.getEntity() instanceof ElderGuardian)) {
            return;
        }
        int bonusXp = (int)((double)event.getOriginalExperience() * bonusExperience);
        event.setDroppedExperience(event.getOriginalExperience() + bonusXp);
    }
}

