/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.elderguardian.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Base", description="Base feature for the Elder Guardian harder fights.")
@LoadFeature(module="progressivebosses:elder_guardian", canBeDisabled=false)
public class BaseFeature
extends Feature {
    @Config
    @Label(name="Adventure mode", description="If true, the player will not be able to break blocks when an Elder Guardian is nearby.")
    public static Boolean adventure = true;
    @Config
    @Label(name="Adventure mode Range", description="The range from any Elder Guardian at which players get adventure mode. It's advised to increase this (to about 80) with YUNG's Better Ocean Monuments.")
    public static Double adventureRange = 48.0;

    public BaseFeature(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player.m_9236_().f_46443_ || !this.isEnabled() || !adventure.booleanValue() || event.player.f_19797_ % 20 != 0 || !event.player.m_6084_()) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)event.player;
        ServerLevel world = (ServerLevel)serverPlayer.m_9236_();
        CompoundTag nbt = serverPlayer.getPersistentData();
        boolean previouslyNearElderGuardian = nbt.m_128471_("progressivebosses:previously_near_elder_guardian");
        boolean adventureMessage = nbt.m_128471_("progressivebosses:adventure_message");
        boolean nearElderGuardian = !world.m_45976_(ElderGuardian.class, serverPlayer.m_20191_().m_82400_(adventureRange.doubleValue())).isEmpty();
        nbt.m_128379_("progressivebosses:previously_near_elder_guardian", nearElderGuardian);
        if (serverPlayer.f_8941_.m_9290_() == GameType.SURVIVAL && nearElderGuardian) {
            serverPlayer.f_8941_.m_143473_(GameType.ADVENTURE);
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132156_, (float)GameType.ADVENTURE.m_46392_()));
            if (!adventureMessage) {
                serverPlayer.m_213846_((Component)Component.m_237115_((String)"elder_guardian.approach"));
                nbt.m_128379_("progressivebosses:adventure_message", true);
            }
        } else if (serverPlayer.f_8941_.m_9290_() == GameType.ADVENTURE && !nearElderGuardian && previouslyNearElderGuardian) {
            serverPlayer.f_8941_.m_143473_(GameType.SURVIVAL);
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132156_, (float)GameType.SURVIVAL.m_46392_()));
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity;
        if (!(this.isEnabled() && adventure.booleanValue() && (livingEntity = event.getEntity()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
        CompoundTag nbt = serverPlayer.getPersistentData();
        boolean previouslyNearElderGuardian = nbt.m_128471_("progressivebosses:previously_near_elder_guardian");
        if (previouslyNearElderGuardian && serverPlayer.f_8941_.m_9290_() == GameType.ADVENTURE) {
            serverPlayer.f_8941_.m_143473_(GameType.SURVIVAL);
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132156_, (float)GameType.SURVIVAL.m_46392_()));
        }
    }

    @SubscribeEvent
    public void onExplosionDetonate(ExplosionEvent.Start event) {
        boolean nearElderGuardian;
        if (!this.isEnabled() || !adventure.booleanValue() || event.getExplosion().getExploder() == null || event.getExplosion().f_46010_ == Explosion.BlockInteraction.KEEP) {
            return;
        }
        boolean bl = nearElderGuardian = !event.getLevel().m_45976_(ElderGuardian.class, event.getExplosion().getExploder().m_20191_().m_82400_(adventureRange.doubleValue())).isEmpty();
        if (nearElderGuardian) {
            event.setCanceled(true);
            event.getLevel().m_255391_(event.getExplosion().getExploder(), event.getExplosion().getPosition().f_82479_, event.getExplosion().getPosition().f_82480_, event.getExplosion().getPosition().f_82481_, event.getExplosion().f_46017_, event.getExplosion().f_46009_, Level.ExplosionInteraction.NONE);
        }
    }

    @SubscribeEvent
    public void onElderGuardianDeath(LivingDeathEvent event) {
        LivingEntity livingEntity;
        if (!this.isEnabled() || !((livingEntity = event.getEntity()) instanceof ElderGuardian)) {
            return;
        }
        ElderGuardian elderGuardian = (ElderGuardian)livingEntity;
        List elderGuardiansNearby = elderGuardian.m_9236_().m_6249_((Entity)elderGuardian, elderGuardian.m_20191_().m_82400_(64.0), entity -> entity instanceof ElderGuardian);
        if (elderGuardiansNearby.isEmpty()) {
            return;
        }
        CompoundTag nbt = elderGuardian.getPersistentData();
        int difficulty = nbt.m_128451_("progressivebosses:difficulty");
        elderGuardian.m_5496_(SoundEvents.f_11880_, 2.0f, 0.5f);
        for (Entity elderGuardianNearby : elderGuardiansNearby) {
            elderGuardianNearby.getPersistentData().m_128405_("progressivebosses:difficulty", difficulty + 1);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onSpawn(EntityJoinLevelEvent event) {
        Entity entity;
        if (event.getLevel().f_46443_ || !this.isEnabled() || !((entity = event.getEntity()) instanceof ElderGuardian)) {
            return;
        }
        ElderGuardian elderGuardian = (ElderGuardian)entity;
        CompoundTag nbt = elderGuardian.getPersistentData();
        if (nbt.m_128441_("progressivebosses:difficulty")) {
            return;
        }
        nbt.m_128405_("progressivebosses:difficulty", 0);
    }
}

