/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.config;

import com.hlysine.create_connected.compat.CreateConnectedJEI;
import com.hlysine.create_connected.compat.Mods;
import com.hlysine.create_connected.config.CCConfigs;
import com.hlysine.create_connected.config.CFeatures;
import com.hlysine.create_connected.mixin.featuretoggle.CreativeModeTabsAccessor;
import com.tterrag.registrate.builders.Builder;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;

public class FeatureToggle {
    public static final Set<ResourceLocation> TOGGLEABLE_FEATURES = new HashSet<ResourceLocation>();
    public static final Map<ResourceLocation, ResourceLocation> DEPENDENT_FEATURES = new HashMap<ResourceLocation, ResourceLocation>();

    public static void register(ResourceLocation key) {
        TOGGLEABLE_FEATURES.add(key);
    }

    public static void registerDependent(ResourceLocation key, ResourceLocation dependency) {
        DEPENDENT_FEATURES.put(key, dependency);
    }

    public static <R, T extends R, P, S extends Builder<R, T, P, S>> NonNullUnaryOperator<S> register() {
        return b -> {
            FeatureToggle.register(new ResourceLocation(b.getOwner().getModid(), b.getName()));
            return b;
        };
    }

    public static <R, T extends R, P, S extends Builder<R, T, P, S>> NonNullUnaryOperator<S> registerDependent(ResourceLocation dependency) {
        return b -> {
            FeatureToggle.registerDependent(new ResourceLocation(b.getOwner().getModid(), b.getName()), dependency);
            return b;
        };
    }

    public static <R, T extends R, P, S extends Builder<R, T, P, S>> NonNullUnaryOperator<S> registerDependent(BlockEntry<?> dependency) {
        return b -> {
            FeatureToggle.registerDependent(new ResourceLocation(b.getOwner().getModid(), b.getName()), dependency.getId());
            return b;
        };
    }

    private static CFeatures getToggles() {
        return CCConfigs.common().toggle;
    }

    public static boolean isEnabled(ResourceLocation key) {
        if (FeatureToggle.getToggles().hasToggle(key)) {
            return FeatureToggle.getToggles().isEnabled(key);
        }
        ResourceLocation dependency = DEPENDENT_FEATURES.get(key);
        if (dependency != null) {
            return FeatureToggle.isEnabled(dependency);
        }
        return true;
    }

    static void refreshItemVisibility() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ((BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.CLIENT)).m_18707_(() -> {
            CreativeModeTab.ItemDisplayParameters cachedParameters = CreativeModeTabsAccessor.getCACHED_PARAMETERS();
            if (cachedParameters != null) {
                CreativeModeTabsAccessor.callBuildAllTabContents(cachedParameters);
            }
            Mods.JEI.executeIfInstalled(() -> CreateConnectedJEI::refreshItemList);
        }));
    }
}

