/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.goated.forge;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.mehvahdjukaar.goated.common.BreakMemory;
import net.mehvahdjukaar.goated.forge.GoatedForge;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class RamBreakingCap
implements ICapabilitySerializable<CompoundTag> {
    private static final int MAX_TIME = 200;
    private final LazyOptional<RamBreakingCap> lazyOptional = LazyOptional.of(() -> this);
    private final Map<BlockPos, BreakMemory> breakProgress = new HashMap<BlockPos, BreakMemory>();
    private final ServerLevel level;

    RamBreakingCap(ServerLevel level) {
        this.level = level;
    }

    public void invalidate() {
        this.lazyOptional.invalidate();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return GoatedForge.RAM_BREAK_CAP.orEmpty(cap, this.lazyOptional);
    }

    public CompoundTag serializeNBT() {
        CompoundTag total = new CompoundTag();
        ListTag l = new ListTag();
        this.breakProgress.values().forEach(s -> l.add((Object)s.save()));
        total.m_128365_("RamBreakProgress", (Tag)l);
        return total;
    }

    public void deserializeNBT(CompoundTag tag) {
        ListTag l = tag.m_128437_("RamBreakProgress", 10);
        for (Tag t : l) {
            BreakMemory m = BreakMemory.load((CompoundTag)t, (Level)this.level);
            this.breakProgress.put(m.getPos(), m);
        }
    }

    public void validateAll() {
        if (!this.breakProgress.isEmpty()) {
            ArrayList<BlockPos> values = new ArrayList<BlockPos>(this.breakProgress.keySet());
            for (BlockPos pos : values) {
                BreakMemory m = this.breakProgress.get(pos);
                if (m == null || this.level.m_8055_(pos) == m.getState() && this.level.m_46467_() - m.getTimestamp() <= 200L) continue;
                this.level.m_6801_(m.getBreakerId(), pos, -1);
                this.breakProgress.remove(pos);
            }
        }
    }

    public BreakMemory getOrCreateBreakMemory(BlockPos pos, BlockState state) {
        BreakMemory memory = this.breakProgress.get(pos);
        if (memory == null || memory.getState() != state) {
            memory = new BreakMemory(state, pos);
            this.breakProgress.put(pos, memory);
        }
        return memory;
    }
}

