/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.goated.common;

import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.goated.Goated;
import net.mehvahdjukaar.goated.common.GeepAI;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.jetbrains.annotations.Nullable;

public class Geep
extends Animal
implements Shearable {
    public static final EntityDimensions LONG_JUMPING_DIMENSIONS = Goat.f_149342_;
    protected static final List<SensorType<? extends Sensor<? super Geep>>> SENSOR_TYPES = List.of(SensorType.f_26811_, SensorType.f_26812_, SensorType.f_26810_, Goated.GEEP_ADULT_SENSOR.get(), SensorType.f_26814_, SensorType.f_148317_);
    protected static final List<MemoryModuleType<?>> MEMORY_TYPES = List.of(MemoryModuleType.f_26371_, MemoryModuleType.f_148205_, MemoryModuleType.f_26370_, MemoryModuleType.f_26326_, MemoryModuleType.f_26377_, MemoryModuleType.f_26355_, MemoryModuleType.f_148199_, MemoryModuleType.f_148200_, MemoryModuleType.f_148196_, MemoryModuleType.f_26331_, MemoryModuleType.f_148197_, MemoryModuleType.f_148198_, MemoryModuleType.f_217768_);
    public static final int GOAT_FALL_DAMAGE_REDUCTION = 10;
    public static final EntityDataAccessor<Boolean> IS_SHEARED = SynchedEntityData.m_135353_(Geep.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int lowerHeadTick;
    private int eatAnimationTick;
    private int infestationCounter = 0;

    public Geep(EntityType<? extends Geep> entityType, Level level) {
        super(entityType, level);
        this.m_21573_().m_7008_(true);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, -1.0f);
    }

    protected ResourceLocation m_7582_() {
        ResourceLocation r = super.m_7582_();
        if (!this.isSheared()) {
            r = new ResourceLocation(r.m_135827_(), r.m_135815_() + "_wool");
        }
        return r;
    }

    protected Brain.Provider<Geep> m_5490_() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<Geep> m_8075_(Dynamic<?> dynamic) {
        return GeepAI.makeBrain((Brain<Geep>)this.m_5490_().m_22073_(dynamic));
    }

    protected int m_5639_(float fallDistance, float damageMultiplier) {
        return super.m_5639_(fallDistance, damageMultiplier) - 10;
    }

    protected SoundEvent m_7515_() {
        return Goated.AMBIENT_SOUND.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return Goated.HURT_SOUND.get();
    }

    protected SoundEvent m_5592_() {
        return Goated.DEATH_SOUND.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_144151_, 0.15f, 1.0f);
    }

    protected SoundEvent getMilkingSound() {
        return Goated.MILK_SOUND.get();
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob otherParent) {
        return (AgeableMob)this.m_6095_().m_20615_((Level)level);
    }

    protected void m_8024_() {
        Optional memory;
        Level level = this.m_9236_();
        this.m_6274_().m_21865_((ServerLevel)level, (LivingEntity)this);
        GeepAI.updateActivity(this);
        if (this.infestationCounter > 0) {
            --this.infestationCounter;
        } else if (level.m_46467_() % 200L == 0L && level.f_46441_.m_188503_(20) == 0 && (memory = this.f_20939_.m_21952_(MemoryModuleType.f_148204_)).isPresent()) {
            List l = (List)memory.get();
            ArrayList<Geep> geeps = new ArrayList<Geep>();
            int count = 0;
            for (LivingEntity e : l) {
                if (!(e instanceof Geep)) continue;
                Geep g = (Geep)e;
                geeps.add(g);
                if (e.m_20280_((Entity)this) < 64.0) {
                    ++count;
                }
                if (count < 5) continue;
                this.m_216990_(Goated.INFESTATION_SOUND.get());
                geeps.forEach(gg -> {
                    gg.infestationCounter = 600;
                });
                this.infestationCounter = 1200;
                break;
            }
        }
        super.m_8024_();
    }

    public void m_8107_() {
        if (this.m_9236_().f_46443_) {
            this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
        }
        super.m_8107_();
    }

    public void m_7822_(byte id) {
        if (id == 10) {
            this.eatAnimationTick = 40;
        } else {
            super.m_7822_(id);
        }
    }

    public void m_8035_() {
        super.m_8035_();
        this.setSheared(false);
        if (this.m_6162_()) {
            this.m_146758_(60);
        }
    }

    public Brain<Geep> m_6274_() {
        return super.m_6274_();
    }

    public int m_8085_() {
        return 15;
    }

    public void m_5616_(float yHeadRot) {
        int i = this.m_8085_();
        float f = Mth.m_14118_((float)this.f_20883_, (float)yHeadRot);
        float g = Mth.m_14036_((float)f, (float)(-i), (float)i);
        super.m_5616_(this.f_20883_ + g);
    }

    public SoundEvent m_7866_(ItemStack stack) {
        return Goated.EAT_SOUND.get();
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        Level level = this.m_9236_();
        if (itemStack.m_150930_(Items.f_42446_) && !this.m_6162_()) {
            player.m_5496_(this.getMilkingSound(), 1.0f, 1.0f);
            ItemStack itemStack2 = ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)Items.f_42455_.m_7968_());
            player.m_21008_(hand, itemStack2);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (itemStack.m_150930_(Items.f_42574_)) {
            if (!level.f_46443_ && this.m_6220_()) {
                this.m_5851_(SoundSource.PLAYERS);
                this.m_146852_(GameEvent.f_157781_, (Entity)player);
                itemStack.m_41622_(1, (LivingEntity)player, player1 -> player1.m_21190_(hand));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        InteractionResult interactionResult = super.m_6071_(player, hand);
        if (interactionResult.m_19077_() && this.m_6898_(itemStack)) {
            level.m_6269_(null, (Entity)this, this.m_7866_(itemStack), SoundSource.NEUTRAL, 1.0f, Mth.m_216283_((RandomSource)level.f_46441_, (float)0.8f, (float)1.2f));
        }
        return interactionResult;
    }

    public void m_27595_(@Nullable Player player) {
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        RandomSource randomSource = level.m_213780_();
        GeepAI.initMemories(this, randomSource);
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    protected void m_8025_() {
        super.m_8025_();
        DebugPackets.m_133695_((LivingEntity)this);
    }

    public EntityDimensions m_6972_(Pose pose) {
        return pose == Pose.LONG_JUMPING ? LONG_JUMPING_DIMENSIONS.m_20388_(this.m_6134_()) : super.m_6972_(pose);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Sheared", this.isSheared());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setSheared(compound.m_128471_("Sheared"));
    }

    public boolean isSheared() {
        return (Boolean)this.f_19804_.m_135370_(IS_SHEARED);
    }

    public void setSheared(boolean sheared) {
        this.f_19804_.m_135381_(IS_SHEARED, (Object)sheared);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_SHEARED, (Object)false);
    }

    public float getRammingXHeadRot() {
        return (float)this.lowerHeadTick / 20.0f * 30.0f * ((float)Math.PI / 180);
    }

    public float getHeadEatPositionScale(float partialTick) {
        if (this.eatAnimationTick <= 0) {
            return 0.0f;
        }
        if (this.eatAnimationTick >= 4 && this.eatAnimationTick <= 36) {
            return 1.0f;
        }
        return this.eatAnimationTick < 4 ? ((float)this.eatAnimationTick - partialTick) / 4.0f : -((float)(this.eatAnimationTick - 40) - partialTick) / 4.0f;
    }

    public float getHeadEatAngleScale(float partialTick) {
        if (this.eatAnimationTick > 4 && this.eatAnimationTick <= 36) {
            float f = ((float)(this.eatAnimationTick - 4) - partialTick) / 32.0f;
            return 0.62831855f + 0.21991149f * Mth.m_14031_((float)(f * 28.7f));
        }
        if (this.eatAnimationTick > 0) {
            return 0.62831855f;
        }
        return this.m_5686_(partialTick) * ((float)Math.PI / 180);
    }

    public boolean m_6220_() {
        return this.m_6084_() && !this.isSheared() && !this.m_6162_();
    }

    public void m_5851_(SoundSource source) {
        this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12344_, source, 1.0f, 1.0f);
        this.setSheared(true);
        int i = 1 + this.f_19796_.m_188503_(3);
        for (int j = 0; j < i; ++j) {
            ItemEntity itementity = this.m_20000_((ItemLike)Items.f_41870_, 1);
            if (itementity == null) continue;
            itementity.m_20256_(itementity.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.05f), (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f)));
        }
    }

    public static boolean checkGoatSpawnRules(EntityType<? extends Animal> goat, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_184230_) && Geep.m_186209_((BlockAndTintGetter)level, (BlockPos)pos);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 9.0).m_22268_(Attributes.f_22279_, (double)0.215f);
    }
}

