/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.type;

import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.MirrorAxis;
import com.blamejared.crafttweaker.api.recipe.fun.RecipeFunction2D;
import com.blamejared.crafttweaker.api.recipe.serializer.CTShapedRecipeSerializer;
import com.blamejared.crafttweaker.api.util.ArrayUtil;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class CTShapedRecipe
extends ShapedRecipe {
    private static final Pair<Integer, Integer> INVALID = Pair.of((Object)-1, (Object)-1);
    private final IIngredient[][] ingredients;
    private final IIngredient[][][] mirroredIngredients;
    private final IItemStack output;
    private final MirrorAxis mirrorAxis;
    @Nullable
    private final RecipeFunction2D function;

    public CTShapedRecipe(String name, IItemStack output, IIngredient[][] ingredients, MirrorAxis mirrorAxis, @Nullable RecipeFunction2D function) {
        this(name, CraftingBookCategory.MISC, output, ingredients, mirrorAxis, function);
    }

    public CTShapedRecipe(String name, CraftingBookCategory category, IItemStack output, IIngredient[][] ingredients, MirrorAxis mirrorAxis, @Nullable RecipeFunction2D function) {
        super(CraftTweakerConstants.rl(name), "", category, CTShapedRecipe.getMaxWidth(ingredients), ingredients.length, NonNullList.m_122779_(), output.getInternal());
        this.output = output;
        this.ingredients = ingredients;
        this.mirrorAxis = mirrorAxis;
        this.function = function;
        this.mirroredIngredients = new IIngredient[MirrorAxis.values().length][][];
        for (int index = 0; index < this.ingredients.length; ++index) {
            if (this.ingredients[index].length >= this.m_44220_()) continue;
            this.ingredients[index] = ArrayUtil.copyOf(this.ingredients[index], this.m_44220_(), IItemStack.empty());
        }
        this.initMirroredIngredients();
    }

    private static int getMaxWidth(IIngredient[][] array) {
        return Arrays.stream(array).mapToInt(row -> ((IIngredient[])row).length).max().orElse(0);
    }

    private void initMirroredIngredients() {
        this.mirroredIngredients[MirrorAxis.NONE.ordinal()] = this.ingredients;
        if (this.mirrorAxis.isMirrored()) {
            int i;
            IIngredient[][] workingIngredients;
            if (this.mirrorAxis.isVertical()) {
                this.mirroredIngredients[MirrorAxis.VERTICAL.ordinal()] = (IIngredient[][])ArrayUtil.mirror(this.ingredients);
            }
            if (this.mirrorAxis.isHorizontal()) {
                workingIngredients = (IIngredient[][])ArrayUtil.copy(this.ingredients);
                for (i = 0; i < workingIngredients.length; ++i) {
                    workingIngredients[i] = ArrayUtil.mirror(workingIngredients[i]);
                }
                this.mirroredIngredients[MirrorAxis.HORIZONTAL.ordinal()] = workingIngredients;
            }
            if (this.mirrorAxis.isDiagonal()) {
                workingIngredients = (IIngredient[][])ArrayUtil.mirror(this.ingredients);
                for (i = 0; i < workingIngredients.length; ++i) {
                    workingIngredients[i] = ArrayUtil.mirror(workingIngredients[i]);
                }
                this.mirroredIngredients[MirrorAxis.DIAGONAL.ordinal()] = workingIngredients;
            }
        }
    }

    private Pair<Integer, Integer> calculateOffset(CraftingContainer inv) {
        Pair<Integer, Integer> offset = this.calculateOffset(this.mirroredIngredients[MirrorAxis.NONE.ordinal()], inv);
        if (this.isValidOffset(offset) || !this.mirrorAxis.isMirrored()) {
            return offset;
        }
        if (this.mirrorAxis.isVertical() && this.isValidOffset(offset = this.calculateOffset(this.mirroredIngredients[MirrorAxis.VERTICAL.ordinal()], inv))) {
            return offset;
        }
        if (this.mirrorAxis.isHorizontal() && this.isValidOffset(offset = this.calculateOffset(this.mirroredIngredients[MirrorAxis.HORIZONTAL.ordinal()], inv))) {
            return offset;
        }
        if (this.mirrorAxis.isDiagonal() && this.isValidOffset(offset = this.calculateOffset(this.mirroredIngredients[MirrorAxis.DIAGONAL.ordinal()], inv))) {
            return offset;
        }
        return INVALID;
    }

    private Pair<Integer, Integer> calculateOffset(IIngredient[][] test, CraftingContainer inv) {
        for (int rowOffset = 0; rowOffset <= inv.m_39346_() - test.length; ++rowOffset) {
            block1: for (int columnOffset = 0; columnOffset <= inv.m_39347_() - test[0].length; ++columnOffset) {
                boolean[] visited = new boolean[inv.m_6643_()];
                for (int rowIndex = 0; rowIndex < test.length; ++rowIndex) {
                    IIngredient[] row = test[rowIndex];
                    for (int columnIndex = 0; columnIndex < row.length; ++columnIndex) {
                        IIngredient item = row[columnIndex];
                        int slotNumber = (rowIndex + rowOffset) * inv.m_39347_() + columnIndex + columnOffset;
                        ItemStack stackInSlot = inv.m_8020_(slotNumber);
                        if (item == null && !stackInSlot.m_41619_() || item != null && !item.matches(IItemStack.ofMutable(stackInSlot))) continue block1;
                        visited[slotNumber] = true;
                    }
                }
                for (int i = 0; i < visited.length; ++i) {
                    if (!visited[i] && !inv.m_8020_(i).m_41619_()) continue block1;
                }
                return Pair.of((Object)rowOffset, (Object)columnOffset);
            }
        }
        return INVALID;
    }

    public boolean m_5818_(CraftingContainer inv, @Nullable Level worldIn) {
        return this.isValidOffset(this.calculateOffset(inv));
    }

    public ItemStack m_5874_(CraftingContainer container) {
        Pair<Integer, Integer> offset = this.calculateOffset(container);
        if (offset == INVALID) {
            return ItemStack.f_41583_;
        }
        if (this.function == null) {
            return this.m_8043_();
        }
        int rowOffset = (Integer)offset.getFirst();
        int columnOffset = (Integer)offset.getSecond();
        IItemStack[][] stacks = new IItemStack[this.m_44221_()][this.m_44220_()];
        for (int rowIndex = 0; rowIndex < this.ingredients.length; ++rowIndex) {
            IIngredient[] row = this.ingredients[rowIndex];
            for (int columnIndex = 0; columnIndex < row.length; ++columnIndex) {
                IIngredient ingredient = row[columnIndex];
                if (ingredient == null) continue;
                int slotIndex = (rowIndex + rowOffset) * container.m_39347_() + columnIndex + columnOffset;
                stacks[rowIndex][columnIndex] = IItemStack.of(container.m_8020_(slotIndex)).setAmount(1);
            }
        }
        return this.function.process(this.output, stacks).getImmutableInternal();
    }

    public ItemStack m_8043_() {
        return this.output.getInternal().m_41777_();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        IIngredient[][] workingIngredients = this.mirroredIngredients[MirrorAxis.NONE.ordinal()];
        Pair<Integer, Integer> offset = this.calculateOffset(workingIngredients, inv);
        if (offset != INVALID || !this.mirrorAxis.isMirrored()) {
            return this.getRemainingItems(inv, offset, workingIngredients);
        }
        if (this.mirrorAxis.isVertical() && (offset = this.calculateOffset(workingIngredients = this.mirroredIngredients[MirrorAxis.VERTICAL.ordinal()], inv)) != INVALID) {
            return this.getRemainingItems(inv, offset, workingIngredients);
        }
        if (this.mirrorAxis.isHorizontal() && (offset = this.calculateOffset(workingIngredients = this.mirroredIngredients[MirrorAxis.HORIZONTAL.ordinal()], inv)) != INVALID) {
            return this.getRemainingItems(inv, offset, workingIngredients);
        }
        if (this.mirrorAxis.isDiagonal()) {
            workingIngredients = this.mirroredIngredients[MirrorAxis.DIAGONAL.ordinal()];
            offset = this.calculateOffset(workingIngredients, inv);
        }
        return this.getRemainingItems(inv, offset, workingIngredients);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv, Pair<Integer, Integer> offsetPair, IIngredient[][] ingredients) {
        NonNullList result = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        if (offsetPair == INVALID) {
            return result;
        }
        int rowOffset = (Integer)offsetPair.getFirst();
        int columnOffset = (Integer)offsetPair.getSecond();
        for (int rowIndex = 0; rowIndex < ingredients.length; ++rowIndex) {
            IIngredient[] row = ingredients[rowIndex];
            for (int columnIndex = 0; columnIndex < row.length; ++columnIndex) {
                IIngredient ingredient = row[columnIndex];
                if (ingredient == null) continue;
                int slotIndex = (rowIndex + rowOffset) * inv.m_39347_() + columnIndex + columnOffset;
                result.set(slotIndex, (Object)ingredient.getRemainingItem(IItemStack.ofMutable(inv.m_8020_(slotIndex))).getInternal());
            }
        }
        return result;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_122780_((int)(this.m_44221_() * this.m_44220_()), (Object)Ingredient.f_43901_);
        for (int row = 0; row < this.ingredients.length; ++row) {
            IIngredient[] ingredientRow = this.ingredients[row];
            for (int column = 0; column < ingredientRow.length; ++column) {
                ingredients.set(row * this.m_44220_() + column, (Object)ingredientRow[column].asVanillaIngredient());
            }
        }
        return ingredients;
    }

    public RecipeSerializer<CTShapedRecipe> m_7707_() {
        return CTShapedRecipeSerializer.INSTANCE;
    }

    public IIngredient[][] getCtIngredients() {
        return this.ingredients;
    }

    public IItemStack getCtOutput() {
        return this.output;
    }

    @Nullable
    public RecipeFunction2D getFunction() {
        return this.function;
    }

    public boolean isMirrored() {
        return this.mirrorAxis.isMirrored();
    }

    public MirrorAxis getMirrorAxis() {
        return this.mirrorAxis;
    }

    private boolean isValidOffset(Pair<Integer, Integer> pair) {
        return !pair.equals(INVALID);
    }

    public boolean m_142505_() {
        NonNullList<Ingredient> ingredients = this.m_7527_();
        return ingredients.isEmpty() || ingredients.stream().filter(ingredient -> !ingredient.m_43947_()).anyMatch(ingredient -> ingredient.m_43908_().length == 0);
    }
}

