/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.logging.CommonLoggers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;

public class RecipeList<T extends Recipe<?>> {
    private final RecipeType<T> recipeType;
    private final Map<ResourceLocation, T> recipes;
    private final Map<ResourceLocation, Recipe<?>> byName;
    private final Map<ResourceLocation, T> unmodifiableRecipes;
    private final Map<ResourceLocation, Recipe<?>> unmodifiableByName;

    public RecipeList(RecipeType<T> recipeType, Map<ResourceLocation, T> recipes, Map<ResourceLocation, Recipe<?>> byName) {
        this.recipeType = recipeType;
        this.recipes = recipes;
        this.byName = byName;
        this.unmodifiableRecipes = Collections.unmodifiableMap(recipes);
        this.unmodifiableByName = Collections.unmodifiableMap(byName);
    }

    public List<T> getRecipesByOutput(IIngredient output) {
        return this.getRecipes().values().stream().filter(iRecipe -> output.matches(IItemStack.ofMutable(iRecipe.m_8043_()))).toList();
    }

    public List<T> getAllRecipes() {
        return new ArrayList<T>(this.getRecipes().values());
    }

    public T get(ResourceLocation id) {
        return (T)((Recipe)this.getRecipes().get(id));
    }

    public T get(String id) {
        return this.get(ResourceLocation.m_135820_((String)id));
    }

    public boolean has(ResourceLocation id) {
        return this.getRecipes().containsKey(id);
    }

    public boolean has(String id) {
        return this.has(ResourceLocation.m_135820_((String)id));
    }

    public void add(ResourceLocation id, T recipe) {
        if (this.getByName().containsKey(recipe.m_6423_())) {
            CommonLoggers.api().warn("A recipe with the name '{}' already exists and will be overwritten: this is most likely an error in your scripts", (Object)recipe.m_6423_().m_135815_());
        }
        this.recipes.put(id, recipe);
        this.byName.put(id, (Recipe<?>)recipe);
    }

    public void remove(ResourceLocation id) {
        this.recipes.remove(id);
        this.byName.remove(id);
    }

    public void removeByRecipeTest(Predicate<T> recipePredicate) {
        Iterator<ResourceLocation> iterator = this.recipes.keySet().iterator();
        while (iterator.hasNext()) {
            ResourceLocation next = iterator.next();
            Recipe recipe = (Recipe)this.recipes.get(next);
            if (!recipePredicate.test(recipe)) continue;
            this.byName.remove(next);
            iterator.remove();
        }
    }

    public void removeByIdTest(Predicate<ResourceLocation> idPredicate) {
        this.removeByIdTest(idPredicate, s -> false);
    }

    public void removeByIdTest(Predicate<ResourceLocation> idPredicate, Predicate<String> exclusions) {
        Iterator<ResourceLocation> iterator = this.recipes.keySet().iterator();
        while (iterator.hasNext()) {
            ResourceLocation next = iterator.next();
            if (!idPredicate.test(next) || exclusions.test(next.m_135815_())) continue;
            this.byName.remove(next);
            iterator.remove();
        }
    }

    public void removeAll() {
        this.byName.keySet().removeAll(this.recipes.keySet());
        this.recipes.clear();
    }

    public RecipeType<T> getRecipeType() {
        return this.recipeType;
    }

    public Map<ResourceLocation, T> getRecipes() {
        return this.unmodifiableRecipes;
    }

    public Map<ResourceLocation, Recipe<?>> getByName() {
        return this.unmodifiableByName;
    }

    public int getSize() {
        return this.getRecipes().size();
    }
}

