/*
 * Decompiled with CFR 0.152.
 */
package com.shutdowner.handlers;

import com.shutdowner.Shutdowner;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ShutDownHandler {
    private static int tickTimer = 0;
    private static final int TICK_INTERVAL = 20;
    private static long shutdownInterval = 600L;
    private static long serverStartedTime = 0L;
    private static int secondsPassed = 0;
    private static int announceMentIndex = 0;
    public static final List<Tuple<Integer, String>> announcements = new ArrayList<Tuple<Integer, String>>();
    public static final List<Tuple<Integer, Integer>> shutdownTimes = new ArrayList<Tuple<Integer, Integer>>();

    public static void onServerTick() {
        if (++tickTimer == 20 && ((Boolean)Shutdowner.getConfig().getCommonConfig().shouldAutoShutDown.get()).booleanValue()) {
            tickTimer = 0;
            secondsPassed = Math.round((float)(System.currentTimeMillis() - serverStartedTime) / 1000.0f);
            ShutDownHandler.announceShutdown();
            if ((long)secondsPassed > shutdownInterval && (long)secondsPassed > shutdownInterval + 1L) {
                ArrayList playerss = new ArrayList(ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_());
                playerss.forEach(player -> player.f_8906_.m_9942_((Component)Component.m_237113_((String)((String)Shutdowner.getConfig().getCommonConfig().disconnectMessage.get()))));
                serverStartedTime = System.currentTimeMillis();
                ServerLifecycleHooks.getCurrentServer().m_7570_(false);
            }
        }
    }

    private static long getTimeToNextShutdown() {
        long max = 240000L;
        for (Tuple<Integer, Integer> shutdownTime : shutdownTimes) {
            LocalTime localShutdownTime = LocalTime.of((Integer)shutdownTime.m_14418_(), (Integer)shutdownTime.m_14419_());
            long diff = LocalTime.now().until(localShutdownTime, ChronoUnit.SECONDS);
            if (diff < 0L) {
                diff += 86400L;
            }
            if (diff >= max || diff < 0L) continue;
            max = diff;
        }
        return max;
    }

    public static void announceShutdown() {
        long secondsLeft = shutdownInterval - (long)secondsPassed;
        if (announceMentIndex < announcements.size() && secondsLeft <= (long)((Integer)announcements.get(announceMentIndex).m_14418_()).intValue()) {
            Shutdowner.LOGGER.info((String)announcements.get(announceMentIndex).m_14419_());
            for (Player player : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
                player.m_5661_((Component)Component.m_237113_((String)((String)announcements.get(announceMentIndex).m_14419_())), false);
            }
            ++announceMentIndex;
        }
    }

    public static void reset() {
        serverStartedTime = System.currentTimeMillis();
        announceMentIndex = 0;
        shutdownInterval = ShutDownHandler.getTimeToNextShutdown();
    }

    public static void onServerStart() {
        ShutDownHandler.reset();
    }
}

