/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.utils;

import forge.org.figuramc.figura.avatar.Avatar;
import forge.org.figuramc.figura.lua.api.vanilla_model.VanillaPart;
import forge.org.figuramc.figura.permissions.Permissions;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.inventory.InventoryMenu;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class RenderUtils {
    public static boolean vanillaModel(Avatar avatar) {
        return avatar != null && avatar.permissions.get(Permissions.VANILLA_MODEL_EDIT) >= 1;
    }

    public static boolean vanillaModelAndScript(Avatar avatar) {
        return avatar != null && avatar.luaRuntime != null && avatar.permissions.get(Permissions.VANILLA_MODEL_EDIT) >= 1;
    }

    public static TextureAtlasSprite firstFireLayer(Avatar avatar) {
        if (!RenderUtils.vanillaModelAndScript(avatar)) {
            return null;
        }
        ResourceLocation layer = avatar.luaRuntime.renderer.fireLayer1;
        return layer != null ? (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(layer) : null;
    }

    public static TextureAtlasSprite secondFireLayer(Avatar avatar) {
        if (!RenderUtils.vanillaModelAndScript(avatar)) {
            return null;
        }
        ResourceLocation layer1 = avatar.luaRuntime.renderer.fireLayer1;
        ResourceLocation layer2 = avatar.luaRuntime.renderer.fireLayer2;
        if (layer2 != null) {
            return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(layer2);
        }
        if (layer1 != null) {
            return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(layer1);
        }
        return null;
    }

    public static VanillaPart partFromSlot(Avatar avatar, EquipmentSlot equipmentSlot) {
        if (!RenderUtils.vanillaModelAndScript(avatar)) {
            return null;
        }
        return switch (equipmentSlot) {
            case EquipmentSlot.HEAD -> avatar.luaRuntime.vanilla_model.HELMET;
            case EquipmentSlot.CHEST -> avatar.luaRuntime.vanilla_model.CHESTPLATE;
            case EquipmentSlot.LEGS -> avatar.luaRuntime.vanilla_model.LEGGINGS;
            case EquipmentSlot.FEET -> avatar.luaRuntime.vanilla_model.BOOTS;
            default -> null;
        };
    }

    public static boolean renderArmItem(Avatar avatar, boolean lefty, CallbackInfo ci) {
        if (!RenderUtils.vanillaModel(avatar)) {
            return false;
        }
        if (avatar.luaRuntime != null && (lefty && !avatar.luaRuntime.vanilla_model.LEFT_ITEM.checkVisible() || !lefty && !avatar.luaRuntime.vanilla_model.RIGHT_ITEM.checkVisible())) {
            ci.cancel();
            return false;
        }
        return true;
    }
}

