/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.parsers;

import forge.org.figuramc.figura.FiguraMod;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.ast.Block;
import org.luaj.vm2.ast.Exp;
import org.luaj.vm2.ast.FuncArgs;
import org.luaj.vm2.ast.FuncBody;
import org.luaj.vm2.ast.Name;
import org.luaj.vm2.ast.NameScope;
import org.luaj.vm2.ast.ParList;
import org.luaj.vm2.ast.Stat;
import org.luaj.vm2.ast.TableConstructor;
import org.luaj.vm2.ast.TableField;
import org.luaj.vm2.ast.Variable;
import org.luaj.vm2.ast.Visitor;

public class LuaScriptBuilderVisitor
extends Visitor {
    private static final char[] chars;
    private final StringBuilder builder;
    private final Map<Variable, String> vars = new HashMap<Variable, String>();
    private final Stack<NameScope> scopes = new Stack();
    private boolean blockStandalone = false;

    public LuaScriptBuilderVisitor() {
        this(new StringBuilder());
    }

    public LuaScriptBuilderVisitor(StringBuilder builder) {
        this.builder = builder;
    }

    private static String makeName(int count) {
        StringBuilder res = new StringBuilder();
        int pow = 52;
        int i = 0;
        if (count > pow) {
            ++pow;
            while (count >= pow) {
                count -= pow;
                pow *= 63;
                ++i;
            }
        }
        for (int j = 0; j < i; ++j) {
            res.insert(0, chars[count % 63]);
            count /= 63;
        }
        res.insert(0, chars[count]);
        return res.toString();
    }

    private void pushScope(NameScope scope) {
        block0: for (Variable variable : scope.namedVariables.values()) {
            if (!variable.isLocal()) continue;
            for (Variable var2 : this.vars.keySet().stream().sorted(Comparator.comparing(var -> var.name)).toList()) {
                if (var2 == variable) continue block0;
                if (!var2.name.equals(variable.name)) continue;
                this.vars.put(variable, this.vars.get(var2));
                continue block0;
            }
            this.vars.putIfAbsent(variable, LuaScriptBuilderVisitor.makeName(this.vars.size()));
        }
        this.scopes.push(scope);
    }

    private void popScope() {
        NameScope scope = this.scopes.pop();
        for (Variable variable : scope.namedVariables.values()) {
            if (variable.definingScope != scope) continue;
            this.vars.remove(variable);
        }
    }

    public void visit(NameScope scope) {
        this.pushScope(scope);
    }

    public void visit(Block block) {
        boolean thisStandalone = this.blockStandalone;
        this.blockStandalone = true;
        if (thisStandalone) {
            this.newlineIfName("do");
        }
        try (ScopedBody b = new ScopedBody(block.scope);){
            if (block.stats != null) {
                for (Stat element : block.stats) {
                    element.accept((Visitor)this);
                }
            }
        }
        if (thisStandalone) {
            this.newlineIfName("end");
        }
    }

    public void visit(Stat.Assign stat) {
        this.visitVars(stat.vars);
        this.builder.append('=');
        this.visitExps(stat.exps);
    }

    public void visit(Stat.Break breakstat) {
        this.newlineIfName("break");
    }

    public void visit(Stat.FuncDef stat) {
        this.newlineIfName("function");
        if (stat.name.name != null) {
            this.visit(stat.name.name);
        }
        if (stat.name.dots != null) {
            for (String s : stat.name.dots) {
                this.builder.append(".").append(s);
            }
        }
        if (stat.name.method != null) {
            this.builder.append(":").append(stat.name.method);
        }
        stat.body.accept((Visitor)this);
    }

    public void visit(Stat.GenericFor stat) {
        try (ScopedBody b = new ScopedBody(stat.scope);){
            this.newlineIfName("for");
            this.visitNames(stat.names);
            this.spaceIfName("in");
            this.visitExps(stat.exps);
            this.spaceIfName("do");
            this.blockStandalone = false;
            stat.block.accept((Visitor)this);
            this.newlineIfName("end");
        }
    }

    public void visit(Stat.IfThenElse stat) {
        this.newlineIfName("if");
        stat.ifexp.accept((Visitor)this);
        this.spaceIfName("then");
        this.blockStandalone = false;
        stat.ifblock.accept((Visitor)this);
        if (stat.elseifblocks != null) {
            int n = stat.elseifblocks.size();
            for (int i = 0; i < n; ++i) {
                this.newlineIfName("elseif");
                ((Exp)stat.elseifexps.get(i)).accept((Visitor)this);
                this.spaceIfName("then");
                this.blockStandalone = false;
                ((Block)stat.elseifblocks.get(i)).accept((Visitor)this);
            }
        }
        if (stat.elseblock != null) {
            this.newlineIfName("else");
            this.blockStandalone = false;
            stat.elseblock.accept((Visitor)this);
        }
        this.newlineIfName("end");
    }

    public void visit(Stat.LocalAssign stat) {
        this.newlineIfName("local");
        this.visitNames(stat.names);
        if (stat.values != null) {
            this.builder.append('=');
        }
        this.visitExps(stat.values);
    }

    public void visit(Stat.LocalFuncDef stat) {
        this.newlineIfName("local function");
        super.visit(stat);
    }

    public void visit(Stat.NumericFor stat) {
        try (ScopedBody b = new ScopedBody(stat.scope);){
            this.newlineIfName("for ");
            this.visit(stat.name);
            this.builder.append("=");
            stat.initial.accept((Visitor)this);
            this.builder.append(",");
            stat.limit.accept((Visitor)this);
            if (stat.step != null) {
                this.builder.append(",");
                stat.step.accept((Visitor)this);
            }
            this.spaceIfName("do");
            this.blockStandalone = false;
            stat.block.accept((Visitor)this);
            this.newlineIfName("end");
        }
    }

    public void visit(Stat.RepeatUntil stat) {
        this.newlineIfName("repeat");
        this.blockStandalone = false;
        stat.block.accept((Visitor)this);
        this.newlineIfName("until");
        stat.exp.accept((Visitor)this);
    }

    public void visit(Stat.Return stat) {
        this.newlineIfName("return");
        super.visit(stat);
    }

    public void visit(Stat.WhileDo stat) {
        this.newlineIfName("while");
        stat.exp.accept((Visitor)this);
        this.spaceIfName("do");
        this.blockStandalone = false;
        stat.block.accept((Visitor)this);
        this.newlineIfName("end");
    }

    public void visit(FuncBody body) {
        try (ScopedBody b = new ScopedBody(body.scope);){
            body.parlist.accept((Visitor)this);
            this.blockStandalone = false;
            body.block.accept((Visitor)this);
            this.newlineIfName("end");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void visit(FuncArgs args) {
        Object e;
        List exps = args.exps;
        if (exps != null && exps.size() == 1 && (e = exps.get(0)) instanceof Exp.Constant) {
            Exp.Constant constant = (Exp.Constant)e;
            if (constant.value instanceof LuaString) {
                constant.accept((Visitor)this);
                return;
            }
        }
        this.builder.append("(");
        super.visit(args);
        this.builder.append(")");
    }

    public void visit(TableField field) {
        if (field.name != null || field.index != null) {
            if (field.name != null) {
                this.visit(field.name);
            } else {
                this.builder.append("[");
                field.index.accept((Visitor)this);
                this.builder.append("]");
            }
            this.builder.append('=');
        }
        field.rhs.accept((Visitor)this);
    }

    public void visit(Exp.AnonFuncDef exp) {
        this.newlineIfName("function");
        super.visit(exp);
    }

    public void visit(Exp.BinopExp exp) {
        exp.lhs.accept((Visitor)this);
        switch (exp.op) {
            case 13: {
                this.builder.append("+");
                break;
            }
            case 14: {
                this.builder.append("-");
                break;
            }
            case 63: {
                this.builder.append(">");
                break;
            }
            case 62: {
                this.builder.append(">=");
                break;
            }
            case 25: {
                this.builder.append("<");
                break;
            }
            case 26: {
                this.builder.append("<=");
                break;
            }
            case 24: {
                this.builder.append("==");
                break;
            }
            case 61: {
                this.builder.append("~=");
                break;
            }
            case 15: {
                this.builder.append("*");
                break;
            }
            case 16: {
                this.builder.append("/");
                break;
            }
            case 17: {
                this.builder.append("%");
                break;
            }
            case 18: {
                this.builder.append("^");
                break;
            }
            case 60: {
                this.spaceIfName("and");
                break;
            }
            case 59: {
                this.spaceIfName("or");
                break;
            }
            case 22: {
                this.builder.append("..");
                break;
            }
            default: {
                throw new IllegalStateException("unhandled operator: " + exp.op);
            }
        }
        exp.rhs.accept((Visitor)this);
    }

    public void visit(Exp.Constant exp) {
        LuaValue value = exp.value;
        if (value instanceof LuaString) {
            LuaString str = (LuaString)value;
            String input = new String(str.m_bytes, StandardCharsets.UTF_8);
            int sdq = 0;
            for (char c : input.toCharArray()) {
                if (c == '\'') {
                    --sdq;
                }
                if (c != '\"') continue;
                ++sdq;
            }
            char quote = sdq <= 0 ? (char)'\"' : '\'';
            input = input.replaceAll("\\r(?=\\n)", "");
            input = input.replaceAll("\\r", "\n");
            input = input.replaceAll("\\\\", "\\\\\\\\");
            input = input.replaceAll("\\n", "\\\\n");
            input = input.replaceAll(String.valueOf(quote), "\\\\" + quote);
            this.builder.append(quote).append(input).append(quote);
        } else {
            this.spaceIfName(String.valueOf(value));
        }
    }

    public void visit(Exp.FieldExp exp) {
        exp.lhs.accept((Visitor)this);
        this.builder.append(".");
        this.visit(exp.name);
    }

    public void visit(Exp.IndexExp exp) {
        exp.lhs.accept((Visitor)this);
        this.builder.append("[");
        exp.exp.accept((Visitor)this);
        this.builder.append("]");
    }

    public void visit(Exp.MethodCall exp) {
        exp.lhs.accept((Visitor)this);
        this.builder.append(":").append(exp.name);
        exp.args.accept((Visitor)this);
    }

    public void visit(Exp.NameExp exp) {
        this.visit(exp.name);
    }

    public void visit(Exp.ParensExp exp) {
        this.builder.append("(");
        super.visit(exp);
        this.builder.append(")");
    }

    public void visit(Exp.UnopExp exp) {
        switch (exp.op) {
            case 19: {
                this.builder.append("-");
                break;
            }
            case 20: {
                this.spaceIfName("not");
                break;
            }
            case 21: {
                this.builder.append("#");
                break;
            }
            default: {
                throw new IllegalStateException("unhandled op " + exp.op);
            }
        }
        super.visit(exp);
    }

    public void visit(Exp.VarargsExp exp) {
        this.builder.append("...");
    }

    public void visit(ParList pars) {
        this.builder.append("(");
        super.visit(pars);
        if (pars.isvararg) {
            if (pars.names != null && !pars.names.isEmpty()) {
                this.builder.append(',');
            }
            this.builder.append("...");
        }
        this.builder.append(")");
    }

    public void visit(TableConstructor table) {
        this.builder.append("{");
        if (table.fields != null) {
            Iterator iterator = table.fields.iterator();
            while (iterator.hasNext()) {
                ((TableField)iterator.next()).accept((Visitor)this);
                if (!iterator.hasNext()) continue;
                this.builder.append(";");
            }
        }
        this.builder.append("}");
    }

    public void visitVars(List<Exp.VarExp> vars) {
        if (vars != null) {
            Iterator<Exp.VarExp> iterator = vars.iterator();
            while (iterator.hasNext()) {
                iterator.next().accept((Visitor)this);
                if (!iterator.hasNext()) continue;
                this.builder.append(",");
            }
        }
    }

    public void visitExps(List<Exp> exps) {
        if (exps != null) {
            Iterator<Exp> iterator = exps.iterator();
            while (iterator.hasNext()) {
                iterator.next().accept((Visitor)this);
                if (!iterator.hasNext()) continue;
                this.builder.append(",");
            }
        }
    }

    public void visitNames(List<Name> names) {
        if (names != null) {
            this.spaceIfName();
            Iterator<Name> iterator = names.iterator();
            while (iterator.hasNext()) {
                this.visit(iterator.next());
                if (!iterator.hasNext()) continue;
                this.builder.append(",");
            }
        }
    }

    public void visit(Name name) {
        this.visit(this.vars.getOrDefault(name.variable != null && name.variable.isLocal() ? name.variable : null, name.name));
    }

    public void visit(String name) {
        this.spaceIfName(name);
    }

    public void visit(Stat.Goto gotostat) {
        this.newlineIfName("goto ").append(gotostat.name);
    }

    public void visit(Stat.Label label) {
        this.builder.append("::").append(label.name).append("::");
    }

    private StringBuilder newlineIfName(String next) {
        return this.charIfName(next, FiguraMod.debugModeEnabled() ? (char)'\n' : ' ');
    }

    private void spaceIfName() {
        this.spaceIfName("");
    }

    private StringBuilder spaceIfName(String next) {
        return this.charIfName(next, ' ');
    }

    private StringBuilder charIfName(String next, char c) {
        char ch;
        int length = this.builder.length();
        char c2 = ch = length > 0 ? this.builder.charAt(length - 1) : (char)'\u0000';
        if (length > 0 && (ch == '_' || Character.isLetterOrDigit(ch))) {
            this.builder.append(c);
        }
        return this.builder.append(next);
    }

    public String getString() {
        return this.builder.toString();
    }

    public int length() {
        return this.builder.length();
    }

    static {
        int i;
        chars = new char[63];
        LuaScriptBuilderVisitor.chars[0] = 95;
        for (i = 0; i < 26; ++i) {
            LuaScriptBuilderVisitor.chars[1 + i] = (char)(97 + i);
        }
        for (i = 0; i < 26; ++i) {
            LuaScriptBuilderVisitor.chars[27 + i] = (char)(65 + i);
        }
        for (i = 0; i < 10; ++i) {
            LuaScriptBuilderVisitor.chars[53 + i] = (char)(48 + i);
        }
    }

    private class ScopedBody
    implements AutoCloseable {
        private final boolean push;

        ScopedBody(NameScope scope) {
            boolean bl = this.push = scope != null;
            if (this.push) {
                LuaScriptBuilderVisitor.this.pushScope(scope);
            }
        }

        @Override
        public void close() {
            if (this.push) {
                LuaScriptBuilderVisitor.this.popScope();
            }
        }
    }
}

