/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.model.rendertasks;

import com.mojang.blaze3d.vertex.PoseStack;
import forge.org.figuramc.figura.avatar.Avatar;
import forge.org.figuramc.figura.lua.LuaNotNil;
import forge.org.figuramc.figura.lua.LuaWhitelist;
import forge.org.figuramc.figura.lua.api.world.ItemStackAPI;
import forge.org.figuramc.figura.lua.api.world.WorldAPI;
import forge.org.figuramc.figura.lua.docs.LuaMethodDoc;
import forge.org.figuramc.figura.lua.docs.LuaMethodOverload;
import forge.org.figuramc.figura.lua.docs.LuaTypeDoc;
import forge.org.figuramc.figura.model.FiguraModelPart;
import forge.org.figuramc.figura.model.rendertasks.RenderTask;
import forge.org.figuramc.figura.utils.LuaUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.luaj.vm2.LuaError;

@LuaWhitelist
@LuaTypeDoc(name="ItemTask", value="item_task")
public class ItemTask
extends RenderTask {
    private ItemStack item;
    private ItemDisplayContext displayMode = ItemDisplayContext.NONE;
    private boolean left = false;
    private int cachedComplexity;

    public ItemTask(String name, Avatar owner, FiguraModelPart parent) {
        super(name, owner, parent);
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        LivingEntity living;
        poseStack.m_85841_(-16.0f, 16.0f, -16.0f);
        Entity entity = this.owner.renderer.entity;
        LivingEntity entity2 = entity instanceof LivingEntity ? (living = (LivingEntity)entity) : null;
        int newLight = this.customization.light != null ? this.customization.light : light;
        int newOverlay = this.customization.overlay != null ? this.customization.overlay : overlay;
        int seed = entity2 != null ? entity2.m_19879_() + this.displayMode.ordinal() : 0;
        Minecraft.m_91087_().m_91291_().m_269491_(entity2, this.item, this.displayMode, this.left, poseStack, buffer, WorldAPI.getCurrentWorld(), newLight, newOverlay, seed);
    }

    @Override
    public int getComplexity() {
        return this.cachedComplexity;
    }

    @Override
    public boolean shouldRender() {
        return super.shouldRender() && this.item != null && !this.item.m_41619_();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"item"}), @LuaMethodOverload(argumentTypes={ItemStackAPI.class}, argumentNames={"item"})}, aliases={"item"}, value="item_task.set_item")
    public ItemTask setItem(Object item) {
        this.item = LuaUtils.parseItemStack("item", item);
        Minecraft client = Minecraft.m_91087_();
        RandomSource random = client.f_91073_ != null ? client.f_91073_.f_46441_ : RandomSource.m_216327_();
        this.cachedComplexity = client.m_91291_().m_174264_(this.item, null, null, 0).m_213637_(null, null, random).size();
        return this;
    }

    @LuaWhitelist
    public ItemTask item(Object item) {
        return this.setItem(item);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="item_task.get_display_mode")
    public String getDisplayMode() {
        return this.displayMode.name();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"displayMode"})}, aliases={"displayMode"}, value="item_task.set_display_mode")
    public ItemTask setDisplayMode(@LuaNotNil String mode) {
        try {
            this.displayMode = ItemDisplayContext.valueOf((String)mode.toUpperCase());
            this.left = this.displayMode == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || this.displayMode == ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
            return this;
        }
        catch (Exception ignored) {
            throw new LuaError("Illegal display mode: \"" + mode + "\".");
        }
    }

    @LuaWhitelist
    public ItemTask displayMode(@LuaNotNil String mode) {
        return this.setDisplayMode(mode);
    }

    @Override
    public String toString() {
        return this.name + " (Item Render Task)";
    }
}

