/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.model;

import forge.org.figuramc.figura.math.vector.FiguraVec3;
import forge.org.figuramc.figura.model.ParentType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;

public class VanillaModelData {
    public final Map<ParentType, PartData> partMap = new HashMap<ParentType, PartData>(){
        {
            for (ParentType value : ParentType.values()) {
                if (value.provider == null) continue;
                this.put(value, new PartData());
            }
        }
    };

    public void update(LivingEntityRenderer<?, ?> entityRenderer) {
        for (Map.Entry<ParentType, PartData> entry : this.partMap.entrySet()) {
            ParentType parent = entry.getKey();
            EntityModel vanillaModel = entityRenderer.m_7200_();
            if (vanillaModel == null) continue;
            this.update(parent, vanillaModel);
        }
    }

    public void update(ParentType parent, EntityModel<?> model) {
        ModelPart part = parent.provider.func.apply(model);
        if (part == null) {
            return;
        }
        this.update(parent, part);
    }

    public void update(ParentType parent, ModelPart part) {
        PartData data = this.partMap.get((Object)parent);
        if (data != null) {
            data.updateFromPart(part);
        }
    }

    public static class PartData {
        public final FiguraVec3 pos = FiguraVec3.of();
        public final FiguraVec3 rot = FiguraVec3.of();
        public final FiguraVec3 scale = FiguraVec3.of();
        public boolean visible = false;

        private void updateFromPart(ModelPart model) {
            this.pos.set(model.f_104200_, (double)model.f_104201_, (double)(-model.f_104202_));
            this.rot.set(Math.toDegrees(-model.f_104203_), Math.toDegrees(-model.f_104204_), Math.toDegrees(model.f_104205_));
            this.scale.set(model.f_233553_, (double)model.f_233554_, (double)model.f_233555_);
            this.visible = model.f_104207_;
        }
    }
}

