/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.model;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import forge.org.figuramc.figura.FiguraMod;
import forge.org.figuramc.figura.animation.Animation;
import forge.org.figuramc.figura.animation.Interpolation;
import forge.org.figuramc.figura.animation.Keyframe;
import forge.org.figuramc.figura.animation.TransformType;
import forge.org.figuramc.figura.avatar.Avatar;
import forge.org.figuramc.figura.config.Configs;
import forge.org.figuramc.figura.math.vector.FiguraVec2;
import forge.org.figuramc.figura.math.vector.FiguraVec3;
import forge.org.figuramc.figura.math.vector.FiguraVec4;
import forge.org.figuramc.figura.model.FiguraModelPart;
import forge.org.figuramc.figura.model.ParentType;
import forge.org.figuramc.figura.model.PartCustomization;
import forge.org.figuramc.figura.model.rendering.Vertex;
import forge.org.figuramc.figura.model.rendering.texture.FiguraTextureSet;
import forge.org.figuramc.figura.model.rendering.texture.RenderTypes;
import forge.org.figuramc.figura.utils.MathUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;

public class FiguraModelPartReader {
    private static final Map<String, FiguraVec3[]> faceData = ImmutableMap.of((Object)"n", (Object)new FiguraVec3[]{FiguraVec3.of(1.0, 0.0, 0.0), FiguraVec3.of(0.0, 0.0, 0.0), FiguraVec3.of(0.0, 1.0, 0.0), FiguraVec3.of(1.0, 1.0, 0.0), FiguraVec3.of(0.0, 0.0, -1.0)}, (Object)"s", (Object)new FiguraVec3[]{FiguraVec3.of(0.0, 0.0, 1.0), FiguraVec3.of(1.0, 0.0, 1.0), FiguraVec3.of(1.0, 1.0, 1.0), FiguraVec3.of(0.0, 1.0, 1.0), FiguraVec3.of(0.0, 0.0, 1.0)}, (Object)"e", (Object)new FiguraVec3[]{FiguraVec3.of(1.0, 0.0, 1.0), FiguraVec3.of(1.0, 0.0, 0.0), FiguraVec3.of(1.0, 1.0, 0.0), FiguraVec3.of(1.0, 1.0, 1.0), FiguraVec3.of(1.0, 0.0, 0.0)}, (Object)"w", (Object)new FiguraVec3[]{FiguraVec3.of(0.0, 0.0, 0.0), FiguraVec3.of(0.0, 0.0, 1.0), FiguraVec3.of(0.0, 1.0, 1.0), FiguraVec3.of(0.0, 1.0, 0.0), FiguraVec3.of(-1.0, 0.0, 0.0)}, (Object)"u", (Object)new FiguraVec3[]{FiguraVec3.of(0.0, 1.0, 1.0), FiguraVec3.of(1.0, 1.0, 1.0), FiguraVec3.of(1.0, 1.0, 0.0), FiguraVec3.of(0.0, 1.0, 0.0), FiguraVec3.of(0.0, 1.0, 0.0)}, (Object)"d", (Object)new FiguraVec3[]{FiguraVec3.of(0.0, 0.0, 0.0), FiguraVec3.of(1.0, 0.0, 0.0), FiguraVec3.of(1.0, 0.0, 1.0), FiguraVec3.of(0.0, 0.0, 1.0), FiguraVec3.of(0.0, -1.0, 0.0)});
    private static final FiguraVec2[] uvValues = new FiguraVec2[]{FiguraVec2.of(0.0, 1.0), FiguraVec2.of(1.0, 1.0), FiguraVec2.of(1.0, 0.0), FiguraVec2.of(0.0, 0.0)};

    public static FiguraModelPart read(Avatar owner, CompoundTag partCompound, List<FiguraTextureSet> textureSets, boolean smoothNormals) {
        String name = partCompound.m_128461_("name");
        PartCustomization customization = new PartCustomization();
        customization.needsMatrixRecalculation = true;
        FiguraVec3 rot = FiguraVec3.of();
        FiguraModelPartReader.readVec3(rot, partCompound, "rot");
        customization.setRot(rot);
        FiguraVec3 piv = FiguraVec3.of();
        FiguraModelPartReader.readVec3(piv, partCompound, "piv");
        customization.setPivot(piv);
        if (partCompound.m_128441_("primary")) {
            try {
                customization.setPrimaryRenderType(RenderTypes.valueOf(partCompound.m_128461_("primary")));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (partCompound.m_128441_("secondary")) {
            try {
                customization.setSecondaryRenderType(RenderTypes.valueOf(partCompound.m_128461_("secondary")));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (partCompound.m_128441_("vsb")) {
            customization.visible = partCompound.m_128471_("vsb");
        }
        ArrayList<Integer> facesByTexture = new ArrayList<Integer>(0);
        while (textureSets.size() > facesByTexture.size()) {
            facesByTexture.add(0);
        }
        HashMap<Integer, List<Vertex>> vertices = new HashMap<Integer, List<Vertex>>();
        if (FiguraModelPartReader.hasCubeData(partCompound)) {
            FiguraModelPartReader.readCuboid(facesByTexture, partCompound, vertices);
            customization.partType = PartCustomization.PartType.CUBE;
        } else if (FiguraModelPartReader.hasMeshData(partCompound)) {
            FiguraModelPartReader.readMesh(facesByTexture, partCompound, vertices);
            customization.partType = PartCustomization.PartType.MESH;
        }
        if (partCompound.m_128441_("smo")) {
            smoothNormals = partCompound.m_128471_("smo");
        }
        if (((Boolean)Configs.FORCE_SMOOTH_AVATAR.value).booleanValue() || smoothNormals && !vertices.isEmpty()) {
            FiguraModelPartReader.smoothfy(vertices);
        }
        ArrayList<FiguraModelPart> children = new ArrayList<FiguraModelPart>(0);
        if (partCompound.m_128441_("chld")) {
            ListTag listTag = partCompound.m_128437_("chld", 10);
            for (Tag tag : listTag) {
                children.add(FiguraModelPartReader.read(owner, (CompoundTag)tag, textureSets, smoothNormals));
            }
        }
        FiguraModelPart result = new FiguraModelPart(owner, name, customization, vertices, children);
        for (FiguraModelPart child : children) {
            child.parent = result;
        }
        result.facesByTexture = facesByTexture;
        FiguraModelPartReader.storeTextures(result, textureSets);
        if (partCompound.m_128441_("pt")) {
            try {
                result.parentType = ParentType.valueOf(partCompound.m_128461_("pt"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (partCompound.m_128441_("anim")) {
            ListTag nbt = partCompound.m_128437_("anim", 10);
            for (Tag tag : nbt) {
                Animation animation;
                CompoundTag compound = (CompoundTag)tag;
                if (!compound.m_128441_("id") || !compound.m_128441_("data") || (animation = owner.animations.get(compound.m_128451_("id"))) == null) continue;
                CompoundTag animNbt = compound.m_128469_("data");
                Iterator iterator = animNbt.m_128431_().iterator();
                while (iterator.hasNext()) {
                    TransformType type;
                    String channelString;
                    switch (channelString = (String)iterator.next()) {
                        case "pos": {
                            TransformType transformType = TransformType.POSITION;
                            break;
                        }
                        case "rot": {
                            TransformType transformType = TransformType.ROTATION;
                            break;
                        }
                        case "grot": {
                            TransformType transformType = TransformType.GLOBAL_ROT;
                            break;
                        }
                        case "scl": {
                            TransformType transformType = TransformType.SCALE;
                            break;
                        }
                        default: {
                            TransformType transformType = type = null;
                        }
                    }
                    if (type == null) continue;
                    ArrayList<Keyframe> keyframes = new ArrayList<Keyframe>();
                    ListTag keyframeList = animNbt.m_128437_(channelString, 10);
                    for (Tag keyframeTag : keyframeList) {
                        Pair end;
                        Interpolation interpolation;
                        CompoundTag keyframeNbt = (CompoundTag)keyframeTag;
                        float time = keyframeNbt.m_128457_("time");
                        try {
                            interpolation = Interpolation.valueOf(keyframeNbt.m_128461_("int").toUpperCase());
                        }
                        catch (Exception e) {
                            FiguraMod.LOGGER.error("", (Throwable)e);
                            continue;
                        }
                        Pair pre = FiguraModelPartReader.parseKeyframeData(keyframeNbt, "pre");
                        if (pre == null) {
                            pre = Pair.of((Object)FiguraVec3.of(), null);
                        }
                        if ((end = FiguraModelPartReader.parseKeyframeData(keyframeNbt, "end")) == null) {
                            end = pre;
                        }
                        FiguraVec3 bezierLeft = FiguraVec3.of();
                        FiguraVec3 bezierRight = FiguraVec3.of();
                        FiguraModelPartReader.readVec3(bezierLeft, keyframeNbt, "bl");
                        FiguraModelPartReader.readVec3(bezierRight, keyframeNbt, "br");
                        FiguraVec3 bezierLeftTime = FiguraVec3.of(-0.1, -0.1, -0.1);
                        FiguraVec3 bezierRightTime = FiguraVec3.of(0.1, 0.1, 0.1);
                        FiguraModelPartReader.readVec3(bezierLeftTime, keyframeNbt, "blt");
                        FiguraModelPartReader.readVec3(bezierRightTime, keyframeNbt, "brt");
                        bezierLeftTime.add(1.0, 1.0, 1.0);
                        bezierLeftTime = MathUtils.clamp(bezierLeftTime, 0.0, 1.0);
                        bezierRightTime = MathUtils.clamp(bezierRightTime, 0.0, 1.0);
                        keyframes.add(new Keyframe(owner, animation, time, interpolation, (Pair<FiguraVec3, String[]>)pre, (Pair<FiguraVec3, String[]>)end, bezierLeft, bezierRight, bezierLeftTime, bezierRightTime));
                    }
                    keyframes.sort(Keyframe::compareTo);
                    animation.addAnimation(result, new Animation.AnimationChannel(type, keyframes.toArray(new Keyframe[0])));
                }
            }
        }
        return result;
    }

    private static Pair<FiguraVec3, String[]> parseKeyframeData(CompoundTag keyframeNbt, String tag) {
        if (!keyframeNbt.m_128441_(tag)) {
            return null;
        }
        ListTag floatList = keyframeNbt.m_128437_(tag, 5);
        if (!floatList.isEmpty()) {
            FiguraVec3 ret = FiguraVec3.of();
            FiguraModelPartReader.readVec3(ret, floatList);
            return Pair.of((Object)ret, null);
        }
        ListTag stringList = keyframeNbt.m_128437_(tag, 8);
        return Pair.of(null, (Object)new String[]{stringList.m_128778_(0), stringList.m_128778_(1), stringList.m_128778_(2)});
    }

    private static void storeTextures(FiguraModelPart modelPart, List<FiguraTextureSet> textureSets) {
        ArrayList<FiguraTextureSet> list = new ArrayList<FiguraTextureSet>(0);
        for (int j = 0; j < modelPart.facesByTexture.size(); ++j) {
            list.add(textureSets.get(j));
        }
        modelPart.textures = list;
        int w = -1;
        int h = -1;
        for (FiguraModelPart child : modelPart.children) {
            if (child.textureWidth == -1) {
                modelPart.textureWidth = -1;
                modelPart.textureHeight = -1;
                return;
            }
            if (child.textureWidth == w && child.textureHeight == h) continue;
            if (w != -1) {
                modelPart.textureWidth = -1;
                modelPart.textureHeight = -1;
                return;
            }
            w = child.textureWidth;
            h = child.textureHeight;
        }
        if (modelPart.customization.partType != PartCustomization.PartType.GROUP) {
            int i = -1;
            for (int j = 0; j < modelPart.facesByTexture.size(); ++j) {
                if (modelPart.facesByTexture.get(j) <= 0) continue;
                int realTexWidth = textureSets.get(j).getWidth();
                int realTexHeight = textureSets.get(j).getHeight();
                if (w != -1 && w != realTexWidth || h != -1 && h != realTexHeight) {
                    modelPart.textureWidth = -1;
                    modelPart.textureHeight = -1;
                    return;
                }
                if (i != -1) {
                    modelPart.textureWidth = -1;
                    modelPart.textureHeight = -1;
                    return;
                }
                i = j;
                w = realTexWidth;
                h = realTexHeight;
            }
        }
        modelPart.textureWidth = w;
        modelPart.textureHeight = h;
    }

    private static void readVec3(FiguraVec3 target, CompoundTag tag, String name) {
        if (tag.m_128441_(name)) {
            FiguraModelPartReader.readVec3(target, (ListTag)tag.m_128423_(name));
        }
    }

    private static void readVec3(FiguraVec3 target, ListTag list) {
        switch (list.m_7264_()) {
            case 5: {
                target.set(list.m_128775_(0), (double)list.m_128775_(1), (double)list.m_128775_(2));
                break;
            }
            case 3: {
                target.set(list.m_128763_(0), (double)list.m_128763_(1), (double)list.m_128763_(2));
                break;
            }
            case 2: {
                target.set(list.m_128757_(0), (double)list.m_128757_(1), (double)list.m_128757_(2));
                break;
            }
            case 1: {
                target.set(((ByteTag)list.get(0)).m_7063_(), (double)((ByteTag)list.get(1)).m_7063_(), (double)((ByteTag)list.get(2)).m_7063_());
            }
        }
    }

    private static void readVec4(FiguraVec4 target, CompoundTag tag, String name) {
        if (tag.m_128441_(name)) {
            ListTag list = (ListTag)tag.m_128423_(name);
            switch (list.m_7264_()) {
                case 5: {
                    target.set(list.m_128775_(0), (double)list.m_128775_(1), (double)list.m_128775_(2), (double)list.m_128775_(3));
                    break;
                }
                case 3: {
                    target.set(list.m_128763_(0), (double)list.m_128763_(1), (double)list.m_128763_(2), (double)list.m_128763_(3));
                    break;
                }
                case 2: {
                    target.set(list.m_128757_(0), (double)list.m_128757_(1), (double)list.m_128757_(2), (double)list.m_128757_(3));
                    break;
                }
                case 1: {
                    target.set(((ByteTag)list.get(0)).m_7063_(), (double)((ByteTag)list.get(1)).m_7063_(), (double)((ByteTag)list.get(2)).m_7063_(), (double)((ByteTag)list.get(3)).m_7063_());
                }
            }
        } else {
            target.set(0.0, 0.0, 0.0, 0.0);
        }
    }

    private static boolean hasCubeData(CompoundTag partCompound) {
        if (partCompound.m_128425_("cube_data", 10)) {
            return !partCompound.m_128469_("cube_data").m_128456_();
        }
        return false;
    }

    private static boolean hasMeshData(CompoundTag partCompound) {
        if (partCompound.m_128425_("mesh_data", 10)) {
            return !partCompound.m_128469_("mesh_data").m_128456_();
        }
        return false;
    }

    private static void readCuboid(List<Integer> facesByTexture, CompoundTag data, Map<Integer, List<Vertex>> vertices) {
        FiguraVec3 from = FiguraVec3.of();
        FiguraModelPartReader.readVec3(from, data, "f");
        FiguraVec3 to = FiguraVec3.of();
        FiguraModelPartReader.readVec3(to, data, "t");
        double inflate = 0.0;
        if (data.m_128441_("inf")) {
            inflate = data.m_128457_("inf");
        }
        from.add(-inflate, -inflate, -inflate);
        to.add(inflate, inflate, inflate);
        FiguraVec3 ftDiff = to.copy();
        ftDiff.subtract(from);
        for (String direction : faceData.keySet()) {
            FiguraModelPartReader.readFace(data.m_128469_("cube_data"), facesByTexture, direction, vertices, from, ftDiff);
        }
    }

    private static void readFace(CompoundTag faces, List<Integer> facesByTexture, String direction, Map<Integer, List<Vertex>> vertices, FiguraVec3 from, FiguraVec3 ftDiff) {
        if (faces.m_128441_(direction)) {
            CompoundTag face = faces.m_128469_(direction);
            short texId = face.m_128448_("tex");
            facesByTexture.set(texId, facesByTexture.get(texId) + 1);
            FiguraVec3 normal = faceData.get(direction)[4];
            int rotation = (int)(face.m_128457_("rot") / 90.0f);
            FiguraVec4 uv = FiguraVec4.of();
            FiguraModelPartReader.readVec4(uv, face, "uv");
            for (int i = 0; i < 4; ++i) {
                FiguraVec3 tempPos = ftDiff.copy();
                tempPos.multiply(faceData.get(direction)[i]);
                tempPos.add(from);
                FiguraVec2 normalizedUv = uvValues[(i + rotation) % 4];
                List list = vertices.getOrDefault(texId, new ArrayList());
                list.add(new Vertex((float)tempPos.x, (float)tempPos.y, (float)tempPos.z, (float)Mth.m_14139_((double)normalizedUv.x, (double)uv.x, (double)uv.z), (float)Mth.m_14139_((double)normalizedUv.y, (double)uv.y, (double)uv.w), (float)normal.x, (float)normal.y, (float)normal.z));
                vertices.put(Integer.valueOf(texId), list);
            }
        }
    }

    private static void readMesh(List<Integer> facesByTexture, CompoundTag data, Map<Integer, List<Vertex>> vertices) {
        CompoundTag meshData = data.m_128469_("mesh_data");
        ListTag verts = meshData.m_128437_("vtx", 5);
        ListTag uvs = meshData.m_128437_("uvs", 5);
        ListTag tex = meshData.m_128437_("tex", 2);
        int bestType = 0;
        if (verts.size() > 765) {
            bestType = 1;
        }
        if (verts.size() > 98301) {
            bestType = 2;
        }
        ListTag fac = switch (bestType) {
            case 0 -> meshData.m_128437_("fac", 1);
            case 1 -> meshData.m_128437_("fac", 2);
            default -> meshData.m_128437_("fac", 3);
        };
        int vi = 0;
        int uvi = 0;
        float[] posArr = new float[12];
        float[] uvArr = new float[8];
        for (int ti = 0; ti < tex.size(); ++ti) {
            short packed = tex.m_128757_(ti);
            int texId = packed >> 4;
            int numVerts = packed & 0xF;
            facesByTexture.set(texId, facesByTexture.get(texId) + 1);
            for (int j = 0; j < numVerts; ++j) {
                int vid = switch (bestType) {
                    case 0 -> ((ByteTag)fac.get(vi + j)).m_7063_() & 0xFF;
                    case 1 -> fac.m_128757_(vi + j) & 0xFFFF;
                    default -> fac.m_128763_(vi + j);
                };
                posArr[3 * j] = verts.m_128775_(3 * vid);
                posArr[3 * j + 1] = verts.m_128775_(3 * vid + 1);
                posArr[3 * j + 2] = verts.m_128775_(3 * vid + 2);
                uvArr[2 * j] = uvs.m_128775_(uvi + 2 * j);
                uvArr[2 * j + 1] = uvs.m_128775_(uvi + 2 * j + 1);
            }
            FiguraVec3 p1 = FiguraVec3.of(posArr[0], posArr[1], posArr[2]);
            FiguraVec3 p2 = FiguraVec3.of(posArr[3], posArr[4], posArr[5]);
            FiguraVec3 p3 = FiguraVec3.of(posArr[6], posArr[7], posArr[8]);
            p3.subtract(p2);
            p1.subtract(p2);
            p3.cross(p1);
            p3.normalize();
            for (int j = 0; j < numVerts; ++j) {
                List list = vertices.getOrDefault(texId, new ArrayList());
                list.add(new Vertex(posArr[3 * j], posArr[3 * j + 1], posArr[3 * j + 2], uvArr[2 * j], uvArr[2 * j + 1], (float)p3.x, (float)p3.y, (float)p3.z));
                vertices.put(texId, list);
            }
            if (numVerts == 3) {
                List list = vertices.getOrDefault(texId, new ArrayList());
                list.add(new Vertex(posArr[6], posArr[7], posArr[8], uvArr[4], uvArr[5], (float)p3.x, (float)p3.y, (float)p3.z));
                vertices.put(texId, list);
            }
            vi += numVerts;
            uvi += 2 * numVerts;
        }
    }

    private static void smoothfy(Map<Integer, List<Vertex>> verticesByTextuers) {
        HashMap<String, List> verticesByPos = new HashMap<String, List>();
        for (List<Vertex> vertices : verticesByTextuers.values()) {
            for (Vertex vertex : vertices) {
                String id = String.valueOf(vertex.getPos());
                List list = verticesByPos.computeIfAbsent(id, str -> new ArrayList(4));
                list.add(vertex);
            }
        }
        for (List<Vertex> vertices : verticesByPos.values()) {
            FiguraVec3 result = FiguraVec3.of();
            for (Vertex vertex : vertices) {
                result.add(vertex.getNormal());
            }
            result.normalize();
            for (Vertex vertex : vertices) {
                vertex.setNormal(result);
            }
        }
    }
}

