/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.model;

import com.mojang.datafixers.util.Pair;
import forge.org.figuramc.figura.avatar.Avatar;
import forge.org.figuramc.figura.lua.LuaNotNil;
import forge.org.figuramc.figura.lua.LuaWhitelist;
import forge.org.figuramc.figura.lua.docs.LuaFieldDoc;
import forge.org.figuramc.figura.lua.docs.LuaMethodDoc;
import forge.org.figuramc.figura.lua.docs.LuaMethodOverload;
import forge.org.figuramc.figura.lua.docs.LuaTypeDoc;
import forge.org.figuramc.figura.math.matrix.FiguraMat3;
import forge.org.figuramc.figura.math.matrix.FiguraMat4;
import forge.org.figuramc.figura.math.vector.FiguraVec2;
import forge.org.figuramc.figura.math.vector.FiguraVec3;
import forge.org.figuramc.figura.model.ParentType;
import forge.org.figuramc.figura.model.PartCustomization;
import forge.org.figuramc.figura.model.VanillaModelData;
import forge.org.figuramc.figura.model.rendering.ImmediateAvatarRenderer;
import forge.org.figuramc.figura.model.rendering.Vertex;
import forge.org.figuramc.figura.model.rendering.texture.FiguraTexture;
import forge.org.figuramc.figura.model.rendering.texture.FiguraTextureSet;
import forge.org.figuramc.figura.model.rendering.texture.RenderTypes;
import forge.org.figuramc.figura.model.rendertasks.BlockTask;
import forge.org.figuramc.figura.model.rendertasks.ItemTask;
import forge.org.figuramc.figura.model.rendertasks.RenderTask;
import forge.org.figuramc.figura.model.rendertasks.SpriteTask;
import forge.org.figuramc.figura.model.rendertasks.TextTask;
import forge.org.figuramc.figura.utils.LuaUtils;
import forge.org.figuramc.figura.utils.ui.UIHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;

@LuaWhitelist
@LuaTypeDoc(name="ModelPart", value="model_part")
public class FiguraModelPart
implements Comparable<FiguraModelPart> {
    private final Avatar owner;
    public final String name;
    public FiguraModelPart parent;
    public final PartCustomization customization;
    public PartCustomization savedCustomization;
    public ParentType parentType = ParentType.None;
    private final Map<String, FiguraModelPart> childCache = new HashMap<String, FiguraModelPart>();
    public final List<FiguraModelPart> children;
    public List<Integer> facesByTexture;
    public Map<String, RenderTask> renderTasks = new ConcurrentHashMap<String, RenderTask>();
    public List<FiguraTextureSet> textures;
    public int textureWidth = -1;
    public int textureHeight = -1;
    public boolean animated = false;
    public int animationOverride = 0;
    public int lastAnimationPriority = Integer.MIN_VALUE;
    public final FiguraMat4 savedPartToWorldMat = FiguraMat4.of().scale(0.0625, 0.0625, 0.0625);
    public final Map<Integer, List<Vertex>> vertices;
    @LuaWhitelist
    @LuaFieldDoc(value="model_part.pre_render")
    public LuaFunction preRender;
    @LuaWhitelist
    @LuaFieldDoc(value="model_part.mid_render")
    public LuaFunction midRender;
    @LuaWhitelist
    @LuaFieldDoc(value="model_part.post_render")
    public LuaFunction postRender;

    public FiguraModelPart(Avatar owner, String name, PartCustomization customization, Map<Integer, List<Vertex>> vertices, List<FiguraModelPart> children) {
        this.owner = owner;
        this.name = name;
        this.customization = customization;
        this.vertices = vertices;
        this.children = children;
    }

    public boolean pushVerticesImmediate(ImmediateAvatarRenderer avatarRenderer, int[] remainingComplexity) {
        for (int i = 0; i < this.facesByTexture.size(); ++i) {
            if (remainingComplexity[0] <= 0) {
                return false;
            }
            remainingComplexity[0] = remainingComplexity[0] - this.facesByTexture.get(i);
            avatarRenderer.pushFaces(this.facesByTexture.get(i) + Math.min(remainingComplexity[0], 0), remainingComplexity, this.textures.get(i), this.vertices.get(i));
        }
        return true;
    }

    private Map<Integer, List<Vertex>> copyVertices() {
        HashMap<Integer, List<Vertex>> map = new HashMap<Integer, List<Vertex>>();
        for (Map.Entry<Integer, List<Vertex>> entry : this.vertices.entrySet()) {
            ArrayList<Vertex> list = new ArrayList<Vertex>();
            for (Vertex vertex : entry.getValue()) {
                list.add(vertex.copy());
            }
            map.put(entry.getKey(), list);
        }
        return map;
    }

    public void applyVanillaTransforms(VanillaModelData vanillaModelData) {
        if (vanillaModelData == null) {
            return;
        }
        VanillaModelData.PartData partData = vanillaModelData.partMap.get((Object)this.parentType);
        if (partData == null) {
            return;
        }
        this.customization.vanillaVisible = partData.visible;
        FiguraVec3 defaultPivot = this.parentType.offset.copy();
        defaultPivot.subtract(partData.pos);
        if (!this.overrideVanillaScale()) {
            defaultPivot.multiply(partData.scale);
            this.customization.offsetScale(partData.scale);
        }
        if (!this.overrideVanillaPos()) {
            this.customization.offsetPivot(defaultPivot);
            this.customization.offsetPos(defaultPivot);
        }
        if (!this.overrideVanillaRot()) {
            this.customization.offsetRot(partData.rot);
        }
    }

    public void resetVanillaTransforms() {
        if (this.parentType.provider != null) {
            if (!this.overrideVanillaPos()) {
                this.customization.offsetPivot(0.0, 0.0, 0.0);
                this.customization.offsetPos(0.0, 0.0, 0.0);
            }
            if (!this.overrideVanillaRot()) {
                this.customization.offsetRot(0.0, 0.0, 0.0);
            }
            if (!this.overrideVanillaScale()) {
                this.customization.offsetScale(1.0, 1.0, 1.0);
            }
            this.customization.vanillaVisible = null;
        }
    }

    public void applyExtraTransforms(PartCustomization currentTransforms) {
        if (this.parentType != ParentType.Camera) {
            return;
        }
        FiguraMat4 prevPartToView = currentTransforms.positionMatrix.inverted();
        double s = 0.0625;
        if (UIHelper.paperdoll) {
            s *= (double)(-UIHelper.dollScale);
        } else {
            prevPartToView.rightMultiply(FiguraMat4.of().rotateY(180.0));
        }
        FiguraVec3 scale = (FiguraVec3)currentTransforms.stackScale.scaled(s);
        FiguraVec3 piv = this.customization.getPivot();
        FiguraVec3 piv2 = this.customization.getOffsetPivot().add(piv);
        prevPartToView.scale(scale);
        prevPartToView.v34 = 0.0;
        prevPartToView.v24 = 0.0;
        prevPartToView.v14 = 0.0;
        prevPartToView.translateFirst(-piv2.x, -piv2.y, -piv2.z);
        prevPartToView.translate(piv2.x, piv2.y, piv2.z);
        this.customization.setMatrix(prevPartToView);
    }

    public void animPosition(FiguraVec3 vec, boolean merge) {
        if (merge) {
            FiguraVec3 pos = this.customization.getAnimPos();
            pos.add(-vec.x, vec.y, vec.z);
            this.customization.setAnimPos(pos.x, pos.y, pos.z);
        } else {
            this.customization.setAnimPos(-vec.x, vec.y, vec.z);
        }
    }

    public void animRotation(FiguraVec3 vec, boolean merge) {
        if (merge) {
            FiguraVec3 rot = this.customization.getAnimRot();
            rot.add(-vec.x, -vec.y, vec.z);
            this.customization.setAnimRot(rot.x, rot.y, rot.z);
        } else {
            this.customization.setAnimRot(-vec.x, -vec.y, vec.z);
        }
    }

    public void globalAnimRot(FiguraVec3 vec, boolean merge) {
        this.animRotation(vec, merge);
    }

    public void animScale(FiguraVec3 vec, boolean merge) {
        if (merge) {
            FiguraVec3 scale = this.customization.getAnimScale();
            scale.multiply(vec);
            this.customization.setAnimScale(scale.x, scale.y, scale.z);
        } else {
            this.customization.setAnimScale(vec.x, vec.y, vec.z);
        }
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={LuaFunction.class}, argumentNames={"function"})}, value="model_part.set_pre_render")
    public FiguraModelPart setPreRender(LuaFunction function) {
        this.preRender = function;
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={LuaFunction.class}, argumentNames={"function"})}, value="model_part.set_mid_render")
    public FiguraModelPart setMidRender(LuaFunction function) {
        this.midRender = function;
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={LuaFunction.class}, argumentNames={"function"})}, value="model_part.set_post_render")
    public FiguraModelPart setPostRender(LuaFunction function) {
        this.postRender = function;
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_name")
    public String getName() {
        return this.name;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_parent")
    public FiguraModelPart getParent() {
        return this.parent;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_children")
    public Map<Integer, FiguraModelPart> getChildren() {
        HashMap<Integer, FiguraModelPart> map = new HashMap<Integer, FiguraModelPart>();
        for (int i = 0; i < this.children.size(); ++i) {
            map.put(i + 1, this.children.get(i));
        }
        return map;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraModelPart.class}, argumentNames={"part"})}, value="model_part.is_child_of")
    public boolean isChildOf(@LuaNotNil FiguraModelPart part) {
        FiguraModelPart p = this.parent;
        while (p != null) {
            if (p == part) {
                return true;
            }
            p = p.parent;
        }
        return false;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_pos")
    public FiguraVec3 getPos() {
        return this.customization.getPos();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"pos"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, aliases={"pos"}, value="model_part.set_pos")
    public FiguraModelPart setPos(Object x, Double y, Double z) {
        FiguraVec3 vec = LuaUtils.parseVec3("setPos", x, y, z);
        this.customization.setPos(vec);
        return this;
    }

    @LuaWhitelist
    public FiguraModelPart pos(Object x, Double y, Double z) {
        return this.setPos(x, y, z);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_anim_pos")
    public FiguraVec3 getAnimPos() {
        return this.customization.getAnimPos();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_true_pos")
    public FiguraVec3 getTruePos() {
        return this.getPos().add(this.getAnimPos());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_rot")
    public FiguraVec3 getRot() {
        return this.customization.getRot();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"rot"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, aliases={"rot"}, value="model_part.set_rot")
    public FiguraModelPart setRot(Object x, Double y, Double z) {
        FiguraVec3 vec = LuaUtils.parseVec3("setRot", x, y, z);
        this.customization.setRot(vec);
        return this;
    }

    @LuaWhitelist
    public FiguraModelPart rot(Object x, Double y, Double z) {
        return this.setRot(x, y, z);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_offset_rot")
    public FiguraVec3 getOffsetRot() {
        return this.customization.getOffsetRot();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"offsetRot"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, aliases={"offsetRot"}, value="model_part.set_offset_rot")
    public FiguraModelPart setOffsetRot(Object x, Double y, Double z) {
        FiguraVec3 vec = LuaUtils.parseVec3("setOffsetRot", x, y, z);
        this.customization.offsetRot(vec);
        return this;
    }

    @LuaWhitelist
    public FiguraModelPart offsetRot(Object x, Double y, Double z) {
        return this.setOffsetRot(x, y, z);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_anim_rot")
    public FiguraVec3 getAnimRot() {
        return this.customization.getAnimRot();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_true_rot")
    public FiguraVec3 getTrueRot() {
        return this.getRot().add(this.getOffsetRot()).add(this.getAnimRot());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_scale")
    public FiguraVec3 getScale() {
        return this.customization.getScale();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"scale"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, aliases={"scale"}, value="model_part.set_scale")
    public FiguraModelPart setScale(Object x, Double y, Double z) {
        FiguraVec3 vec = LuaUtils.parseOneArgVec("setScale", x, y, z, 1.0);
        this.customization.setScale(vec);
        return this;
    }

    @LuaWhitelist
    public FiguraModelPart scale(Object x, Double y, Double z) {
        return this.setScale(x, y, z);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_offset_scale")
    public FiguraVec3 getOffsetScale() {
        return this.customization.getOffsetScale();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"offsetScale"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, aliases={"offsetScale"}, value="model_part.set_offset_scale")
    public FiguraModelPart setOffsetScale(Object x, Double y, Double z) {
        FiguraVec3 vec = LuaUtils.parseOneArgVec("setOffsetScale", x, y, z, 1.0);
        this.customization.offsetScale(vec);
        return this;
    }

    @LuaWhitelist
    public FiguraModelPart offsetScale(Object x, Double y, Double z) {
        return this.setOffsetScale(x, y, z);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_anim_scale")
    public FiguraVec3 getAnimScale() {
        return this.customization.getAnimScale();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_true_scale")
    public FiguraVec3 getTrueScale() {
        return this.getScale().multiply(this.getOffsetScale()).multiply(this.getAnimScale());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_pivot")
    public FiguraVec3 getPivot() {
        return this.customization.getPivot();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"pivot"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, aliases={"pivot"}, value="model_part.set_pivot")
    public FiguraModelPart setPivot(Object x, Double y, Double z) {
        FiguraVec3 vec = LuaUtils.parseVec3("setPivot", x, y, z);
        this.customization.setPivot(vec);
        return this;
    }

    @LuaWhitelist
    public FiguraModelPart pivot(Object x, Double y, Double z) {
        return this.setPivot(x, y, z);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_offset_pivot")
    public FiguraVec3 getOffsetPivot() {
        return this.customization.getOffsetPivot();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"offsetPivot"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, aliases={"offsetPivot"}, value="model_part.set_offset_pivot")
    public FiguraModelPart setOffsetPivot(Object x, Double y, Double z) {
        FiguraVec3 vec = LuaUtils.parseVec3("setOffsetPivot", x, y, z);
        this.customization.offsetPivot(vec);
        return this;
    }

    @LuaWhitelist
    public FiguraModelPart offsetPivot(Object x, Double y, Double z) {
        return this.setOffsetPivot(x, y, z);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_true_pivot")
    public FiguraVec3 getTruePivot() {
        return this.getPivot().add(this.getOffsetPivot());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_position_matrix")
    public FiguraMat4 getPositionMatrix() {
        this.customization.recalculate();
        return this.customization.getPositionMatrix();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_position_matrix_raw")
    public FiguraMat4 getPositionMatrixRaw() {
        return this.customization.getPositionMatrix();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_normal_matrix")
    public FiguraMat3 getNormalMatrix() {
        this.customization.recalculate();
        return this.customization.getNormalMatrix();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_normal_matrix_raw")
    public FiguraMat3 getNormalMatrixRaw() {
        return this.customization.getNormalMatrix();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraMat4.class}, argumentNames={"matrix"})}, aliases={"matrix"}, value="model_part.set_matrix")
    public FiguraModelPart setMatrix(@LuaNotNil FiguraMat4 matrix) {
        this.customization.setMatrix(matrix);
        return this;
    }

    @LuaWhitelist
    public FiguraModelPart matrix(@LuaNotNil FiguraMat4 matrix) {
        return this.setMatrix(matrix);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_visible")
    public boolean getVisible() {
        FiguraModelPart part = this;
        while (part != null && part.customization.visible == null) {
            part = part.parent;
        }
        return part == null || part.customization.visible != false;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Boolean.class}, argumentNames={"visible"})}, aliases={"visible"}, value="model_part.set_visible")
    public FiguraModelPart setVisible(Boolean bool) {
        this.customization.visible = bool;
        return this;
    }

    @LuaWhitelist
    public FiguraModelPart visible(Boolean bool) {
        return this.setVisible(bool);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_primary_render_type")
    public String getPrimaryRenderType() {
        RenderTypes renderType = this.customization.getPrimaryRenderType();
        return renderType == null ? null : renderType.name();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_secondary_render_type")
    public String getSecondaryRenderType() {
        RenderTypes renderType = this.customization.getSecondaryRenderType();
        return renderType == null ? null : renderType.name();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"renderType"})}, aliases={"primaryRenderType"}, value="model_part.set_primary_render_type")
    public FiguraModelPart setPrimaryRenderType(String type) {
        try {
            this.customization.setPrimaryRenderType(type == null ? null : RenderTypes.valueOf(type.toUpperCase()));
            return this;
        }
        catch (Exception ignored) {
            throw new LuaError("Illegal RenderType: \"" + type + "\".");
        }
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"renderType"})}, aliases={"secondaryRenderType"}, value="model_part.set_secondary_render_type")
    public FiguraModelPart setSecondaryRenderType(String type) {
        try {
            this.customization.setSecondaryRenderType(type == null ? null : RenderTypes.valueOf(type.toUpperCase()));
            return this;
        }
        catch (Exception ignored) {
            throw new LuaError("Illegal RenderType: \"" + type + "\".");
        }
    }

    @LuaWhitelist
    public FiguraModelPart primaryRenderType(String type) {
        return this.setPrimaryRenderType(type);
    }

    @LuaWhitelist
    public FiguraModelPart secondaryRenderType(String type) {
        return this.setSecondaryRenderType(type);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"textureType"}), @LuaMethodOverload(argumentTypes={String.class, String.class}, argumentNames={"resource", "path"}), @LuaMethodOverload(argumentTypes={String.class, FiguraTexture.class}, argumentNames={"custom", "texture"})}, aliases={"primaryTexture"}, value="model_part.set_primary_texture")
    public FiguraModelPart setPrimaryTexture(String type, Object x) {
        try {
            this.customization.primaryTexture = type == null ? null : Pair.of((Object)((Object)FiguraTextureSet.OverrideType.valueOf(type.toUpperCase())), (Object)x);
            return this;
        }
        catch (Exception ignored) {
            throw new LuaError("Invalid texture override type: " + type);
        }
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"textureType"}), @LuaMethodOverload(argumentTypes={String.class, String.class}, argumentNames={"resource", "path"}), @LuaMethodOverload(argumentTypes={String.class, FiguraTexture.class}, argumentNames={"custom", "texture"})}, aliases={"secondaryTexture"}, value="model_part.set_secondary_texture")
    public FiguraModelPart setSecondaryTexture(String type, Object x) {
        try {
            this.customization.secondaryTexture = type == null ? null : Pair.of((Object)((Object)FiguraTextureSet.OverrideType.valueOf(type.toUpperCase())), (Object)x);
            return this;
        }
        catch (Exception ignored) {
            throw new LuaError("Invalid texture override type: " + type);
        }
    }

    @LuaWhitelist
    public FiguraModelPart primaryTexture(String type, Object x) {
        return this.setPrimaryTexture(type, x);
    }

    @LuaWhitelist
    public FiguraModelPart secondaryTexture(String type, Object x) {
        return this.setSecondaryTexture(type, x);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_textures")
    public List<FiguraTexture> getTextures() {
        ArrayList<FiguraTexture> list = new ArrayList<FiguraTexture>();
        for (FiguraTextureSet set : this.textures) {
            for (FiguraTexture texture : set.textures) {
                if (texture == null) continue;
                list.add(texture);
            }
        }
        return list;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.part_to_world_matrix")
    public FiguraMat4 partToWorldMatrix() {
        return this.savedPartToWorldMat.copy();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_texture_size")
    public FiguraVec2 getTextureSize() {
        if (this.textureWidth == -1 || this.textureHeight == -1) {
            if (this.customization.partType == PartCustomization.PartType.GROUP) {
                throw new LuaError("Cannot get the texture size of groups!");
            }
            throw new LuaError("Cannot get texture size of part, it has multiple different-sized textures!");
        }
        return FiguraVec2.of(this.textureWidth, this.textureHeight);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec2.class}, argumentNames={"uv"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class}, argumentNames={"u", "v"})}, aliases={"uv"}, value="model_part.set_uv")
    public FiguraModelPart setUV(Object x, Double y) {
        this.customization.uvMatrix.reset();
        FiguraVec2 uv = LuaUtils.parseVec2("setUV", x, y);
        this.customization.uvMatrix.translate(uv.x % 1.0, uv.y % 1.0);
        return this;
    }

    @LuaWhitelist
    public FiguraModelPart uv(Object x, Double y) {
        return this.setUV(x, y);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_uv")
    public FiguraVec2 getUV() {
        return this.customization.uvMatrix.apply(0.0, 0.0);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec2.class}, argumentNames={"uv"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class}, argumentNames={"u", "v"})}, aliases={"uvPixels"}, value="model_part.set_uv_pixels")
    public FiguraModelPart setUVPixels(Object x, Double y) {
        if (this.textureWidth == -1 || this.textureHeight == -1) {
            if (this.customization.partType == PartCustomization.PartType.GROUP) {
                for (FiguraModelPart child : this.children) {
                    child.setUVPixels(x, y);
                }
                return this;
            }
            throw new LuaError("Cannot call setUVPixels on parts with multiple texture sizes!");
        }
        this.customization.uvMatrix.reset();
        FiguraVec2 uv = LuaUtils.parseVec2("setUVPixels", x, y);
        uv.divide(this.textureWidth, this.textureHeight);
        this.customization.uvMatrix.translate(uv.x, uv.y);
        return this;
    }

    @LuaWhitelist
    public FiguraModelPart uvPixels(Object x, Double y) {
        return this.setUVPixels(x, y);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_uv_pixels")
    public FiguraVec2 getUVPixels() {
        if (this.textureWidth == -1 || this.textureHeight == -1) {
            if (this.customization.partType == PartCustomization.PartType.GROUP) {
                throw new LuaError("Cannot call getUVPixels on groups!");
            }
            throw new LuaError("Cannot call getUVPixels on parts with multiple texture sizes!");
        }
        return this.getUV().multiply(this.textureWidth, this.textureHeight);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraMat3.class}, argumentNames={"matrix"})}, aliases={"uvMatrix"}, value="model_part.set_uv_matrix")
    public FiguraModelPart setUVMatrix(@LuaNotNil FiguraMat3 matrix) {
        this.customization.uvMatrix.set(matrix);
        return this;
    }

    @LuaWhitelist
    public FiguraModelPart uvMatrix(@LuaNotNil FiguraMat3 matrix) {
        return this.setUVMatrix(matrix);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_uv_matrix")
    public FiguraMat3 getUVMatrix() {
        return this.customization.uvMatrix;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"color"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"r", "g", "b"})}, aliases={"color"}, value="model_part.set_color")
    public FiguraModelPart setColor(Object r, Double g, Double b) {
        FiguraVec3 vec = LuaUtils.parseOneArgVec("setColor", r, g, b, 1.0);
        this.customization.color.set(vec);
        this.customization.color2.set(vec);
        return this;
    }

    @LuaWhitelist
    public FiguraModelPart color(Object r, Double g, Double b) {
        return this.setColor(r, g, b);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_color")
    public FiguraVec3 getColor() {
        return this.getPrimaryColor().add(this.getSecondaryColor()).scale(0.5);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"color"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"r", "g", "b"})}, aliases={"primaryColor"}, value="model_part.set_primary_color")
    public FiguraModelPart setPrimaryColor(Object r, Double g, Double b) {
        this.customization.color.set(LuaUtils.parseOneArgVec("setPrimaryColor", r, g, b, 1.0));
        return this;
    }

    @LuaWhitelist
    public FiguraModelPart primaryColor(Object r, Double g, Double b) {
        return this.setPrimaryColor(r, g, b);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_primary_color")
    public FiguraVec3 getPrimaryColor() {
        return this.customization.color.copy();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"color"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"r", "g", "b"})}, aliases={"secondaryColor"}, value="model_part.set_secondary_color")
    public FiguraModelPart setSecondaryColor(Object r, Double g, Double b) {
        this.customization.color2.set(LuaUtils.parseOneArgVec("setSecondaryColor", r, g, b, 1.0));
        return this;
    }

    @LuaWhitelist
    public FiguraModelPart secondaryColor(Object r, Double g, Double b) {
        return this.setSecondaryColor(r, g, b);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_secondary_color")
    public FiguraVec3 getSecondaryColor() {
        return this.customization.color2.copy();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Float.class}, argumentNames={"opacity"})}, aliases={"opacity"}, value="model_part.set_opacity")
    public FiguraModelPart setOpacity(Float opacity) {
        this.customization.alpha = opacity;
        return this;
    }

    @LuaWhitelist
    public FiguraModelPart opacity(Float opacity) {
        return this.setOpacity(opacity);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_opacity")
    public Float getOpacity() {
        return this.customization.alpha;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec2.class}, argumentNames={"light"}), @LuaMethodOverload(argumentTypes={Integer.class, Integer.class}, argumentNames={"blockLight", "skyLight"})}, aliases={"light"}, value="model_part.set_light")
    public FiguraModelPart setLight(Object light, Double skyLight) {
        if (light == null) {
            this.customization.light = null;
            return this;
        }
        FiguraVec2 lightVec = LuaUtils.parseVec2("setLight", light, skyLight);
        this.customization.light = LightTexture.m_109885_((int)((int)lightVec.x), (int)((int)lightVec.y));
        return this;
    }

    @LuaWhitelist
    public FiguraModelPart light(Object light, Double skyLight) {
        return this.setLight(light, skyLight);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_light")
    public FiguraVec2 getLight() {
        Integer light = this.customization.light;
        return light == null ? null : FiguraVec2.of(LightTexture.m_109883_((int)light), LightTexture.m_109894_((int)light));
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec2.class}, argumentNames={"overlay"}), @LuaMethodOverload(argumentTypes={Integer.class, Integer.class}, argumentNames={"whiteOverlay", "hurtOverlay"})}, aliases={"overlay"}, value="model_part.set_overlay")
    public FiguraModelPart setOverlay(Object whiteOverlay, Double hurtOverlay) {
        if (whiteOverlay == null) {
            this.customization.overlay = null;
            return this;
        }
        FiguraVec2 overlayVec = LuaUtils.parseVec2("setOverlay", whiteOverlay, hurtOverlay);
        this.customization.overlay = OverlayTexture.m_118093_((int)((int)overlayVec.x), (int)((int)overlayVec.y));
        return this;
    }

    @LuaWhitelist
    public FiguraModelPart overlay(Object whiteOverlay, Double hurtOverlay) {
        return this.setOverlay(whiteOverlay, hurtOverlay);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_overlay")
    public FiguraVec2 getOverlay() {
        Integer overlay = this.customization.overlay;
        return overlay == null ? null : FiguraVec2.of(overlay & 0xFFFF, overlay >> 16);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"parentType"})}, aliases={"parentType"}, value="model_part.set_parent_type")
    public FiguraModelPart setParentType(String parent) {
        ParentType oldParent = this.parentType;
        this.parentType = ParentType.get(parent);
        if ((oldParent.isSeparate || this.parentType.isSeparate) && oldParent != this.parentType) {
            this.owner.renderer.sortParts();
        }
        this.customization.vanillaVisible = null;
        this.customization.needsMatrixRecalculation = true;
        return this;
    }

    @LuaWhitelist
    public FiguraModelPart parentType(String parent) {
        return this.setParentType(parent);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_parent_type")
    public String getParentType() {
        return this.parentType == null ? null : this.parentType.name();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_type")
    public String getType() {
        return this.customization.partType.name();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.override_vanilla_rot")
    public boolean overrideVanillaRot() {
        return (this.animationOverride & 1) == 1;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.override_vanilla_pos")
    public boolean overrideVanillaPos() {
        return (this.animationOverride & 2) == 2;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.override_vanilla_scale")
    public boolean overrideVanillaScale() {
        return (this.animationOverride & 4) == 4;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"taskName"})}, value="model_part.new_text")
    public TextTask newText(@LuaNotNil String name) {
        TextTask task = new TextTask(name, this.owner, this);
        this.renderTasks.put(name, task);
        return task;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"taskName"})}, value="model_part.new_item")
    public ItemTask newItem(@LuaNotNil String name) {
        ItemTask task = new ItemTask(name, this.owner, this);
        this.renderTasks.put(name, task);
        return task;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"taskName"})}, value="model_part.new_block")
    public BlockTask newBlock(@LuaNotNil String name) {
        BlockTask task = new BlockTask(name, this.owner, this);
        this.renderTasks.put(name, task);
        return task;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"taskName"})}, value="model_part.new_sprite")
    public SpriteTask newSprite(@LuaNotNil String name) {
        SpriteTask task = new SpriteTask(name, this.owner, this);
        this.renderTasks.put(name, task);
        return task;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={RenderTask.class}, argumentNames={"renderTask"})}, value="model_part.new_task")
    public RenderTask newTask(@LuaNotNil RenderTask renderTask) {
        this.renderTasks.put(renderTask.getName(), renderTask);
        return renderTask;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(returnType=Map.class), @LuaMethodOverload(argumentTypes={String.class}, argumentNames={"taskName"}, returnType=RenderTask.class)}, value="model_part.get_task")
    public Object getTask(String name) {
        if (name != null) {
            return this.renderTasks.get(name);
        }
        return this.renderTasks;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={String.class}, argumentNames={"taskName"}), @LuaMethodOverload(argumentTypes={RenderTask.class}, argumentNames={"renderTask"})}, value="model_part.remove_task")
    public FiguraModelPart removeTask(Object x) {
        if (x instanceof String) {
            String s = (String)x;
            this.renderTasks.remove(s);
        } else if (x instanceof RenderTask) {
            RenderTask t = (RenderTask)x;
            this.renderTasks.remove(t.getName());
        } else if (x == null) {
            this.renderTasks.clear();
        } else {
            throw new LuaError("Illegal argument to removeTask(): " + x.getClass().getSimpleName());
        }
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"textureID"})}, value="model_part.get_vertices")
    public List<Vertex> getVertices(@LuaNotNil String textureID) {
        int index = -1;
        for (int i = 0; i < this.textures.size(); ++i) {
            if (!textureID.equals(this.textures.get((int)i).name)) continue;
            index = i;
            break;
        }
        return this.vertices.get(index);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="model_part.get_all_vertices")
    public Map<String, List<Vertex>> getAllVertices() {
        HashMap<String, List<Vertex>> map = new HashMap<String, List<Vertex>>();
        for (int i = 0; i < this.textures.size(); ++i) {
            List<Vertex> list = this.vertices.get(i);
            if (list == null) continue;
            map.put(this.textures.get((int)i).name, list);
        }
        return map;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraModelPart.class}, argumentNames={"part"})}, value="model_part.move_to")
    public FiguraModelPart moveTo(@LuaNotNil FiguraModelPart part) {
        this.parent.children.remove(this);
        part.children.add(this);
        this.parent = part;
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraModelPart.class}, argumentNames={"part"})}, value="model_part.add_child")
    public FiguraModelPart addChild(@LuaNotNil FiguraModelPart part) {
        FiguraModelPart parent = this.parent;
        while (parent != null) {
            if (part == parent) {
                throw new LuaError("Cannot add child that's already parent of this part");
            }
            parent = parent.parent;
        }
        this.children.add(part);
        part.parent = this;
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraModelPart.class}, argumentNames={"part"})}, value="model_part.remove_child")
    public FiguraModelPart removeChild(@LuaNotNil FiguraModelPart part) {
        this.children.remove(part);
        part.parent = null;
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"name"})}, value="model_part.copy")
    public FiguraModelPart copy(@LuaNotNil String name) {
        PartCustomization customization = new PartCustomization();
        this.customization.copyTo(customization);
        FiguraModelPart result = new FiguraModelPart(this.owner, name, customization, this.copyVertices(), new ArrayList<FiguraModelPart>(this.children));
        result.facesByTexture = new ArrayList<Integer>(this.facesByTexture);
        result.textures = new ArrayList<FiguraTextureSet>(this.textures);
        result.parentType = this.parentType;
        result.textureHeight = this.textureHeight;
        result.textureWidth = this.textureWidth;
        if (this.parentType.isSeparate) {
            this.owner.renderer.sortParts();
        }
        return result;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"name"}), @LuaMethodOverload(argumentTypes={String.class, String.class}, argumentNames={"name", "parentType"})}, value="model_part.new_part")
    public FiguraModelPart newPart(@LuaNotNil String name, String parentType) {
        FiguraModelPart newer = new FiguraModelPart(this.owner, name, new PartCustomization(), new HashMap<Integer, List<Vertex>>(), new ArrayList<FiguraModelPart>());
        newer.facesByTexture = new ArrayList<Integer>();
        newer.textures = new ArrayList<FiguraTextureSet>();
        this.addChild(newer);
        newer.setPivot(this.getPivot(), null, null);
        if (parentType != null) {
            newer.setParentType(parentType);
        }
        return newer;
    }

    @LuaWhitelist
    public Object __index(String key) {
        if (key == null) {
            return null;
        }
        if (this.childCache.containsKey(key)) {
            return this.childCache.get(key);
        }
        for (FiguraModelPart child : this.children) {
            if (!child.name.equals(key)) continue;
            this.childCache.put(key, child);
            return child;
        }
        this.childCache.put(key, null);
        return switch (key) {
            case "preRender" -> this.preRender;
            case "midRender" -> this.midRender;
            case "postRender" -> this.postRender;
            default -> null;
        };
    }

    @LuaWhitelist
    public void __newindex(@LuaNotNil String key, LuaFunction value) {
        switch (key) {
            case "preRender": {
                this.preRender = value;
                break;
            }
            case "midRender": {
                this.midRender = value;
                break;
            }
            case "postRender": {
                this.postRender = value;
                break;
            }
            default: {
                throw new LuaError("Cannot assign value on key \"" + key + "\"");
            }
        }
    }

    @Override
    public int compareTo(FiguraModelPart o) {
        if (this.isChildOf(o)) {
            return 1;
        }
        if (o.isChildOf(this)) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return this.name + " (ModelPart)";
    }
}

