/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.mixin.gui;

import forge.org.figuramc.figura.avatar.Avatar;
import forge.org.figuramc.figura.avatar.AvatarManager;
import forge.org.figuramc.figura.avatar.Badges;
import forge.org.figuramc.figura.config.Configs;
import forge.org.figuramc.figura.lua.api.nameplate.NameplateCustomization;
import forge.org.figuramc.figura.permissions.Permissions;
import forge.org.figuramc.figura.utils.TextUtils;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.PlayerTabOverlay;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerTabOverlay.class})
public class PlayerTabOverlayMixin {
    @Unique
    private UUID uuid;

    @Inject(at={@At(value="RETURN")}, method={"getNameForDisplay"}, cancellable=true)
    private void getPlayerName(PlayerInfo playerInfo, CallbackInfoReturnable<Component> cir) {
        int config = (Integer)Configs.LIST_NAMEPLATE.value;
        if (config == 0 || AvatarManager.panic) {
            return;
        }
        Component text = (Component)cir.getReturnValue();
        MutableComponent name = Component.m_237113_((String)playerInfo.m_105312_().getName());
        UUID uuid = playerInfo.m_105312_().getId();
        Avatar avatar = AvatarManager.getAvatarForPlayer(uuid);
        NameplateCustomization custom = avatar == null || avatar.luaRuntime == null ? null : avatar.luaRuntime.nameplate.LIST;
        MutableComponent replacement = custom != null && custom.getJson() != null && avatar.permissions.get(Permissions.NAMEPLATE_EDIT) == 1 ? TextUtils.replaceInText((FormattedText)custom.getJson().m_6881_(), "\n|\\\\n", " ") : name;
        replacement = TextUtils.replaceInText((FormattedText)replacement, "\\$\\{name\\}", name);
        replacement = Badges.appendBadges((Component)replacement, uuid, config > 1);
        replacement = TextUtils.trim((FormattedText)replacement);
        text = TextUtils.replaceInText((FormattedText)text, "\\b" + Pattern.quote(playerInfo.m_105312_().getName()) + "\\b", replacement);
        cir.setReturnValue((Object)text);
    }

    @ModifyArg(at=@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;getPlayerByUUID(Ljava/util/UUID;)Lnet/minecraft/world/entity/player/Player;"), method={"render"})
    private UUID getPlayerByUUID(UUID id) {
        this.uuid = id;
        return id;
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/PlayerFaceRenderer;draw(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/resources/ResourceLocation;IIIZZ)V"), index=4)
    private int doNotDrawFace(GuiGraphics guiGraphics, ResourceLocation id, int x, int y, int size, boolean hasHatLayer, boolean upsideDown) {
        Avatar avatar;
        if (this.uuid != null && (avatar = AvatarManager.getAvatarForPlayer(this.uuid)) != null && avatar.renderPortrait(guiGraphics, x, y, size, 16.0f, upsideDown)) {
            return 0;
        }
        return size;
    }
}

