/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.mixin.gui;

import com.mojang.datafixers.util.Pair;
import forge.org.figuramc.figura.FiguraMod;
import forge.org.figuramc.figura.avatar.Avatar;
import forge.org.figuramc.figura.avatar.AvatarManager;
import forge.org.figuramc.figura.avatar.Badges;
import forge.org.figuramc.figura.config.Configs;
import forge.org.figuramc.figura.ducks.GuiMessageAccessor;
import forge.org.figuramc.figura.font.Emojis;
import forge.org.figuramc.figura.lua.api.nameplate.NameplateCustomization;
import forge.org.figuramc.figura.permissions.Permissions;
import forge.org.figuramc.figura.utils.EntityUtils;
import forge.org.figuramc.figura.utils.TextUtils;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.GuiMessageTag;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.MutableComponent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChatComponent.class})
public class ChatComponentMixin {
    @Unique
    private Integer color;
    @Unique
    private int currColor;

    @ModifyVariable(at=@At(value="HEAD"), method={"addMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;ILnet/minecraft/client/GuiMessageTag;Z)V"}, ordinal=0, argsOnly=true)
    private Component addMessage(Component message, Component msg, MessageSignature signature, int k, GuiMessageTag tag, boolean refresh) {
        int config;
        if (refresh) {
            return message;
        }
        this.color = null;
        if (AvatarManager.panic) {
            return message;
        }
        Avatar localPlayer = AvatarManager.getAvatarForPlayer(FiguraMod.getLocalPlayerUUID());
        if (localPlayer != null) {
            String json = Component.Serializer.m_130703_((Component)message);
            Pair<String, Integer> event = localPlayer.chatReceivedMessageEvent(message.getString(), json);
            if (event != null) {
                String newMessage = (String)event.getFirst();
                if (newMessage == null) {
                    return null;
                }
                if (!json.equals(newMessage)) {
                    TextUtils.allowScriptEvents = true;
                    message = TextUtils.tryParseJson(newMessage);
                    TextUtils.allowScriptEvents = false;
                }
                this.color = (Integer)event.getSecond();
            }
        }
        if (!FiguraMod.parseMessages) {
            return message;
        }
        if ((Integer)Configs.EMOJIS.value > 0) {
            message = Emojis.applyEmojis(message);
        }
        if ((config = ((Integer)Configs.CHAT_NAMEPLATE.value).intValue()) == 0) {
            return message;
        }
        message = TextUtils.parseLegacyFormatting((FormattedText)message);
        Map<String, UUID> players = EntityUtils.getPlayerList();
        String owner = null;
        String msgString = message.getString();
        String[] split = msgString.split("\\W+");
        for (String s2 : split) {
            if (!players.containsKey(s2)) continue;
            owner = s2;
            break;
        }
        for (Map.Entry entry : players.entrySet()) {
            NameplateCustomization custom;
            String name = (String)entry.getKey();
            if (!msgString.toLowerCase().contains(name.toLowerCase())) continue;
            UUID uuid = (UUID)entry.getValue();
            boolean isOwner = name.equals(owner);
            MutableComponent playerName = Component.m_237113_((String)name);
            Avatar avatar = AvatarManager.getAvatarForPlayer(uuid);
            NameplateCustomization nameplateCustomization = custom = avatar == null || avatar.luaRuntime == null ? null : avatar.luaRuntime.nameplate.CHAT;
            if (custom == null && config < 2) continue;
            MutableComponent replacement = custom != null && custom.getJson() != null && avatar.permissions.get(Permissions.NAMEPLATE_EDIT) == 1 ? TextUtils.replaceInText((FormattedText)custom.getJson().m_6881_(), "\n|\\\\n", " ") : playerName;
            replacement = TextUtils.replaceInText((FormattedText)replacement, "\\$\\{name\\}", playerName);
            Component emptyReplacement = Badges.appendBadges((Component)replacement, uuid, config > 1 && owner == null);
            emptyReplacement = TextUtils.trim((FormattedText)emptyReplacement);
            String quotedName = "(?i)\\b" + Pattern.quote(name) + "\\b";
            message = TextUtils.replaceInText((FormattedText)message, quotedName, emptyReplacement, (s, style) -> true, isOwner ? 1 : 0, Integer.MAX_VALUE);
            if (config <= 1 || !isOwner) continue;
            Component temp = Badges.appendBadges((Component)replacement, uuid, true);
            temp = TextUtils.trim((FormattedText)temp);
            message = TextUtils.replaceInText((FormattedText)message, quotedName, temp, (s, style) -> true, 1);
        }
        return message;
    }

    @Inject(at={@At(value="HEAD")}, method={"addMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;ILnet/minecraft/client/GuiMessageTag;Z)V"}, cancellable=true)
    private void addMessage(Component message, MessageSignature signature, int ticks, GuiMessageTag tag, boolean refresh, CallbackInfo ci) {
        if (message == null) {
            ci.cancel();
        }
    }

    @ModifyArg(at=@At(value="INVOKE", target="Ljava/util/List;add(ILjava/lang/Object;)V"), method={"addMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;ILnet/minecraft/client/GuiMessageTag;Z)V"})
    private Object addMessages(int index, Object message) {
        if (this.color != null) {
            ((GuiMessageAccessor)message).figura$setColor(this.color);
        }
        return message;
    }

    @ModifyVariable(at=@At(value="STORE"), method={"render"})
    private GuiMessage.Line grabColor(GuiMessage.Line line) {
        this.currColor = ((GuiMessageAccessor)line).figura$getColor();
        return line;
    }

    @ModifyArg(at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fill(IIIII)V", ordinal=0), method={"render"}, index=4)
    private int textBackgroundOnRender(int color) {
        return color + this.currColor;
    }

    @ModifyVariable(at=@At(value="STORE"), method={"refreshTrimmedMessage"})
    private GuiMessage refreshMessages(GuiMessage message) {
        this.color = ((GuiMessageAccessor)message).figura$getColor();
        return message;
    }
}

