/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.lua.api.world;

import forge.org.figuramc.figura.lua.LuaWhitelist;
import forge.org.figuramc.figura.lua.NbtToLua;
import forge.org.figuramc.figura.lua.ReadOnlyLuaTable;
import forge.org.figuramc.figura.lua.api.world.ItemStackAPI;
import forge.org.figuramc.figura.lua.api.world.WorldAPI;
import forge.org.figuramc.figura.lua.docs.LuaFieldDoc;
import forge.org.figuramc.figura.lua.docs.LuaMethodDoc;
import forge.org.figuramc.figura.lua.docs.LuaMethodOverload;
import forge.org.figuramc.figura.lua.docs.LuaTypeDoc;
import forge.org.figuramc.figura.math.vector.FiguraVec3;
import forge.org.figuramc.figura.mixin.BlockBehaviourAccessor;
import forge.org.figuramc.figura.utils.ColorUtils;
import forge.org.figuramc.figura.utils.LuaUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;

@LuaWhitelist
@LuaTypeDoc(name="BlockState", value="blockstate")
public class BlockStateAPI {
    public final BlockState blockState;
    private BlockPos pos;
    @LuaWhitelist
    @LuaFieldDoc(value="blockstate.id")
    public final String id;
    @LuaWhitelist
    @LuaFieldDoc(value="blockstate.properties")
    public final LuaTable properties;

    public BlockStateAPI(BlockState blockstate, BlockPos pos) {
        this.blockState = blockstate;
        this.pos = pos;
        this.id = BuiltInRegistries.f_256975_.m_7981_((Object)blockstate.m_60734_()).toString();
        CompoundTag tag = NbtUtils.m_129202_((BlockState)blockstate);
        this.properties = new ReadOnlyLuaTable((LuaValue)(tag.m_128441_("Properties") ? NbtToLua.convert(tag.m_128423_("Properties")) : new LuaTable()));
    }

    protected BlockPos getBlockPos() {
        return this.pos == null ? BlockPos.f_121853_ : this.pos;
    }

    protected static List<List<FiguraVec3>> voxelShapeToTable(VoxelShape shape) {
        ArrayList<List<FiguraVec3>> shapes = new ArrayList<List<FiguraVec3>>();
        for (AABB aabb : shape.m_83299_()) {
            shapes.add(List.of(FiguraVec3.of(aabb.f_82288_, aabb.f_82289_, aabb.f_82290_), FiguraVec3.of(aabb.f_82291_, aabb.f_82292_, aabb.f_82293_)));
        }
        return shapes;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_id")
    public String getID() {
        return this.id;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_properties")
    public LuaTable getProperties() {
        return this.properties;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_pos")
    public FiguraVec3 getPos() {
        return FiguraVec3.fromBlockPos(this.getBlockPos());
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"pos"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, aliases={"pos"}, value="blockstate.set_pos")
    public BlockStateAPI setPos(Object x, Double y, Double z) {
        FiguraVec3 newPos = LuaUtils.parseVec3("setPos", x, y, z);
        this.pos = newPos.asBlockPos();
        return this;
    }

    @LuaWhitelist
    public BlockStateAPI pos(Object x, Double y, Double z) {
        return this.setPos(x, y, z);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.is_translucent")
    public boolean isTranslucent() {
        return this.blockState.m_60631_((BlockGetter)WorldAPI.getCurrentWorld(), this.getBlockPos());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_opacity")
    public int getOpacity() {
        return this.blockState.m_60739_((BlockGetter)WorldAPI.getCurrentWorld(), this.getBlockPos());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_map_color")
    public FiguraVec3 getMapColor() {
        return ColorUtils.intToRGB(this.blockState.m_284242_((BlockGetter)WorldAPI.getCurrentWorld(), (BlockPos)this.getBlockPos()).f_283871_);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.is_solid_block")
    public boolean isSolidBlock() {
        return this.blockState.m_60796_((BlockGetter)WorldAPI.getCurrentWorld(), this.getBlockPos());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.is_full_cube")
    public boolean isFullCube() {
        return this.blockState.m_60838_((BlockGetter)WorldAPI.getCurrentWorld(), this.getBlockPos());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.has_emissive_lighting")
    public boolean hasEmissiveLighting() {
        return this.blockState.m_60788_((BlockGetter)WorldAPI.getCurrentWorld(), this.getBlockPos());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_hardness")
    public float getHardness() {
        return this.blockState.m_60800_((BlockGetter)WorldAPI.getCurrentWorld(), this.getBlockPos());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_comparator_output")
    public int getComparatorOutput() {
        return this.blockState.m_60674_(WorldAPI.getCurrentWorld(), this.getBlockPos());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.has_block_entity")
    public boolean hasBlockEntity() {
        return this.blockState.m_155947_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.is_opaque")
    public boolean isOpaque() {
        return this.blockState.m_60815_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.emits_redstone_power")
    public boolean emitsRedstonePower() {
        return this.blockState.m_60803_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_luminance")
    public int getLuminance() {
        return this.blockState.m_60791_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_friction")
    public float getFriction() {
        return this.blockState.m_60734_().m_49958_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_velocity_multiplier")
    public float getVelocityMultiplier() {
        return this.blockState.m_60734_().m_49961_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_jump_velocity_multiplier")
    public float getJumpVelocityMultiplier() {
        return this.blockState.m_60734_().m_49964_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_blast_resistance")
    public float getBlastResistance() {
        return this.blockState.m_60734_().m_7325_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.as_item")
    public ItemStackAPI asItem() {
        return ItemStackAPI.verify(this.blockState.m_60734_().m_5456_().m_7968_());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_tags")
    public List<String> getTags() {
        ArrayList<String> list = new ArrayList<String>();
        Registry registry = WorldAPI.getCurrentWorld().m_9598_().m_175515_(Registries.f_256747_);
        Optional key = registry.m_7854_((Object)this.blockState.m_60734_());
        if (key.isEmpty()) {
            return list;
        }
        for (TagKey blockTagKey : registry.m_246971_((ResourceKey)key.get()).m_203616_().toList()) {
            list.add(blockTagKey.f_203868_().toString());
        }
        return list;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.has_collision")
    public boolean hasCollision() {
        return ((BlockBehaviourAccessor)this.blockState.m_60734_()).hasCollision();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_collision_shape")
    public List<List<FiguraVec3>> getCollisionShape() {
        return BlockStateAPI.voxelShapeToTable(this.blockState.m_60812_((BlockGetter)WorldAPI.getCurrentWorld(), this.getBlockPos()));
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_outline_shape")
    public List<List<FiguraVec3>> getOutlineShape() {
        return BlockStateAPI.voxelShapeToTable(this.blockState.m_60808_((BlockGetter)WorldAPI.getCurrentWorld(), this.getBlockPos()));
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_sounds")
    public Map<String, Object> getSounds() {
        HashMap<String, Object> sounds = new HashMap<String, Object>();
        SoundType snd = this.blockState.m_60827_();
        sounds.put("pitch", Float.valueOf(snd.m_56774_()));
        sounds.put("volume", Float.valueOf(snd.m_56773_()));
        sounds.put("break", snd.m_56775_().m_11660_().toString());
        sounds.put("fall", snd.m_56779_().m_11660_().toString());
        sounds.put("hit", snd.m_56778_().m_11660_().toString());
        sounds.put("place", snd.m_56777_().m_11660_().toString());
        sounds.put("step", snd.m_56776_().m_11660_().toString());
        return sounds;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_fluid_tags")
    public List<String> getFluidTags() {
        ArrayList<String> list = new ArrayList<String>();
        for (TagKey fluidTagKey : this.blockState.m_60819_().m_205075_().toList()) {
            list.add(fluidTagKey.f_203868_().toString());
        }
        return list;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_entity_data")
    public LuaTable getEntityData() {
        BlockEntity entity = WorldAPI.getCurrentWorld().m_7702_(this.getBlockPos());
        return (LuaTable)NbtToLua.convert((Tag)(entity != null ? entity.m_187482_() : null));
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.to_state_string")
    public String toStateString() {
        BlockEntity entity = WorldAPI.getCurrentWorld().m_7702_(this.getBlockPos());
        CompoundTag tag = entity != null ? entity.m_187482_() : new CompoundTag();
        return BlockStateParser.m_116769_((BlockState)this.blockState) + String.valueOf(tag);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_textures")
    public HashMap<String, Set<String>> getTextures() {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        RenderShape renderShape = this.blockState.m_60799_();
        if (renderShape != RenderShape.MODEL) {
            return map;
        }
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        BakedModel bakedModel = blockRenderer.m_110910_(this.blockState);
        RandomSource randomSource = RandomSource.m_216327_();
        long seed = 42L;
        for (Direction direction : Direction.values()) {
            map.put(direction.name(), BlockStateAPI.getTexturesForFace(this.blockState, direction, randomSource, bakedModel, seed));
        }
        map.put("NONE", BlockStateAPI.getTexturesForFace(this.blockState, null, randomSource, bakedModel, seed));
        TextureAtlasSprite particle = blockRenderer.m_110907_().m_110882_(this.blockState);
        map.put("PARTICLE", Set.of(BlockStateAPI.getTextureName(particle)));
        return map;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.is_air")
    public boolean isAir() {
        return this.blockState.m_60795_();
    }

    private static Set<String> getTexturesForFace(BlockState blockState, Direction direction, RandomSource randomSource, BakedModel bakedModel, long seed) {
        randomSource.m_188584_(seed);
        List quads = bakedModel.m_213637_(blockState, direction, randomSource);
        HashSet<String> textures = new HashSet<String>();
        for (BakedQuad quad : quads) {
            textures.add(BlockStateAPI.getTextureName(quad.m_173410_()));
        }
        return textures;
    }

    private static String getTextureName(TextureAtlasSprite sprite) {
        ResourceLocation location = sprite.m_245424_().m_246162_();
        return location.m_135827_() + ":textures/" + location.m_135815_();
    }

    @LuaWhitelist
    public boolean __eq(BlockStateAPI other) {
        return this.blockState.equals(other.blockState);
    }

    @LuaWhitelist
    public Object __index(String arg) {
        if (arg == null) {
            return null;
        }
        return switch (arg) {
            case "id" -> this.id;
            case "properties" -> this.properties;
            default -> null;
        };
    }

    public String toString() {
        return this.id + " (BlockState)";
    }
}

