/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.lua.api;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.platform.Window;
import forge.org.figuramc.figura.FiguraMod;
import forge.org.figuramc.figura.lua.LuaNotNil;
import forge.org.figuramc.figura.lua.LuaWhitelist;
import forge.org.figuramc.figura.lua.api.TextureAtlasAPI;
import forge.org.figuramc.figura.lua.api.entity.EntityAPI;
import forge.org.figuramc.figura.lua.api.entity.ViewerAPI;
import forge.org.figuramc.figura.lua.docs.LuaMethodDoc;
import forge.org.figuramc.figura.lua.docs.LuaMethodOverload;
import forge.org.figuramc.figura.lua.docs.LuaTypeDoc;
import forge.org.figuramc.figura.math.vector.FiguraVec2;
import forge.org.figuramc.figura.math.vector.FiguraVec3;
import forge.org.figuramc.figura.mixin.gui.PlayerTabOverlayAccessor;
import forge.org.figuramc.figura.mixin.render.ModelManagerAccessor;
import forge.org.figuramc.figura.utils.EntityUtils;
import forge.org.figuramc.figura.utils.LuaUtils;
import forge.org.figuramc.figura.utils.PlatformUtils;
import forge.org.figuramc.figura.utils.TextUtils;
import forge.org.figuramc.figura.utils.Version;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.irisshaders.iris.api.v0.IrisApi;
import net.minecraft.SharedConstants;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaValue;

@LuaWhitelist
@LuaTypeDoc(name="ClientAPI", value="client")
public class ClientAPI {
    public static final ClientAPI INSTANCE = new ClientAPI();
    private static final HashMap<String, Boolean> LOADED_MODS = new HashMap();
    private static final boolean HAS_IRIS = PlatformUtils.isModLoaded("iris") || PlatformUtils.isModLoaded("oculus");
    public static final Supplier<Boolean> OPTIFINE_LOADED = Suppliers.memoize(() -> {
        try {
            Class.forName("net.optifine.Config");
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    });

    public static boolean hasOptifineShader() {
        try {
            Field shaderPackLoadedField = Class.forName("net.optifine.shaders.Shaders").getField("shaderPackLoaded");
            Class<?> shaderClass = shaderPackLoadedField.getType();
            if (shaderClass == Boolean.TYPE) {
                return shaderPackLoadedField.getBoolean(null);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return false;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_fps")
    public static int getFPS() {
        String s = ClientAPI.getFPSString();
        if (s.length() == 0) {
            return 0;
        }
        return Integer.parseInt(s.split(" ")[0]);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_fps_string")
    public static String getFPSString() {
        return Minecraft.m_91087_().f_90977_;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.is_paused")
    public static boolean isPaused() {
        return Minecraft.m_91087_().m_91104_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_version")
    public static String getVersion() {
        return SharedConstants.m_183709_().m_132492_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_version_name")
    public static String getVersionName() {
        return SharedConstants.m_183709_().m_132493_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.is_snapshot")
    public static boolean isSnapshot() {
        return !SharedConstants.m_183709_().m_132498_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_client_brand")
    public static String getClientBrand() {
        return ClientBrandRetriever.getClientModName();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_server_brand")
    public static String getServerBrand() {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return null;
        }
        return Minecraft.m_91087_().m_91092_() == null ? Minecraft.m_91087_().f_91074_.m_108629_() : "Integrated";
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_chunk_statistics")
    public static String getChunkStatistics() {
        return Minecraft.m_91087_().f_91060_.m_109820_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_entity_statistics")
    public static String getEntityStatistics() {
        return Minecraft.m_91087_().f_91060_.m_109822_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_sound_statistics")
    public static String getSoundStatistics() {
        return Minecraft.m_91087_().m_91106_().m_120408_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_entity_count")
    public static int getEntityCount() {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return 0;
        }
        return Minecraft.m_91087_().f_91073_.m_104813_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_particle_count")
    public static String getParticleCount() {
        return Minecraft.m_91087_().f_91061_.m_107403_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_current_effect")
    public static String getCurrentEffect() {
        if (Minecraft.m_91087_().f_91063_.m_109149_() == null) {
            return null;
        }
        return Minecraft.m_91087_().f_91063_.m_109149_().m_110022_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_java_version")
    public static String getJavaVersion() {
        return System.getProperty("java.version");
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_used_memory")
    public static long getUsedMemory() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_max_memory")
    public static long getMaxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_allocated_memory")
    public static long getAllocatedMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.is_window_focused")
    public static boolean isWindowFocused() {
        return Minecraft.m_91087_().m_91302_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.is_hud_enabled")
    public static boolean isHudEnabled() {
        return Minecraft.m_91404_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.is_debug_overlay_enabled")
    public static boolean isDebugOverlayEnabled() {
        return Minecraft.m_91087_().f_91066_.f_92063_;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_window_size")
    public static FiguraVec2 getWindowSize() {
        Window window = Minecraft.m_91087_().m_91268_();
        return FiguraVec2.of(window.m_85441_(), window.m_85442_());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_fov")
    public static double getFOV() {
        return ((Integer)Minecraft.m_91087_().f_91066_.m_231837_().m_231551_()).intValue();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_system_time")
    public static long getSystemTime() {
        return System.currentTimeMillis();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_mouse_pos")
    public static FiguraVec2 getMousePos() {
        MouseHandler mouse = Minecraft.m_91087_().f_91067_;
        return FiguraVec2.of(mouse.m_91589_(), mouse.m_91594_());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_scaled_window_size")
    public static FiguraVec2 getScaledWindowSize() {
        Window window = Minecraft.m_91087_().m_91268_();
        return FiguraVec2.of(window.m_85445_(), window.m_85446_());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_gui_scale")
    public static double getGuiScale() {
        return Minecraft.m_91087_().m_91268_().m_85449_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_camera_pos")
    public static FiguraVec3 getCameraPos() {
        Vec3 pos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        return FiguraVec3.fromVec3(pos);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_camera_rot")
    public static FiguraVec3 getCameraRot() {
        Quaternionf quaternion = Minecraft.m_91087_().f_91063_.m_109153_().m_253121_();
        Vector3f vec = new Vector3f();
        quaternion.getEulerAnglesYXZ(vec);
        double f = 57.29577951308232;
        return FiguraVec3.fromVec3f(vec).multiply(f, -f, f);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_camera_dir")
    public static FiguraVec3 getCameraDir() {
        return FiguraVec3.fromVec3f(Minecraft.m_91087_().f_91063_.m_109153_().m_253058_());
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"text"})}, value="client.get_text_width")
    public static int getTextWidth(@LuaNotNil String text) {
        return TextUtils.getWidth(TextUtils.splitText((FormattedText)TextUtils.tryParseJson(text), "\n"), Minecraft.m_91087_().f_91062_);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"text"})}, value="client.get_text_height")
    public static int getTextHeight(String text) {
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        int lineHeight = 9;
        return text == null ? lineHeight : lineHeight * TextUtils.splitText((FormattedText)TextUtils.tryParseJson(text), "\n").size();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"text"}), @LuaMethodOverload(argumentTypes={String.class, Integer.class, Boolean.class}, argumentNames={"text", "maxWidth", "wrap"})}, value="client.get_text_dimensions")
    public static FiguraVec2 getTextDimensions(@LuaNotNil String text, int maxWidth, Boolean wrap) {
        Component component = TextUtils.tryParseJson(text);
        Font font = Minecraft.m_91087_().f_91062_;
        List<Component> list = TextUtils.formatInBounds((FormattedText)component, font, maxWidth, wrap == null || wrap != false);
        int x = TextUtils.getWidth(list, font);
        int n = list.size();
        Objects.requireNonNull(font);
        int y = n * 9;
        return FiguraVec2.of(x, y);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_active_lang")
    public static String getActiveLang() {
        return Minecraft.m_91087_().f_91066_.f_92075_;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"modID"})}, value="client.is_mod_loaded")
    public static boolean isModLoaded(String id) {
        if (Objects.equals(id, "optifine") || Objects.equals(id, "optifabric")) {
            return OPTIFINE_LOADED.get();
        }
        LOADED_MODS.putIfAbsent(id, PlatformUtils.isModLoaded(id));
        return LOADED_MODS.get(id);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.has_iris")
    public static boolean hasIris() {
        return HAS_IRIS || OPTIFINE_LOADED.get() != false;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.has_iris_shader")
    public static boolean hasIrisShader() {
        return HAS_IRIS && IrisApi.getInstance().isShaderPackInUse() || OPTIFINE_LOADED.get() != false && ClientAPI.hasOptifineShader();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"path"})}, value="client.has_resource")
    public static boolean hasResource(@LuaNotNil String path) {
        ResourceLocation resource = LuaUtils.parsePath(path);
        try {
            return Minecraft.m_91087_().m_91098_().m_213713_(resource).isPresent();
        }
        catch (Exception ignored) {
            return false;
        }
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_active_resource_packs")
    public static List<String> getActiveResourcePacks() {
        ArrayList<String> list = new ArrayList<String>();
        for (Pack pack : Minecraft.m_91087_().m_91099_().m_10524_()) {
            list.add(pack.m_10429_().getString());
        }
        return list;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_figura_version")
    public static String getFiguraVersion() {
        return FiguraMod.VERSION.toString();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class, String.class}, argumentNames={"version1", "version2"})}, value="client.compare_versions")
    public static int compareVersions(@LuaNotNil String ver1, @LuaNotNil String ver2) {
        Version v1 = new Version(ver1);
        Version v2 = new Version(ver2);
        if (v1.invalid) {
            throw new LuaError("Cannot parse version \"" + ver1 + "\"");
        }
        if (v2.invalid) {
            throw new LuaError("Cannot parse version \"" + ver2 + "\"");
        }
        return v1.compareTo(v2);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Integer.class, Integer.class, Integer.class, Integer.class}, argumentNames={"a", "b", "c", "d"})}, value="client.int_uuid_to_string")
    public static String intUUIDToString(int a, int b, int c, int d) {
        try {
            UUID uuid = UUIDUtil.m_235885_((int[])new int[]{a, b, c, d});
            return uuid.toString();
        }
        catch (Exception ignored) {
            throw new LuaError("Failed to parse uuid");
        }
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"uuid"})}, value="client.uuid_to_int_array")
    public static int[] uuidToIntArray(String uuid) {
        try {
            UUID id = UUID.fromString(uuid);
            return UUIDUtil.m_235881_((UUID)id);
        }
        catch (Exception ignored) {
            throw new LuaError("Failed to parse uuid");
        }
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_viewer")
    public static ViewerAPI getViewer() {
        return new ViewerAPI((Player)Minecraft.m_91087_().f_91074_);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_camera_entity")
    public static EntityAPI<?> getCameraEntity() {
        return EntityAPI.wrap(Minecraft.m_91087_().m_91288_());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_server_data")
    public static Map<String, String> getServerData() {
        HashMap<String, String> map = new HashMap<String, String>();
        IntegratedServer iServer = Minecraft.m_91087_().m_91092_();
        if (iServer != null) {
            map.put("name", iServer.m_129910_().m_5462_());
            map.put("ip", iServer.m_130009_());
            map.put("motd", iServer.m_129916_());
            return map;
        }
        ServerData mServer = Minecraft.m_91087_().m_91089_();
        if (mServer != null) {
            map.put("name", mServer.f_105362_);
            map.put("ip", mServer.f_105363_);
            map.put("motd", mServer.f_105365_.getString());
        }
        return map;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_date")
    public static Map<String, Object> getDate() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Calendar calendar = FiguraMod.CALENDAR;
        Date date = new Date();
        calendar.setTime(date);
        map.put("day", calendar.get(5));
        map.put("month", calendar.get(2) + 1);
        map.put("year", calendar.get(1));
        map.put("hour", calendar.get(11));
        map.put("minute", calendar.get(12));
        map.put("second", calendar.get(13));
        map.put("millisecond", calendar.get(14));
        map.put("week", calendar.get(3));
        map.put("year_day", calendar.get(6));
        map.put("week_day", calendar.get(7));
        map.put("daylight_saving", calendar.getTimeZone().inDaylightTime(date));
        SimpleDateFormat format = new SimpleDateFormat("Z|zzzz|G|MMMM|EEEE", Locale.US);
        String[] f = format.format(date).split("\\|");
        map.put("timezone", f[0]);
        map.put("timezone_name", f[1]);
        map.put("era", f[2]);
        map.put("month_name", f[3]);
        map.put("day_name", f[4]);
        return map;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_frame_time")
    public static double getFrameTime() {
        return Minecraft.m_91087_().m_91296_();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.list_atlases")
    public static List<String> listAtlases() {
        ArrayList<String> list = new ArrayList<String>();
        for (ResourceLocation res : ModelManagerAccessor.getVanillaAtlases().keySet()) {
            list.add(res.toString());
        }
        return list;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"path"})}, value="client.get_atlas")
    public static TextureAtlasAPI getAtlas(@LuaNotNil String atlas) {
        ResourceLocation path = LuaUtils.parsePath(atlas);
        try {
            return new TextureAtlasAPI(Minecraft.m_91087_().m_91304_().m_119428_(path));
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_tab_list")
    public static Map<String, Object> getTabList() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        PlayerTabOverlayAccessor accessor = (PlayerTabOverlayAccessor)Minecraft.m_91087_().f_91065_.m_93088_();
        Component header = accessor.getHeader();
        if (header != null) {
            map.put("header", header.getString());
            map.put("headerJson", header);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (PlayerInfo entry : EntityUtils.getTabList()) {
            list.add(entry.m_105342_() != null ? entry.m_105342_().getString() : entry.m_105312_().getName());
        }
        map.put("players", list);
        Component footer = accessor.getFooter();
        if (footer != null) {
            map.put("footer", footer.getString());
            map.put("footerJson", footer);
        }
        return map;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"text"}), @LuaMethodOverload(argumentTypes={String.class, LuaValue.class}, argumentNames={"text", "args"})}, value="client.get_translated_string")
    public static String getTranslatedString(@LuaNotNil String text, LuaValue args) {
        MutableComponent component;
        if (args == null) {
            component = Component.m_237115_((String)text);
        } else if (!args.istable()) {
            component = Component.m_237110_((String)text, (Object[])new Object[]{args.tojstring()});
        } else {
            int len = args.length();
            Object[] arguments = new Object[len];
            for (int i = 0; i < len; ++i) {
                arguments[i] = args.get(i + 1).tojstring();
            }
            component = Component.m_237110_((String)text, (Object[])arguments);
        }
        return component.getString();
    }

    public String toString() {
        return "ClientAPI";
    }
}

