/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.lua;

import com.google.gson.JsonParser;
import forge.org.figuramc.figura.lua.FiguraLuaRuntime;
import forge.org.figuramc.figura.utils.JsonUtils;
import forge.org.figuramc.figura.utils.LuaUtils;
import java.util.Objects;
import java.util.function.Function;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.VarArgFunction;

public class FiguraLuaExtras {
    private static final Function<FiguraLuaRuntime, LuaValue> PARSE_JSON_FUNCTION = runtime -> new VarArgFunction(){

        public Varargs invoke(Varargs args) {
            return FiguraLuaExtras.jsonStringToTable(args.checkjstring(1));
        }

        public String tojstring() {
            return "function: parseJson";
        }
    };
    private static final Function<FiguraLuaRuntime, LuaValue> TO_JSON_FUNCTION = runtime -> new VarArgFunction(){

        public Varargs invoke(Varargs args) {
            return LuaValue.valueOf((String)FiguraLuaExtras.tableToJsonString(args.arg(1)));
        }

        public String tojstring() {
            return "function: toJson";
        }
    };

    public static void loadFunctions(FiguraLuaRuntime runtime) {
        LuaValue print = PARSE_JSON_FUNCTION.apply(runtime);
        runtime.setGlobal("parseJson", print);
        LuaValue printJson = TO_JSON_FUNCTION.apply(runtime);
        runtime.setGlobal("toJson", printJson);
    }

    public static LuaValue jsonStringToTable(String json) {
        return JsonUtils.asLuaValue(JsonParser.parseString((String)json));
    }

    public static String tableToJsonString(LuaValue value) {
        return Objects.requireNonNullElse(LuaUtils.asJsonValue(value), "null").toString();
    }
}

