/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.gui.widgets.config;

import forge.org.figuramc.figura.FiguraMod;
import forge.org.figuramc.figura.config.ConfigType;
import forge.org.figuramc.figura.config.InputType;
import forge.org.figuramc.figura.gui.widgets.ParentedButton;
import forge.org.figuramc.figura.gui.widgets.TextField;
import forge.org.figuramc.figura.gui.widgets.config.AbstractConfigElement;
import forge.org.figuramc.figura.gui.widgets.config.CategoryWidget;
import forge.org.figuramc.figura.gui.widgets.lists.ConfigList;
import forge.org.figuramc.figura.utils.ColorUtils;
import forge.org.figuramc.figura.utils.ui.UIHelper;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;

public class InputElement
extends AbstractConfigElement {
    private final TextField textField;
    private final InputType inputType;

    public InputElement(int width, ConfigType.InputConfig<?> config, ConfigList parentList, CategoryWidget parentCategory) {
        super(width, config, parentList, parentCategory);
        this.inputType = config.inputType;
        this.textField = new InputField(0, 0, 90, 20, this.inputType.hint, this, text -> {
            if (this.inputType.validator.test((String)text)) {
                config.setTempValue((String)text);
            }
        });
        this.updateTextFieldText(this.formatText(config.tempValue));
        this.textField.getField().m_94198_();
        this.textField.setEnabled(FiguraMod.debugModeEnabled() || !config.disabled);
        this.children.add(0, this.textField);
        this.children.remove(this.resetButton);
        this.resetButton = new ParentedButton(this.m_252754_() + width - 60, this.m_252907_(), 60, 20, (Component)Component.m_237115_((String)"controls.reset"), this, button -> {
            config.resetTemp();
            this.updateTextFieldText(this.formatText(config.tempValue));
        });
        this.children.add(this.resetButton);
    }

    @Override
    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        if (!this.isVisible()) {
            return;
        }
        this.resetButton.setActive(!this.isDefault());
        int color = 0xFFFFFF;
        String text = this.textField.getField().m_94155_();
        if (!this.inputType.validator.test(text)) {
            color = 0xFF5555;
        } else if (!text.equals(this.formatText(this.initValue))) {
            TextColor textColor = FiguraMod.getAccentColor().m_131135_();
            color = textColor == null ? ColorUtils.Colors.AWESOME_BLUE.hex : textColor.m_131265_();
        }
        this.textField.setColor(color);
        this.textField.setBorderColour(-16777216 + color);
        super.m_88315_(gui, mouseX, mouseY, delta);
        if (this.inputType == InputType.HEX_COLOR) {
            int x = this.m_252754_() + this.m_5711_() - 178;
            int y = this.m_252907_();
            if (this.getTextField().m_93696_()) {
                UIHelper.fillRounded(gui, x, y, 20, 20, this.getTextField().getBorderColour());
            } else {
                UIHelper.blitSliced(gui, x, y, 20, 20, UIHelper.OUTLINE);
            }
            UIHelper.fillRounded(gui, x + 1, y + 1, 18, 18, (Integer)this.config.tempValue + -16777216);
        }
    }

    @Override
    public void m_252865_(int x) {
        super.m_252865_(x);
        this.textField.m_252865_(x + this.m_5711_() - 154);
    }

    @Override
    public void m_253211_(int y) {
        super.m_253211_(y);
        this.textField.m_253211_(y);
    }

    @Override
    public boolean isDefault() {
        return this.textField.getField().m_94155_().equals(this.formatText(this.config.defaultValue));
    }

    @Override
    public boolean isChanged() {
        return !this.textField.getField().m_94155_().equals(this.formatText(this.initValue));
    }

    public TextField getTextField() {
        return this.textField;
    }

    public void updateTextFieldText(String text) {
        this.textField.getField().m_94144_(text);
    }

    private String formatText(Object configValue) {
        return this.inputType == InputType.HEX_COLOR ? String.format("#%06X", (int)((Integer)configValue)) : configValue.toString();
    }

    private static class InputField
    extends TextField {
        private final InputElement parent;

        public InputField(int x, int y, int width, int height, TextField.HintType hint, InputElement parent, Consumer<String> changedListener) {
            super(x, y, width, height, hint, changedListener);
            this.parent = parent;
        }

        @Override
        public boolean m_5953_(double mouseX, double mouseY) {
            return this.parent.isHovered() && super.m_5953_(mouseX, mouseY);
        }
    }
}

