/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.gui.widgets.avatar;

import forge.org.figuramc.figura.avatar.local.LocalAvatarFetcher;
import forge.org.figuramc.figura.gui.widgets.ContainerButton;
import forge.org.figuramc.figura.gui.widgets.avatar.AbstractAvatarWidget;
import forge.org.figuramc.figura.gui.widgets.avatar.AvatarWidget;
import forge.org.figuramc.figura.gui.widgets.lists.AvatarList;
import forge.org.figuramc.figura.utils.ui.UIHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.client.gui.GuiGraphics;

public class AvatarFolderWidget
extends AbstractAvatarWidget {
    private final HashMap<String, AbstractAvatarWidget> entries = new HashMap();
    private final ArrayList<AbstractAvatarWidget> sortedEntries = new ArrayList();

    public AvatarFolderWidget(final int depth, int width, LocalAvatarFetcher.FolderPath avatar, AvatarList parent) {
        super(depth, width, 20, avatar, parent);
        final AvatarFolderWidget instance = this;
        this.button = new ContainerButton(parent, this.m_252754_(), this.m_252907_(), width, 20, this.getName(), null, button -> {
            this.toggleEntries(this.showChildren());
            parent.updateScroll();
        }){

            @Override
            protected void renderText(GuiGraphics gui, float delta) {
                int x = this.m_252754_();
                int width = this.m_5711_();
                int space = Math.max(6 * depth - 2, 0);
                this.m_252865_(x + space);
                this.m_93674_(width - space);
                super.renderText(gui, delta);
                this.m_252865_(x);
                this.m_93674_(width);
                if (this.tooltip() == this.m_6035_()) {
                    this.setTooltip(instance.getName());
                }
            }

            @Override
            public void setHovered(boolean hovered) {
                if (!hovered && UIHelper.getContext() == AvatarFolderWidget.this.context && AvatarFolderWidget.this.context.isVisible()) {
                    hovered = true;
                }
                super.setHovered(hovered);
            }
        };
        this.children.add(this.button);
        this.update(avatar, "");
        boolean expanded = avatar.isExpanded();
        ((ContainerButton)this.button).setToggled(expanded);
        this.button.shouldHaveBackground(false);
        this.toggleEntries(expanded);
        parent.updateScroll();
    }

    @Override
    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        if (!this.isVisible() || !this.button.isVisible()) {
            return;
        }
        if (this.showChildren()) {
            int y0 = this.parent.m_252907_() + this.parent.scissorsY;
            int y1 = y0 + this.parent.m_93694_() + this.parent.scissorsHeight;
            for (AbstractAvatarWidget value : this.entries.values()) {
                value.button.setVisible(value.m_252907_() < y1 && value.m_252907_() + value.m_93694_() > y0);
            }
            super.m_88315_(gui, mouseX, mouseY, delta);
            for (AbstractAvatarWidget value : this.entries.values()) {
                value.button.setVisible(true);
            }
        } else {
            super.m_88315_(gui, mouseX, mouseY, delta);
        }
    }

    @Override
    public void update(LocalAvatarFetcher.AvatarPath path, String filter) {
        super.update(path, filter);
        if (!(path instanceof LocalAvatarFetcher.FolderPath)) {
            return;
        }
        LocalAvatarFetcher.FolderPath folderPath = (LocalAvatarFetcher.FolderPath)path;
        for (AbstractAvatarWidget value : this.entries.values()) {
            value.filter = this.filter;
        }
        HashSet<String> missingPaths = new HashSet<String>(this.entries.keySet());
        for (LocalAvatarFetcher.AvatarPath child : folderPath.getChildren()) {
            String str = String.valueOf(child.getPath()) + child.getName();
            if (!child.search(filter)) continue;
            AbstractAvatarWidget childEntry = this.entries.get(str);
            if (childEntry != null) {
                childEntry.update(child, filter);
            }
            missingPaths.remove(str);
            this.entries.computeIfAbsent(str, s -> {
                AbstractAvatarWidget abstractAvatarWidget;
                if (child instanceof LocalAvatarFetcher.FolderPath) {
                    LocalAvatarFetcher.FolderPath folder = (LocalAvatarFetcher.FolderPath)child;
                    abstractAvatarWidget = new AvatarFolderWidget(this.depth + 1, this.m_5711_(), folder, this.parent);
                } else {
                    abstractAvatarWidget = new AvatarWidget(this.depth + 1, this.m_5711_(), child, this.parent);
                }
                AbstractAvatarWidget entry = abstractAvatarWidget;
                this.children.add(entry);
                entry.setVisible(this.showChildren());
                return entry;
            });
        }
        for (String str : missingPaths) {
            this.children.remove(this.entries.remove(str));
        }
        this.sortedEntries.clear();
        this.sortedEntries.addAll(this.entries.values());
        this.children.sort((children1, children2) -> {
            if (children1 instanceof AbstractAvatarWidget) {
                AbstractAvatarWidget avatar1 = (AbstractAvatarWidget)children1;
                if (children2 instanceof AbstractAvatarWidget) {
                    AbstractAvatarWidget avatar2 = (AbstractAvatarWidget)children2;
                    return avatar1.compareTo(avatar2);
                }
            }
            return 0;
        });
        this.sortedEntries.sort(AbstractAvatarWidget::compareTo);
        this.updateHeight();
    }

    public void toggleEntries(boolean toggle) {
        toggle = toggle && this.showChildren();
        this.avatar.setExpanded(toggle);
        for (AbstractAvatarWidget widget : this.entries.values()) {
            widget.setVisible(toggle);
            if (!(widget instanceof AvatarFolderWidget)) continue;
            AvatarFolderWidget folder = (AvatarFolderWidget)widget;
            folder.toggleEntries(toggle);
        }
        this.updateHeight();
    }

    private void updateHeight() {
        int height = 20;
        boolean show = this.showChildren();
        for (AbstractAvatarWidget entry : this.entries.values()) {
            if (entry instanceof AvatarFolderWidget) {
                AvatarFolderWidget folder = (AvatarFolderWidget)entry;
                folder.updateHeight();
            }
            if (!show) continue;
            height += entry.m_93694_() + 2;
        }
        this.setHeight(height);
    }

    @Override
    public void m_252865_(int x) {
        super.m_252865_(x);
        for (AbstractAvatarWidget widget : this.sortedEntries) {
            if (!widget.isVisible()) continue;
            widget.m_252865_(x);
        }
    }

    @Override
    public void m_253211_(int y) {
        super.m_253211_(y);
        y = 22;
        for (AbstractAvatarWidget widget : this.sortedEntries) {
            if (!widget.isVisible()) continue;
            widget.m_253211_(this.m_252907_() + y);
            y += widget.m_93694_() + 2;
        }
    }

    @Override
    public boolean filtered() {
        boolean result = super.filtered();
        for (AbstractAvatarWidget value : this.entries.values()) {
            if (result) break;
            result = value.filtered();
        }
        return result;
    }

    public boolean showChildren() {
        return ((ContainerButton)this.button).isToggled();
    }
}

