/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.gui.widgets;

import forge.org.figuramc.figura.gui.widgets.FiguraWidget;
import forge.org.figuramc.figura.utils.FiguraIdentifier;
import forge.org.figuramc.figura.utils.ui.UIHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class Button
extends net.minecraft.client.gui.components.Button
implements FiguraWidget {
    private static final ResourceLocation TEXTURE = new FiguraIdentifier("textures/gui/button.png");
    protected Integer u;
    protected Integer v;
    protected final Integer textureWidth;
    protected final Integer textureHeight;
    protected final Integer regionSize;
    protected final ResourceLocation texture;
    protected Component tooltip;
    protected Tooltip actualTooltip;
    private boolean hasBackground = true;

    public Button(int x, int y, int width, int height, Integer u, Integer v, Integer regionSize, ResourceLocation texture, Integer textureWidth, Integer textureHeight, Component text, Component tooltip, Button.OnPress pressAction) {
        super(x, y, width, height, text, pressAction, f_252438_);
        this.u = u;
        this.v = v;
        this.regionSize = regionSize;
        this.texture = texture;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.tooltip = tooltip;
    }

    public Button(int x, int y, int width, int height, Component text, Component tooltip, Button.OnPress pressAction) {
        this(x, y, width, height, null, null, null, null, null, null, text, tooltip, pressAction);
    }

    public Button(int x, int y, int width, int height, int u, int v, int regionSize, ResourceLocation texture, int textureWidth, int textureHeight, Component tooltip, Button.OnPress pressAction) {
        this(x, y, width, height, u, v, regionSize, texture, textureWidth, textureHeight, (Component)Component.m_237119_(), tooltip, pressAction);
    }

    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        if (!this.isVisible()) {
            return;
        }
        this.setHovered(this.m_5953_(mouseX, mouseY));
        this.m_87963_(gui, mouseX, mouseY, delta);
    }

    public void m_87963_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        if (this.texture != null) {
            this.renderTexture(gui, delta);
        } else {
            this.renderDefaultTexture(gui, delta);
        }
        this.renderText(gui, delta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return this.m_198029_() && this.m_5953_(mouseX, mouseY) && super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        boolean over = UIHelper.isMouseOver(this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), mouseX, mouseY);
        if (over && this.tooltip != null) {
            UIHelper.setTooltip(this.tooltip);
        }
        return over;
    }

    protected void renderDefaultTexture(GuiGraphics gui, float delta) {
        UIHelper.blitSliced(gui, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), (float)this.getU() * 16.0f, (float)this.getV() * 16.0f, 16, 16, 48, 32, TEXTURE);
    }

    protected void renderTexture(GuiGraphics gui, float delta) {
        int u = this.u + this.getU() * this.regionSize;
        int v = this.v + this.getV() * this.regionSize;
        UIHelper.enableBlend();
        int size = this.regionSize;
        gui.m_280163_(this.texture, this.m_252754_() + this.m_5711_() / 2 - size / 2, this.m_252907_() + this.m_93694_() / 2 - size / 2, (float)u, (float)v, size, size, this.textureWidth.intValue(), this.textureHeight.intValue());
    }

    protected void renderText(GuiGraphics gui, float delta) {
        UIHelper.renderCenteredScrollingText(gui, this.m_6035_(), this.m_252754_() + 1, this.m_252907_(), this.m_5711_() - 2, this.m_93694_(), this.getTextColor());
    }

    protected void renderVanillaBackground(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        Component message = this.m_6035_();
        this.m_93666_((Component)Component.m_237119_());
        super.m_87963_(gui, mouseX, mouseY, delta);
        this.m_93666_(message);
    }

    protected int getU() {
        if (!this.m_142518_()) {
            return 0;
        }
        if (this.m_198029_()) {
            return 2;
        }
        return 1;
    }

    protected int getV() {
        return this.hasBackground ? 0 : 1;
    }

    protected int getTextColor() {
        return (!this.m_142518_() ? ChatFormatting.DARK_GRAY : ChatFormatting.WHITE).m_126665_();
    }

    public void setTooltip(Component tooltip) {
        this.tooltip = tooltip;
        this.actualTooltip = Tooltip.m_257550_((Component)tooltip);
    }

    public Tooltip m_278622_() {
        return this.actualTooltip;
    }

    public Component tooltip() {
        return this.tooltip;
    }

    public void shouldHaveBackground(boolean bool) {
        this.hasBackground = bool;
    }

    public void setHovered(boolean hovered) {
        this.f_93622_ = hovered;
    }

    public void run() {
        this.m_7435_(Minecraft.m_91087_().m_91106_());
        this.m_5691_();
    }

    @Override
    public boolean isVisible() {
        return this.f_93624_;
    }

    @Override
    public void setVisible(boolean visible) {
        this.f_93624_ = visible;
    }

    @Override
    public int m_252754_() {
        return super.m_252754_();
    }

    @Override
    public void m_252865_(int x) {
        super.m_252865_(x);
    }

    @Override
    public int m_252907_() {
        return super.m_252907_();
    }

    @Override
    public void m_253211_(int y) {
        super.m_253211_(y);
    }

    @Override
    public int m_5711_() {
        return super.m_5711_();
    }

    @Override
    public void m_93674_(int width) {
        super.m_93674_(width);
    }

    @Override
    public int m_93694_() {
        return super.m_93694_();
    }

    @Override
    public void setHeight(int height) {
        this.f_93619_ = height;
    }

    public boolean m_142518_() {
        return this.f_93623_;
    }

    public void setActive(boolean active) {
        this.f_93623_ = active;
    }
}

