/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.font;

import forge.org.figuramc.figura.font.EmojiMetadata;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class EmojiUnicodeLookup {
    private final Map<String, String> unicodeLookup = new HashMap<String, String>();
    private final HashMap<String, String[]> reverseUnicodeLookup = new HashMap();
    private final Map<Integer, EmojiMetadata> metadataLookup = new HashMap<Integer, EmojiMetadata>();
    private final Map<String, String> shortcutLookup = new HashMap<String, String>();

    public void putAliases(String[] aliases, String unicode) {
        for (String alias : aliases) {
            this.unicodeLookup.put(alias, unicode);
        }
        this.reverseUnicodeLookup.put(unicode, aliases);
    }

    public void putShortcuts(String[] aliases, String unicode) {
        for (String alias : aliases) {
            this.shortcutLookup.put(alias, unicode);
        }
    }

    public void putMetadata(int codepoint, EmojiMetadata metadata) {
        this.metadataLookup.put(codepoint, metadata);
    }

    public Collection<String> getNames() {
        return this.unicodeLookup.keySet();
    }

    public Collection<String> getShortcuts() {
        return this.shortcutLookup.keySet();
    }

    @Nullable
    public EmojiMetadata getMetadata(int codepoint) {
        return this.metadataLookup.getOrDefault(codepoint, null);
    }

    @Nullable
    public String getUnicode(String emojiAlias) {
        return this.unicodeLookup.getOrDefault(emojiAlias, null);
    }

    @Nullable
    public String getUnicodeForShortcut(String shortcut) {
        return this.shortcutLookup.getOrDefault(shortcut, null);
    }

    @Nullable
    public String[] getAliases(String unicode) {
        return this.reverseUnicodeLookup.getOrDefault(unicode, null);
    }

    public Collection<EmojiMetadata> metadataValues() {
        return this.metadataLookup.values();
    }

    public Set<String> aliasValues() {
        return this.unicodeLookup.keySet();
    }

    public Collection<String> unicodeValues() {
        return this.unicodeLookup.values();
    }
}

