/*
 * Decompiled with CFR 0.152.
 */
package forge.org.figuramc.figura.backend2;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import forge.org.figuramc.figura.FiguraMod;
import forge.org.figuramc.figura.backend2.HttpAPI;
import forge.org.figuramc.figura.backend2.NetworkStuff;
import forge.org.figuramc.figura.resources.FiguraRuntimeResources;
import forge.org.figuramc.figura.utils.FiguraClientCommandSource;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public class BackendCommands {
    public static LiteralArgumentBuilder<FiguraClientCommandSource> getCommand() {
        LiteralArgumentBuilder backend = LiteralArgumentBuilder.literal((String)"backend2");
        LiteralArgumentBuilder connect = LiteralArgumentBuilder.literal((String)"connect");
        connect.executes(context -> {
            NetworkStuff.reAuth();
            return 1;
        });
        backend.then((ArgumentBuilder)connect);
        LiteralArgumentBuilder run = LiteralArgumentBuilder.literal((String)"run");
        run.executes(context -> BackendCommands.runRequest((CommandContext<FiguraClientCommandSource>)context, ""));
        RequiredArgumentBuilder request = RequiredArgumentBuilder.argument((String)"request", (ArgumentType)StringArgumentType.greedyString());
        request.executes(context -> BackendCommands.runRequest((CommandContext<FiguraClientCommandSource>)context, StringArgumentType.getString((CommandContext)context, (String)"request")));
        run.then((ArgumentBuilder)request);
        backend.then((ArgumentBuilder)run);
        LiteralArgumentBuilder debug = LiteralArgumentBuilder.literal((String)"debug");
        debug.executes(context -> {
            NetworkStuff.debug = !NetworkStuff.debug;
            FiguraMod.sendChatMessage((Component)Component.m_237113_((String)("Backend Debug Mode set to: " + NetworkStuff.debug)).m_130940_(NetworkStuff.debug ? ChatFormatting.GREEN : ChatFormatting.RED));
            return 1;
        });
        backend.then((ArgumentBuilder)debug);
        LiteralArgumentBuilder resources = LiteralArgumentBuilder.literal((String)"checkResources");
        resources.executes(context -> {
            ((FiguraClientCommandSource)context.getSource()).figura$sendFeedback((Component)Component.m_237113_((String)"Checking for resources..."));
            FiguraRuntimeResources.init().thenRun(() -> ((FiguraClientCommandSource)context.getSource()).figura$sendFeedback((Component)Component.m_237113_((String)"Resources checked!")));
            return 1;
        });
        backend.then((ArgumentBuilder)resources);
        return backend;
    }

    private static int runRequest(CommandContext<FiguraClientCommandSource> context, String request) {
        try {
            HttpAPI.runString(NetworkStuff.api.header(request).build(), (code, data) -> FiguraMod.sendChatMessage((Component)Component.m_237113_((String)data)));
            return 1;
        }
        catch (Exception e) {
            ((FiguraClientCommandSource)context.getSource()).figura$sendError((Component)Component.m_237113_((String)e.getMessage()));
            return 0;
        }
    }
}

