/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.permissions;

import fabric.org.figuramc.figura.FiguraMod;
import fabric.org.figuramc.figura.config.Configs;
import fabric.org.figuramc.figura.entries.FiguraPermissions;
import fabric.org.figuramc.figura.permissions.PermissionPack;
import fabric.org.figuramc.figura.permissions.Permissions;
import fabric.org.figuramc.figura.utils.IOUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class PermissionManager {
    public static final Map<Permissions.Category, PermissionPack.CategoryPermissionPack> CATEGORIES = new LinkedHashMap<Permissions.Category, PermissionPack.CategoryPermissionPack>();
    private static final Map<UUID, PermissionPack.PlayerPermissionPack> PLAYERS = new HashMap<UUID, PermissionPack.PlayerPermissionPack>();
    private static final Set<UUID> BACKEND_CHECKED = new HashSet<UUID>();
    public static final Map<String, Collection<Permissions>> CUSTOM_PERMISSIONS = new HashMap<String, Collection<Permissions>>();

    public static void init() {
        for (Permissions.Category category : Permissions.Category.values()) {
            PermissionPack.CategoryPermissionPack container = new PermissionPack.CategoryPermissionPack(category);
            CATEGORIES.put(category, container);
        }
        IOUtils.readCacheFile("permissions", PermissionManager::readNbt);
    }

    public static void reinit() {
        BACKEND_CHECKED.clear();
        CATEGORIES.clear();
        PLAYERS.clear();
        PermissionManager.init();
    }

    public static void initEntryPoints(Set<FiguraPermissions> set) {
        for (FiguraPermissions figuraPermissions : set) {
            CUSTOM_PERMISSIONS.put(figuraPermissions.getTitle(), figuraPermissions.getPermissions());
        }
    }

    private static void readNbt(class_2487 nbt) {
        String name;
        class_2487 compound;
        class_2499 groupList = nbt.method_10554("groups", 10);
        class_2499 playerList = nbt.method_10554("players", 10);
        for (class_2520 nbtElement : groupList) {
            compound = (class_2487)nbtElement;
            name = compound.method_10558("name");
            try {
                Permissions.Category category = Permissions.Category.valueOf(name);
                PermissionPack pack = CATEGORIES.get((Object)category);
                pack.loadNbt(compound);
            }
            catch (Exception ignored) {
                FiguraMod.LOGGER.warn("Failed to load permissions for \"{}\"", (Object)name);
            }
        }
        for (class_2520 value : playerList) {
            compound = (class_2487)value;
            name = compound.method_10558("name");
            try {
                UUID uuid = UUID.fromString(name);
                String parent = compound.method_10558("category");
                Permissions.Category category = Permissions.Category.valueOf(parent);
                PermissionPack.CategoryPermissionPack parentPack = CATEGORIES.get((Object)category);
                PermissionPack.PlayerPermissionPack pack = new PermissionPack.PlayerPermissionPack(parentPack, name);
                pack.loadNbt(compound);
                PLAYERS.put(uuid, pack);
            }
            catch (Exception ignored) {
                FiguraMod.LOGGER.warn("Failed to load permissions for \"{}\"", (Object)name);
            }
        }
    }

    public static void saveToDisk() {
        IOUtils.saveCacheFile("permissions", nbt -> {
            class_2499 groupList = new class_2499();
            class_2499 playerList = new class_2499();
            for (PermissionPack permissionPack : CATEGORIES.values()) {
                if (!permissionPack.hasChanges()) continue;
                class_2487 container = new class_2487();
                permissionPack.writeNbt(container);
                groupList.add((Object)container);
            }
            for (PermissionPack.PlayerPermissionPack playerPermissionPack : PLAYERS.values()) {
                Permissions.Category category = PermissionManager.getDefaultCategory();
                if (category == null) {
                    category = Permissions.Category.DEFAULT;
                }
                if (!playerPermissionPack.hasChanges() && playerPermissionPack.getCategory() == category) continue;
                class_2487 container = new class_2487();
                playerPermissionPack.writeNbt(container);
                playerList.add((Object)container);
            }
            nbt.method_10566("groups", (class_2520)groupList);
            nbt.method_10566("players", (class_2520)playerList);
            FiguraMod.debug("Saved Permissions", new Object[0]);
        });
    }

    public static PermissionPack.PlayerPermissionPack get(UUID id) {
        if (PLAYERS.containsKey(id)) {
            return PLAYERS.get(id);
        }
        Permissions.Category category = PermissionManager.getDefaultCategory();
        if (FiguraMod.isLocal(id)) {
            category = Permissions.Category.MAX;
        } else if (category == null) {
            category = Permissions.Category.DEFAULT;
        }
        PermissionPack.PlayerPermissionPack pack = new PermissionPack.PlayerPermissionPack(CATEGORIES.get((Object)category), id.toString());
        PLAYERS.put(id, pack);
        FiguraMod.debug("Created Permissions for: " + String.valueOf(id), new Object[0]);
        return pack;
    }

    public static PermissionPack.PlayerPermissionPack getMobPermissions(UUID id) {
        PermissionPack.PlayerPermissionPack pack = new PermissionPack.PlayerPermissionPack(CATEGORIES.get((Object)Permissions.Category.MAX), id.toString());
        pack.insert(Permissions.OFFSCREEN_RENDERING, 0, "figura");
        return pack;
    }

    public static boolean increaseCategory(PermissionPack container) {
        return PermissionManager.changeCategory(container, container.getCategory().index + 1);
    }

    public static boolean decreaseCategory(PermissionPack container) {
        return PermissionManager.changeCategory(container, container.getCategory().index - 1);
    }

    private static boolean changeCategory(PermissionPack container, int index) {
        Permissions.Category newCategory = Permissions.Category.indexOf(index);
        if (newCategory == null) {
            return false;
        }
        container.setCategory(CATEGORIES.get((Object)newCategory));
        PermissionManager.saveToDisk();
        return true;
    }

    public static void setDefaultFor(UUID id, Permissions.Category defaultCat) {
        PermissionPack.PlayerPermissionPack pack;
        boolean canAdd;
        if (BACKEND_CHECKED.contains(id)) {
            return;
        }
        if (!PLAYERS.containsKey(id)) {
            canAdd = true;
        } else {
            pack = PLAYERS.get(id);
            Permissions.Category def = PermissionManager.getDefaultCategory();
            if (def == null) {
                def = Permissions.Category.DEFAULT;
            }
            boolean bl = canAdd = !pack.hasChanges() && pack.getCategory() == def;
        }
        if (canAdd) {
            pack = new PermissionPack.PlayerPermissionPack(CATEGORIES.get((Object)defaultCat), id.toString());
            PLAYERS.put(id, pack);
            FiguraMod.debug("Set permissions of {} to {} based on backend userdata", id, defaultCat.name());
        }
        BACKEND_CHECKED.add(id);
    }

    public static Permissions.Category getDefaultCategory() {
        return Permissions.Category.indexOf((Integer)Configs.DEFAULT_PERMISSION_LEVEL.value);
    }
}

