/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.model.rendering;

import fabric.org.figuramc.figura.lua.LuaWhitelist;
import fabric.org.figuramc.figura.lua.docs.LuaMethodDoc;
import fabric.org.figuramc.figura.lua.docs.LuaMethodOverload;
import fabric.org.figuramc.figura.lua.docs.LuaTypeDoc;
import fabric.org.figuramc.figura.math.vector.FiguraVec2;
import fabric.org.figuramc.figura.math.vector.FiguraVec3;
import fabric.org.figuramc.figura.utils.LuaUtils;

@LuaWhitelist
@LuaTypeDoc(name="Vertex", value="vertex")
public class Vertex {
    public float x;
    public float y;
    public float z;
    public float u;
    public float v;
    public float nx;
    public float ny;
    public float nz;

    public Vertex(float x, float y, float z, float u, float v, float nx, float ny, float nz) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.u = u;
        this.v = v;
        this.nx = nx;
        this.ny = ny;
        this.nz = nz;
    }

    public Vertex copy() {
        return new Vertex(this.x, this.y, this.z, this.u, this.v, this.nx, this.ny, this.nz);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="vertex.get_pos")
    public FiguraVec3 getPos() {
        return FiguraVec3.of(this.x, this.y, this.z);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"pos"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, aliases={"pos"}, value="vertex.set_pos")
    public Vertex setPos(Object x, Double y, Double z) {
        FiguraVec3 vec = LuaUtils.parseVec3("setPos", x, y, z);
        this.x = (float)vec.x;
        this.y = (float)vec.y;
        this.z = (float)vec.z;
        return this;
    }

    @LuaWhitelist
    public Vertex pos(Object x, Double y, Double z) {
        return this.setPos(x, y, z);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="vertex.get_uv")
    public FiguraVec2 getUV() {
        return FiguraVec2.of(this.u, this.v);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec2.class}, argumentNames={"UV"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class}, argumentNames={"u", "v"})}, aliases={"uv"}, value="vertex.set_uv")
    public Vertex setUV(Object x, Double y) {
        FiguraVec2 vec = LuaUtils.parseVec2("setUV", x, y);
        this.u = (float)vec.x;
        this.v = (float)vec.y;
        return this;
    }

    @LuaWhitelist
    public Vertex uv(Object x, Double y) {
        return this.setUV(x, y);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="vertex.get_normal")
    public FiguraVec3 getNormal() {
        return FiguraVec3.of(this.nx, this.ny, this.nz);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"normal"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, aliases={"normal"}, value="vertex.set_normal")
    public Vertex setNormal(Object x, Double y, Double z) {
        FiguraVec3 vec = LuaUtils.parseVec3("setNormal", x, y, z);
        this.setNormal(vec);
        return this;
    }

    public void setNormal(FiguraVec3 vec) {
        this.nx = (float)vec.x;
        this.ny = (float)vec.y;
        this.nz = (float)vec.z;
    }

    @LuaWhitelist
    public Vertex normal(Object x, Double y, Double z) {
        return this.setNormal(x, y, z);
    }

    public String toString() {
        return "Vertex";
    }
}

