/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.model;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import fabric.org.figuramc.figura.FiguraMod;
import fabric.org.figuramc.figura.animation.Animation;
import fabric.org.figuramc.figura.animation.Interpolation;
import fabric.org.figuramc.figura.animation.Keyframe;
import fabric.org.figuramc.figura.animation.TransformType;
import fabric.org.figuramc.figura.avatar.Avatar;
import fabric.org.figuramc.figura.config.Configs;
import fabric.org.figuramc.figura.math.vector.FiguraVec2;
import fabric.org.figuramc.figura.math.vector.FiguraVec3;
import fabric.org.figuramc.figura.math.vector.FiguraVec4;
import fabric.org.figuramc.figura.model.FiguraModelPart;
import fabric.org.figuramc.figura.model.ParentType;
import fabric.org.figuramc.figura.model.PartCustomization;
import fabric.org.figuramc.figura.model.rendering.Vertex;
import fabric.org.figuramc.figura.model.rendering.texture.FiguraTextureSet;
import fabric.org.figuramc.figura.model.rendering.texture.RenderTypes;
import fabric.org.figuramc.figura.utils.MathUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3532;

public class FiguraModelPartReader {
    private static final Map<String, FiguraVec3[]> faceData = ImmutableMap.of((Object)"n", (Object)new FiguraVec3[]{FiguraVec3.of(1.0, 0.0, 0.0), FiguraVec3.of(0.0, 0.0, 0.0), FiguraVec3.of(0.0, 1.0, 0.0), FiguraVec3.of(1.0, 1.0, 0.0), FiguraVec3.of(0.0, 0.0, -1.0)}, (Object)"s", (Object)new FiguraVec3[]{FiguraVec3.of(0.0, 0.0, 1.0), FiguraVec3.of(1.0, 0.0, 1.0), FiguraVec3.of(1.0, 1.0, 1.0), FiguraVec3.of(0.0, 1.0, 1.0), FiguraVec3.of(0.0, 0.0, 1.0)}, (Object)"e", (Object)new FiguraVec3[]{FiguraVec3.of(1.0, 0.0, 1.0), FiguraVec3.of(1.0, 0.0, 0.0), FiguraVec3.of(1.0, 1.0, 0.0), FiguraVec3.of(1.0, 1.0, 1.0), FiguraVec3.of(1.0, 0.0, 0.0)}, (Object)"w", (Object)new FiguraVec3[]{FiguraVec3.of(0.0, 0.0, 0.0), FiguraVec3.of(0.0, 0.0, 1.0), FiguraVec3.of(0.0, 1.0, 1.0), FiguraVec3.of(0.0, 1.0, 0.0), FiguraVec3.of(-1.0, 0.0, 0.0)}, (Object)"u", (Object)new FiguraVec3[]{FiguraVec3.of(0.0, 1.0, 1.0), FiguraVec3.of(1.0, 1.0, 1.0), FiguraVec3.of(1.0, 1.0, 0.0), FiguraVec3.of(0.0, 1.0, 0.0), FiguraVec3.of(0.0, 1.0, 0.0)}, (Object)"d", (Object)new FiguraVec3[]{FiguraVec3.of(0.0, 0.0, 0.0), FiguraVec3.of(1.0, 0.0, 0.0), FiguraVec3.of(1.0, 0.0, 1.0), FiguraVec3.of(0.0, 0.0, 1.0), FiguraVec3.of(0.0, -1.0, 0.0)});
    private static final FiguraVec2[] uvValues = new FiguraVec2[]{FiguraVec2.of(0.0, 1.0), FiguraVec2.of(1.0, 1.0), FiguraVec2.of(1.0, 0.0), FiguraVec2.of(0.0, 0.0)};

    public static FiguraModelPart read(Avatar owner, class_2487 partCompound, List<FiguraTextureSet> textureSets, boolean smoothNormals) {
        String name = partCompound.method_10558("name");
        PartCustomization customization = new PartCustomization();
        customization.needsMatrixRecalculation = true;
        FiguraVec3 rot = FiguraVec3.of();
        FiguraModelPartReader.readVec3(rot, partCompound, "rot");
        customization.setRot(rot);
        FiguraVec3 piv = FiguraVec3.of();
        FiguraModelPartReader.readVec3(piv, partCompound, "piv");
        customization.setPivot(piv);
        if (partCompound.method_10545("primary")) {
            try {
                customization.setPrimaryRenderType(RenderTypes.valueOf(partCompound.method_10558("primary")));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (partCompound.method_10545("secondary")) {
            try {
                customization.setSecondaryRenderType(RenderTypes.valueOf(partCompound.method_10558("secondary")));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (partCompound.method_10545("vsb")) {
            customization.visible = partCompound.method_10577("vsb");
        }
        ArrayList<Integer> facesByTexture = new ArrayList<Integer>(0);
        while (textureSets.size() > facesByTexture.size()) {
            facesByTexture.add(0);
        }
        HashMap<Integer, List<Vertex>> vertices = new HashMap<Integer, List<Vertex>>();
        if (FiguraModelPartReader.hasCubeData(partCompound)) {
            FiguraModelPartReader.readCuboid(facesByTexture, partCompound, vertices);
            customization.partType = PartCustomization.PartType.CUBE;
        } else if (FiguraModelPartReader.hasMeshData(partCompound)) {
            FiguraModelPartReader.readMesh(facesByTexture, partCompound, vertices);
            customization.partType = PartCustomization.PartType.MESH;
        }
        if (partCompound.method_10545("smo")) {
            smoothNormals = partCompound.method_10577("smo");
        }
        if (((Boolean)Configs.FORCE_SMOOTH_AVATAR.value).booleanValue() || smoothNormals && !vertices.isEmpty()) {
            FiguraModelPartReader.smoothfy(vertices);
        }
        ArrayList<FiguraModelPart> children = new ArrayList<FiguraModelPart>(0);
        if (partCompound.method_10545("chld")) {
            class_2499 listTag = partCompound.method_10554("chld", 10);
            for (class_2520 tag : listTag) {
                children.add(FiguraModelPartReader.read(owner, (class_2487)tag, textureSets, smoothNormals));
            }
        }
        FiguraModelPart result = new FiguraModelPart(owner, name, customization, vertices, children);
        for (FiguraModelPart child : children) {
            child.parent = result;
        }
        result.facesByTexture = facesByTexture;
        FiguraModelPartReader.storeTextures(result, textureSets);
        if (partCompound.method_10545("pt")) {
            try {
                result.parentType = ParentType.valueOf(partCompound.method_10558("pt"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (partCompound.method_10545("anim")) {
            class_2499 nbt = partCompound.method_10554("anim", 10);
            for (class_2520 tag : nbt) {
                Animation animation;
                class_2487 compound = (class_2487)tag;
                if (!compound.method_10545("id") || !compound.method_10545("data") || (animation = owner.animations.get(compound.method_10550("id"))) == null) continue;
                class_2487 animNbt = compound.method_10562("data");
                Iterator iterator = animNbt.method_10541().iterator();
                while (iterator.hasNext()) {
                    TransformType type;
                    String channelString;
                    switch (channelString = (String)iterator.next()) {
                        case "pos": {
                            TransformType transformType = TransformType.POSITION;
                            break;
                        }
                        case "rot": {
                            TransformType transformType = TransformType.ROTATION;
                            break;
                        }
                        case "grot": {
                            TransformType transformType = TransformType.GLOBAL_ROT;
                            break;
                        }
                        case "scl": {
                            TransformType transformType = TransformType.SCALE;
                            break;
                        }
                        default: {
                            TransformType transformType = type = null;
                        }
                    }
                    if (type == null) continue;
                    ArrayList<Keyframe> keyframes = new ArrayList<Keyframe>();
                    class_2499 keyframeList = animNbt.method_10554(channelString, 10);
                    for (class_2520 keyframeTag : keyframeList) {
                        Pair end;
                        Interpolation interpolation;
                        class_2487 keyframeNbt = (class_2487)keyframeTag;
                        float time = keyframeNbt.method_10583("time");
                        try {
                            interpolation = Interpolation.valueOf(keyframeNbt.method_10558("int").toUpperCase());
                        }
                        catch (Exception e) {
                            FiguraMod.LOGGER.error("", (Throwable)e);
                            continue;
                        }
                        Pair pre = FiguraModelPartReader.parseKeyframeData(keyframeNbt, "pre");
                        if (pre == null) {
                            pre = Pair.of((Object)FiguraVec3.of(), null);
                        }
                        if ((end = FiguraModelPartReader.parseKeyframeData(keyframeNbt, "end")) == null) {
                            end = pre;
                        }
                        FiguraVec3 bezierLeft = FiguraVec3.of();
                        FiguraVec3 bezierRight = FiguraVec3.of();
                        FiguraModelPartReader.readVec3(bezierLeft, keyframeNbt, "bl");
                        FiguraModelPartReader.readVec3(bezierRight, keyframeNbt, "br");
                        FiguraVec3 bezierLeftTime = FiguraVec3.of(-0.1, -0.1, -0.1);
                        FiguraVec3 bezierRightTime = FiguraVec3.of(0.1, 0.1, 0.1);
                        FiguraModelPartReader.readVec3(bezierLeftTime, keyframeNbt, "blt");
                        FiguraModelPartReader.readVec3(bezierRightTime, keyframeNbt, "brt");
                        bezierLeftTime.add(1.0, 1.0, 1.0);
                        bezierLeftTime = MathUtils.clamp(bezierLeftTime, 0.0, 1.0);
                        bezierRightTime = MathUtils.clamp(bezierRightTime, 0.0, 1.0);
                        keyframes.add(new Keyframe(owner, animation, time, interpolation, (Pair<FiguraVec3, String[]>)pre, (Pair<FiguraVec3, String[]>)end, bezierLeft, bezierRight, bezierLeftTime, bezierRightTime));
                    }
                    keyframes.sort(Keyframe::compareTo);
                    animation.addAnimation(result, new Animation.AnimationChannel(type, keyframes.toArray(new Keyframe[0])));
                }
            }
        }
        return result;
    }

    private static Pair<FiguraVec3, String[]> parseKeyframeData(class_2487 keyframeNbt, String tag) {
        if (!keyframeNbt.method_10545(tag)) {
            return null;
        }
        class_2499 floatList = keyframeNbt.method_10554(tag, 5);
        if (!floatList.isEmpty()) {
            FiguraVec3 ret = FiguraVec3.of();
            FiguraModelPartReader.readVec3(ret, floatList);
            return Pair.of((Object)ret, null);
        }
        class_2499 stringList = keyframeNbt.method_10554(tag, 8);
        return Pair.of(null, (Object)new String[]{stringList.method_10608(0), stringList.method_10608(1), stringList.method_10608(2)});
    }

    private static void storeTextures(FiguraModelPart modelPart, List<FiguraTextureSet> textureSets) {
        ArrayList<FiguraTextureSet> list = new ArrayList<FiguraTextureSet>(0);
        for (int j = 0; j < modelPart.facesByTexture.size(); ++j) {
            list.add(textureSets.get(j));
        }
        modelPart.textures = list;
        int w = -1;
        int h = -1;
        for (FiguraModelPart child : modelPart.children) {
            if (child.textureWidth == -1) {
                modelPart.textureWidth = -1;
                modelPart.textureHeight = -1;
                return;
            }
            if (child.textureWidth == w && child.textureHeight == h) continue;
            if (w != -1) {
                modelPart.textureWidth = -1;
                modelPart.textureHeight = -1;
                return;
            }
            w = child.textureWidth;
            h = child.textureHeight;
        }
        if (modelPart.customization.partType != PartCustomization.PartType.GROUP) {
            int i = -1;
            for (int j = 0; j < modelPart.facesByTexture.size(); ++j) {
                if (modelPart.facesByTexture.get(j) <= 0) continue;
                int realTexWidth = textureSets.get(j).getWidth();
                int realTexHeight = textureSets.get(j).getHeight();
                if (w != -1 && w != realTexWidth || h != -1 && h != realTexHeight) {
                    modelPart.textureWidth = -1;
                    modelPart.textureHeight = -1;
                    return;
                }
                if (i != -1) {
                    modelPart.textureWidth = -1;
                    modelPart.textureHeight = -1;
                    return;
                }
                i = j;
                w = realTexWidth;
                h = realTexHeight;
            }
        }
        modelPart.textureWidth = w;
        modelPart.textureHeight = h;
    }

    private static void readVec3(FiguraVec3 target, class_2487 tag, String name) {
        if (tag.method_10545(name)) {
            FiguraModelPartReader.readVec3(target, (class_2499)tag.method_10580(name));
        }
    }

    private static void readVec3(FiguraVec3 target, class_2499 list) {
        switch (list.method_10601()) {
            case 5: {
                target.set(list.method_10604(0), (double)list.method_10604(1), (double)list.method_10604(2));
                break;
            }
            case 3: {
                target.set(list.method_10600(0), (double)list.method_10600(1), (double)list.method_10600(2));
                break;
            }
            case 2: {
                target.set(list.method_10609(0), (double)list.method_10609(1), (double)list.method_10609(2));
                break;
            }
            case 1: {
                target.set(((class_2481)list.method_10534(0)).method_10698(), (double)((class_2481)list.method_10534(1)).method_10698(), (double)((class_2481)list.method_10534(2)).method_10698());
            }
        }
    }

    private static void readVec4(FiguraVec4 target, class_2487 tag, String name) {
        if (tag.method_10545(name)) {
            class_2499 list = (class_2499)tag.method_10580(name);
            switch (list.method_10601()) {
                case 5: {
                    target.set(list.method_10604(0), (double)list.method_10604(1), (double)list.method_10604(2), (double)list.method_10604(3));
                    break;
                }
                case 3: {
                    target.set(list.method_10600(0), (double)list.method_10600(1), (double)list.method_10600(2), (double)list.method_10600(3));
                    break;
                }
                case 2: {
                    target.set(list.method_10609(0), (double)list.method_10609(1), (double)list.method_10609(2), (double)list.method_10609(3));
                    break;
                }
                case 1: {
                    target.set(((class_2481)list.method_10534(0)).method_10698(), (double)((class_2481)list.method_10534(1)).method_10698(), (double)((class_2481)list.method_10534(2)).method_10698(), (double)((class_2481)list.method_10534(3)).method_10698());
                }
            }
        } else {
            target.set(0.0, 0.0, 0.0, 0.0);
        }
    }

    private static boolean hasCubeData(class_2487 partCompound) {
        if (partCompound.method_10573("cube_data", 10)) {
            return !partCompound.method_10562("cube_data").method_33133();
        }
        return false;
    }

    private static boolean hasMeshData(class_2487 partCompound) {
        if (partCompound.method_10573("mesh_data", 10)) {
            return !partCompound.method_10562("mesh_data").method_33133();
        }
        return false;
    }

    private static void readCuboid(List<Integer> facesByTexture, class_2487 data, Map<Integer, List<Vertex>> vertices) {
        FiguraVec3 from = FiguraVec3.of();
        FiguraModelPartReader.readVec3(from, data, "f");
        FiguraVec3 to = FiguraVec3.of();
        FiguraModelPartReader.readVec3(to, data, "t");
        double inflate = 0.0;
        if (data.method_10545("inf")) {
            inflate = data.method_10583("inf");
        }
        from.add(-inflate, -inflate, -inflate);
        to.add(inflate, inflate, inflate);
        FiguraVec3 ftDiff = to.copy();
        ftDiff.subtract(from);
        for (String direction : faceData.keySet()) {
            FiguraModelPartReader.readFace(data.method_10562("cube_data"), facesByTexture, direction, vertices, from, ftDiff);
        }
    }

    private static void readFace(class_2487 faces, List<Integer> facesByTexture, String direction, Map<Integer, List<Vertex>> vertices, FiguraVec3 from, FiguraVec3 ftDiff) {
        if (faces.method_10545(direction)) {
            class_2487 face = faces.method_10562(direction);
            short texId = face.method_10568("tex");
            facesByTexture.set(texId, facesByTexture.get(texId) + 1);
            FiguraVec3 normal = faceData.get(direction)[4];
            int rotation = (int)(face.method_10583("rot") / 90.0f);
            FiguraVec4 uv = FiguraVec4.of();
            FiguraModelPartReader.readVec4(uv, face, "uv");
            for (int i = 0; i < 4; ++i) {
                FiguraVec3 tempPos = ftDiff.copy();
                tempPos.multiply(faceData.get(direction)[i]);
                tempPos.add(from);
                FiguraVec2 normalizedUv = uvValues[(i + rotation) % 4];
                List list = vertices.getOrDefault(texId, new ArrayList());
                list.add(new Vertex((float)tempPos.x, (float)tempPos.y, (float)tempPos.z, (float)class_3532.method_16436((double)normalizedUv.x, (double)uv.x, (double)uv.z), (float)class_3532.method_16436((double)normalizedUv.y, (double)uv.y, (double)uv.w), (float)normal.x, (float)normal.y, (float)normal.z));
                vertices.put(Integer.valueOf(texId), list);
            }
        }
    }

    private static void readMesh(List<Integer> facesByTexture, class_2487 data, Map<Integer, List<Vertex>> vertices) {
        class_2487 meshData = data.method_10562("mesh_data");
        class_2499 verts = meshData.method_10554("vtx", 5);
        class_2499 uvs = meshData.method_10554("uvs", 5);
        class_2499 tex = meshData.method_10554("tex", 2);
        int bestType = 0;
        if (verts.size() > 765) {
            bestType = 1;
        }
        if (verts.size() > 98301) {
            bestType = 2;
        }
        class_2499 fac = switch (bestType) {
            case 0 -> meshData.method_10554("fac", 1);
            case 1 -> meshData.method_10554("fac", 2);
            default -> meshData.method_10554("fac", 3);
        };
        int vi = 0;
        int uvi = 0;
        float[] posArr = new float[12];
        float[] uvArr = new float[8];
        for (int ti = 0; ti < tex.size(); ++ti) {
            short packed = tex.method_10609(ti);
            int texId = packed >> 4;
            int numVerts = packed & 0xF;
            facesByTexture.set(texId, facesByTexture.get(texId) + 1);
            for (int j = 0; j < numVerts; ++j) {
                int vid = switch (bestType) {
                    case 0 -> ((class_2481)fac.method_10534(vi + j)).method_10698() & 0xFF;
                    case 1 -> fac.method_10609(vi + j) & 0xFFFF;
                    default -> fac.method_10600(vi + j);
                };
                posArr[3 * j] = verts.method_10604(3 * vid);
                posArr[3 * j + 1] = verts.method_10604(3 * vid + 1);
                posArr[3 * j + 2] = verts.method_10604(3 * vid + 2);
                uvArr[2 * j] = uvs.method_10604(uvi + 2 * j);
                uvArr[2 * j + 1] = uvs.method_10604(uvi + 2 * j + 1);
            }
            FiguraVec3 p1 = FiguraVec3.of(posArr[0], posArr[1], posArr[2]);
            FiguraVec3 p2 = FiguraVec3.of(posArr[3], posArr[4], posArr[5]);
            FiguraVec3 p3 = FiguraVec3.of(posArr[6], posArr[7], posArr[8]);
            p3.subtract(p2);
            p1.subtract(p2);
            p3.cross(p1);
            p3.normalize();
            for (int j = 0; j < numVerts; ++j) {
                List list = vertices.getOrDefault(texId, new ArrayList());
                list.add(new Vertex(posArr[3 * j], posArr[3 * j + 1], posArr[3 * j + 2], uvArr[2 * j], uvArr[2 * j + 1], (float)p3.x, (float)p3.y, (float)p3.z));
                vertices.put(texId, list);
            }
            if (numVerts == 3) {
                List list = vertices.getOrDefault(texId, new ArrayList());
                list.add(new Vertex(posArr[6], posArr[7], posArr[8], uvArr[4], uvArr[5], (float)p3.x, (float)p3.y, (float)p3.z));
                vertices.put(texId, list);
            }
            vi += numVerts;
            uvi += 2 * numVerts;
        }
    }

    private static void smoothfy(Map<Integer, List<Vertex>> verticesByTextuers) {
        HashMap<String, List> verticesByPos = new HashMap<String, List>();
        for (List<Vertex> vertices : verticesByTextuers.values()) {
            for (Vertex vertex : vertices) {
                String id = String.valueOf(vertex.getPos());
                List list = verticesByPos.computeIfAbsent(id, str -> new ArrayList(4));
                list.add(vertex);
            }
        }
        for (List<Vertex> vertices : verticesByPos.values()) {
            FiguraVec3 result = FiguraVec3.of();
            for (Vertex vertex : vertices) {
                result.add(vertex.getNormal());
            }
            result.normalize();
            for (Vertex vertex : vertices) {
                vertex.setNormal(result);
            }
        }
    }
}

