/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.math.vector;

import fabric.org.figuramc.figura.lua.LuaNotNil;
import fabric.org.figuramc.figura.lua.LuaWhitelist;
import fabric.org.figuramc.figura.lua.docs.LuaFieldDoc;
import fabric.org.figuramc.figura.lua.docs.LuaMetamethodDoc;
import fabric.org.figuramc.figura.lua.docs.LuaMethodDoc;
import fabric.org.figuramc.figura.lua.docs.LuaMethodOverload;
import fabric.org.figuramc.figura.lua.docs.LuaTypeDoc;
import fabric.org.figuramc.figura.math.matrix.FiguraMat3;
import fabric.org.figuramc.figura.math.vector.FiguraVec4;
import fabric.org.figuramc.figura.math.vector.FiguraVector;
import fabric.org.figuramc.figura.utils.LuaUtils;
import fabric.org.figuramc.figura.utils.MathUtils;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import org.joml.Vector3f;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaValue;

@LuaWhitelist
@LuaTypeDoc(name="Vector3", value="vector3")
public class FiguraVec3
extends FiguraVector<FiguraVec3, FiguraMat3> {
    @LuaWhitelist
    @LuaFieldDoc(value="vector_n.x")
    public double x;
    @LuaWhitelist
    @LuaFieldDoc(value="vector_n.y")
    public double y;
    @LuaWhitelist
    @LuaFieldDoc(value="vector_n.z")
    public double z;

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(returnType=FiguraVec3.class)}, value="vector_n.reset")
    public FiguraVec3 reset() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
        return this;
    }

    public static FiguraVec3 of() {
        return new FiguraVec3();
    }

    public static FiguraVec3 of(double x, double y, double z) {
        return FiguraVec3.of().set(x, y, z);
    }

    @Override
    public FiguraVec3 set(FiguraVec3 other) {
        return this.set(other.x, other.y, other.z);
    }

    public FiguraVec3 set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"vec"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, value="vector_n.set")
    public FiguraVec3 set(Object x, double y, double z) {
        return this.set(LuaUtils.parseVec3("set", x, y, z));
    }

    @Override
    public FiguraVec3 add(FiguraVec3 other) {
        return this.add(other.x, other.y, other.z);
    }

    public FiguraVec3 add(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"vec"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, value="vector_n.add")
    public FiguraVec3 add(Object x, double y, double z) {
        return this.add(LuaUtils.parseVec3("add", x, y, z));
    }

    @Override
    public FiguraVec3 subtract(FiguraVec3 other) {
        return this.subtract(other.x, other.y, other.z);
    }

    public FiguraVec3 subtract(double x, double y, double z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"vec"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, value="vector_n.sub")
    public FiguraVec3 sub(Object x, double y, double z) {
        return this.subtract(LuaUtils.parseVec3("sub", x, y, z));
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Double.class}, argumentNames={"factor"}, returnType=FiguraVec3.class)}, value="vector_n.offset")
    public FiguraVec3 offset(double factor) {
        this.x += factor;
        this.y += factor;
        this.z += factor;
        return this;
    }

    @Override
    public FiguraVec3 multiply(FiguraVec3 other) {
        return this.multiply(other.x, other.y, other.z);
    }

    public FiguraVec3 multiply(double x, double y, double z) {
        this.x *= x;
        this.y *= y;
        this.z *= z;
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"vec"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, value="vector_n.mul")
    public FiguraVec3 mul(Object x, double y, double z) {
        return this.multiply(LuaUtils.parseVec3("mul", x, y, z));
    }

    @Override
    public FiguraVec3 divide(FiguraVec3 other) {
        return this.divide(other.x, other.y, other.z);
    }

    public FiguraVec3 divide(double x, double y, double z) {
        this.x /= x;
        this.y /= y;
        this.z /= z;
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"vec"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, value="vector_n.div")
    public FiguraVec3 div(Object x, double y, double z) {
        return this.divide(LuaUtils.parseVec3("div", x, y, z));
    }

    @Override
    public FiguraVec3 reduce(FiguraVec3 other) {
        return this.reduce(other.x, other.y, other.z);
    }

    public FiguraVec3 reduce(double x, double y, double z) {
        this.x = (this.x % x + x) % x;
        this.y = (this.y % y + y) % y;
        this.z = (this.z % z + z) % z;
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"vec"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, value="vector_n.reduce")
    public FiguraVec3 reduce(Object x, double y, double z) {
        return this.reduce(LuaUtils.parseVec3("reduce", x, y, z));
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Double.class}, argumentNames={"factor"}, returnType=FiguraVec3.class)}, value="vector_n.scale")
    public FiguraVec3 scale(double factor) {
        this.x *= factor;
        this.y *= factor;
        this.z *= factor;
        return this;
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(value="vector_n.unpack")
    public double[] unpack() {
        return new double[]{this.x, this.y, this.z};
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraMat3.class}, argumentNames={"mat"}, returnType=FiguraVec3.class)}, value="vector_n.transform")
    public FiguraVec3 transform(@LuaNotNil FiguraMat3 mat) {
        return this.set(mat.v11 * this.x + mat.v12 * this.y + mat.v13 * this.z, mat.v21 * this.x + mat.v22 * this.y + mat.v23 * this.z, mat.v31 * this.x + mat.v32 * this.y + mat.v33 * this.z);
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(value="vector_n.length_squared")
    public double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(returnType=FiguraVec3.class)}, value="vector_n.copy")
    public FiguraVec3 copy() {
        return FiguraVec3.of(this.x, this.y, this.z);
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"vec"})}, value="vector_n.dot")
    public double dot(@LuaNotNil FiguraVec3 other) {
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(returnType=FiguraVec3.class)}, value="vector_n.normalize")
    public FiguraVec3 normalize() {
        return (FiguraVec3)super.normalize();
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(returnType=FiguraVec3.class)}, value="vector_n.normalized")
    public FiguraVec3 normalized() {
        return (FiguraVec3)super.normalized();
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Double.class, Double.class}, argumentNames={"minLength", "maxLength"}, returnType=FiguraVec3.class)}, value="vector_n.clamp_length")
    public FiguraVec3 clampLength(Double min, Double max) {
        return (FiguraVec3)super.clampLength(min, max);
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Double.class, Double.class}, argumentNames={"minLength", "maxLength"}, returnType=FiguraVec3.class)}, value="vector_n.clamped")
    public FiguraVec3 clamped(Double min, Double max) {
        return (FiguraVec3)super.clamped(min, max);
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(value="vector_n.length")
    public double length() {
        return super.length();
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(returnType=FiguraVec3.class)}, value="vector_n.to_rad")
    public FiguraVec3 toRad() {
        return (FiguraVec3)super.toRad();
    }

    @Override
    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(returnType=FiguraVec3.class)}, value="vector_n.to_deg")
    public FiguraVec3 toDeg() {
        return (FiguraVec3)super.toDeg();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="vector_n.floor")
    public FiguraVec3 floor() {
        return FiguraVec3.of(Math.floor(this.x), Math.floor(this.y), Math.floor(this.z));
    }

    @LuaWhitelist
    @LuaMethodDoc(value="vector_n.ceil")
    public FiguraVec3 ceil() {
        return FiguraVec3.of(Math.ceil(this.x), Math.ceil(this.y), Math.ceil(this.z));
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={LuaFunction.class}, argumentNames={"func"})}, value="vector_n.apply_func")
    public FiguraVec3 applyFunc(@LuaNotNil LuaFunction function) {
        this.x = function.call((LuaValue)LuaValue.valueOf((double)this.x), (LuaValue)LuaValue.valueOf((int)1)).todouble();
        this.y = function.call((LuaValue)LuaValue.valueOf((double)this.y), (LuaValue)LuaValue.valueOf((int)2)).todouble();
        this.z = function.call((LuaValue)LuaValue.valueOf((double)this.z), (LuaValue)LuaValue.valueOf((int)3)).todouble();
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Double.class}, argumentNames={"value"})}, value="vector_n.augmented")
    public FiguraVec4 augmented(Double d) {
        return FiguraVec4.of(this.x, this.y, this.z, d == null ? 1.0 : d);
    }

    @Override
    public int size() {
        return 3;
    }

    @Override
    public double x() {
        return this.x;
    }

    @Override
    public double y() {
        return this.y;
    }

    @Override
    public double z() {
        return this.z;
    }

    @Override
    public double index(int i) {
        return switch (i) {
            case 0 -> this.x;
            case 1 -> this.y;
            case 2 -> this.z;
            default -> throw new IndexOutOfBoundsException(i);
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (!(other instanceof FiguraVec3)) return false;
        FiguraVec3 vec = (FiguraVec3)other;
        if (this.x != vec.x) return false;
        if (this.y != vec.y) return false;
        if (this.z != vec.z) return false;
        return true;
    }

    @Override
    @LuaWhitelist
    public String toString() {
        return FiguraVec3.getString(this.x, this.y, this.z);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"other"})}, value="vector3.cross")
    public FiguraVec3 cross(@LuaNotNil FiguraVec3 other) {
        double nx = this.y * other.z - this.z * other.y;
        double ny = this.z * other.x - this.x * other.z;
        double nz = this.x * other.y - this.y * other.x;
        this.set(nx, ny, nz);
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"other"})}, value="vector3.crossed")
    public FiguraVec3 crossed(@LuaNotNil FiguraVec3 other) {
        return this.copy().cross(other);
    }

    public class_2338 asBlockPos() {
        return new class_2338((int)Math.floor(this.x), (int)Math.floor(this.y), (int)Math.floor(this.z));
    }

    public static FiguraVec3 fromBlockPos(class_2338 pos) {
        return FiguraVec3.of(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public class_243 asVec3() {
        return new class_243(this.x, this.y, this.z);
    }

    public static FiguraVec3 fromVec3(class_243 vec) {
        return FiguraVec3.of(vec.field_1352, vec.field_1351, vec.field_1350);
    }

    public Vector3f asVec3f() {
        return new Vector3f((float)this.x, (float)this.y, (float)this.z);
    }

    public static FiguraVec3 fromVec3f(Vector3f vec) {
        return FiguraVec3.of(vec.x(), vec.y(), vec.z());
    }

    public boolean notNaN() {
        return !Double.isNaN(this.x) && !Double.isNaN(this.y) && !Double.isNaN(this.z);
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec3.class, FiguraVec3.class, FiguraVec3.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec3.class, FiguraVec3.class, Double.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec3.class, Double.class, FiguraVec3.class})})
    public static FiguraVec3 __add(@LuaNotNil Object a, @LuaNotNil Object b) {
        if (a instanceof FiguraVec3) {
            FiguraVec3 vec = (FiguraVec3)a;
            if (b instanceof FiguraVec3) {
                FiguraVec3 vec2 = (FiguraVec3)b;
                return vec.plus(vec2);
            }
            if (b instanceof Number) {
                Number d = (Number)b;
                return (FiguraVec3)vec.offseted(d.doubleValue());
            }
        } else if (a instanceof Number) {
            Number d = (Number)a;
            if (b instanceof FiguraVec3) {
                FiguraVec3 vec = (FiguraVec3)b;
                return (FiguraVec3)vec.offseted(d.doubleValue());
            }
        }
        throw new LuaError("Invalid types to __add: " + a.getClass().getSimpleName() + ", " + b.getClass().getSimpleName());
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec3.class, FiguraVec3.class, FiguraVec3.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec3.class, FiguraVec3.class, Double.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec3.class, Double.class, FiguraVec3.class})})
    public static FiguraVec3 __sub(@LuaNotNil Object a, @LuaNotNil Object b) {
        if (a instanceof FiguraVec3) {
            FiguraVec3 vec = (FiguraVec3)a;
            if (b instanceof FiguraVec3) {
                FiguraVec3 vec2 = (FiguraVec3)b;
                return vec.minus(vec2);
            }
            if (b instanceof Number) {
                Number d = (Number)b;
                return (FiguraVec3)vec.offseted(-d.doubleValue());
            }
        } else if (a instanceof Number) {
            Number d = (Number)a;
            if (b instanceof FiguraVec3) {
                FiguraVec3 vec = (FiguraVec3)b;
                return ((FiguraVec3)vec.scaled(-1.0)).offset(d.doubleValue());
            }
        }
        throw new LuaError("Invalid types to __sub: " + a.getClass().getSimpleName() + ", " + b.getClass().getSimpleName());
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec3.class, FiguraVec3.class, FiguraVec3.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec3.class, FiguraVec3.class, Double.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec3.class, FiguraVec3.class, FiguraMat3.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec3.class, Double.class, FiguraVec3.class})})
    public static FiguraVec3 __mul(@LuaNotNil Object a, @LuaNotNil Object b) {
        if (a instanceof FiguraVec3) {
            FiguraVec3 vec = (FiguraVec3)a;
            if (b instanceof FiguraVec3) {
                FiguraVec3 vec2 = (FiguraVec3)b;
                return vec.times(vec2);
            }
            if (b instanceof Number) {
                Number d = (Number)b;
                return (FiguraVec3)vec.scaled(d.doubleValue());
            }
            if (b instanceof FiguraMat3) {
                FiguraMat3 mat = (FiguraMat3)b;
                return vec.transform(mat);
            }
        } else if (a instanceof Number) {
            Number d = (Number)a;
            if (b instanceof FiguraVec3) {
                FiguraVec3 vec = (FiguraVec3)b;
                return (FiguraVec3)vec.scaled(d.doubleValue());
            }
        }
        throw new LuaError("Invalid types to __mul: " + a.getClass().getSimpleName() + ", " + b.getClass().getSimpleName());
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec3.class, FiguraVec3.class, FiguraVec3.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec3.class, FiguraVec3.class, Double.class})})
    public FiguraVec3 __div(@LuaNotNil Object rhs) {
        if (rhs instanceof Number) {
            Number n = (Number)rhs;
            double d = n.doubleValue();
            if (d == 0.0) {
                throw new LuaError("Attempt to divide vector by 0");
            }
            return (FiguraVec3)this.scaled(1.0 / d);
        }
        if (rhs instanceof FiguraVec3) {
            FiguraVec3 vec = (FiguraVec3)rhs;
            return this.dividedBy(vec);
        }
        throw new LuaError("Invalid types to __div: " + this.getClass().getSimpleName() + ", " + rhs.getClass().getSimpleName());
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec3.class, FiguraVec3.class, FiguraVec3.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec3.class, FiguraVec3.class, Double.class})})
    public FiguraVec3 __mod(@LuaNotNil Object rhs) {
        if (rhs instanceof Number) {
            Number n = (Number)rhs;
            double d = n.doubleValue();
            if (d == 0.0) {
                throw new LuaError("Attempt to reduce vector by 0");
            }
            FiguraVec3 modulus = FiguraVec3.of(d, d, d);
            return this.mod(modulus);
        }
        if (rhs instanceof FiguraVec3) {
            FiguraVec3 vec = (FiguraVec3)rhs;
            return this.mod(vec);
        }
        throw new LuaError("Invalid types to __mod: " + this.getClass().getSimpleName() + ", " + rhs.getClass().getSimpleName());
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={Boolean.class, FiguraVec3.class, FiguraVec3.class})})
    public boolean __eq(FiguraVec3 other) {
        return this.equals(other);
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVec3.class, FiguraVec3.class})})
    public FiguraVec3 __unm() {
        return (FiguraVec3)this.scaled(-1.0);
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={Integer.class, FiguraVec3.class})})
    public int __len() {
        return this.size();
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={Boolean.class, FiguraVec3.class, FiguraVec3.class})})
    public boolean __lt(@LuaNotNil FiguraVec3 r) {
        return this.x < r.x && this.y < r.y && this.z < r.z;
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={Boolean.class, FiguraVec3.class, FiguraVec3.class})})
    public boolean __le(@LuaNotNil FiguraVec3 r) {
        return this.x <= r.x && this.y <= r.y && this.z <= r.z;
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={String.class, FiguraVec3.class})})
    public String __tostring() {
        return this.toString();
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={Double.class, FiguraVec3.class, Integer.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={Double.class, FiguraVec3.class, String.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={FiguraVector.class, FiguraVec3.class, String.class}, comment="vector_n.comments.swizzle")})
    public Object __index(Object arg) {
        if (arg == null) {
            return null;
        }
        String str = arg.toString();
        int len = str.length();
        if (len == 1) {
            return switch (str.charAt(0)) {
                case '1', 'r', 'x' -> this.x;
                case '2', 'g', 'y' -> this.y;
                case '3', 'b', 'z' -> this.z;
                case '_' -> 0;
                default -> null;
            };
        }
        if (len > 4) {
            return null;
        }
        double[] vals = new double[len];
        boolean fail = false;
        for (int i = 0; i < len; ++i) {
            vals[i] = switch (str.charAt(i)) {
                case '1', 'r', 'x' -> this.x;
                case '2', 'g', 'y' -> this.y;
                case '3', 'b', 'z' -> this.z;
                case '_' -> 0.0;
                default -> {
                    fail = true;
                    yield 0.0;
                }
            };
        }
        return fail ? null : MathUtils.sizedVector(vals);
    }

    @LuaWhitelist
    @LuaMetamethodDoc(overloads={@LuaMetamethodDoc.LuaMetamethodOverload(types={void.class, FiguraVec3.class, Integer.class, Double.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={void.class, FiguraVec3.class, String.class, Double.class}), @LuaMetamethodDoc.LuaMetamethodOverload(types={void.class, FiguraVec3.class, String.class, FiguraVector.class})})
    public void __newindex(@LuaNotNil String key, Object value) {
        FiguraVector vecVal;
        int len = key.length();
        if (len == 1) {
            if (value instanceof Number) {
                Number n = (Number)value;
                double d = n.doubleValue();
                switch (key) {
                    case "1": 
                    case "x": 
                    case "r": {
                        this.x = d;
                        break;
                    }
                    case "2": 
                    case "y": 
                    case "g": {
                        this.y = d;
                        break;
                    }
                    case "3": 
                    case "z": 
                    case "b": {
                        this.z = d;
                        break;
                    }
                    case "_": {
                        break;
                    }
                    default: {
                        throw new LuaError("Invalid key to vector __newindex: " + key);
                    }
                }
                return;
            }
            throw new LuaError("Invalid call to __newindex - value assigned to key " + key + " must be number.");
        }
        if (value instanceof FiguraVector && len == (vecVal = (FiguraVector)value).size()) {
            double[] vals = new double[]{vecVal.x(), vecVal.y(), vecVal.z(), vecVal.w()};
            block24: for (int i = 0; i < len; ++i) {
                switch (key.charAt(i)) {
                    case '1': 
                    case 'r': 
                    case 'x': {
                        this.x = vals[i];
                        continue block24;
                    }
                    case '2': 
                    case 'g': 
                    case 'y': {
                        this.y = vals[i];
                        continue block24;
                    }
                    case '3': 
                    case 'b': 
                    case 'z': {
                        this.z = vals[i];
                        continue block24;
                    }
                    case '_': {
                        continue block24;
                    }
                    default: {
                        throw new LuaError("Invalid key to __newindex: invalid swizzle character: " + key.charAt(i));
                    }
                }
            }
            return;
        }
        throw new LuaError("Invalid call to __newindex - vector swizzles must be the same size.");
    }
}

