/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.lua.docs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import fabric.org.figuramc.figura.FiguraMod;
import fabric.org.figuramc.figura.animation.Animation;
import fabric.org.figuramc.figura.lua.docs.FiguraDoc;
import fabric.org.figuramc.figura.mixin.input.KeyMappingAccessor;
import fabric.org.figuramc.figura.mixin.render.GameRendererAccessor;
import fabric.org.figuramc.figura.model.ParentType;
import fabric.org.figuramc.figura.model.rendering.EntityRenderMode;
import fabric.org.figuramc.figura.model.rendering.texture.FiguraTextureSet;
import fabric.org.figuramc.figura.model.rendering.texture.RenderTypes;
import fabric.org.figuramc.figura.utils.ColorUtils;
import fabric.org.figuramc.figura.utils.FiguraClientCommandSource;
import fabric.org.figuramc.figura.utils.FiguraText;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1664;
import net.minecraft.class_1839;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4050;
import net.minecraft.class_5250;
import net.minecraft.class_811;

public class FiguraListDocs {
    public static final LinkedHashSet<String> KEYBINDS = new LinkedHashSet();
    private static final LinkedHashMap<String, List<String>> PARENT_TYPES = new LinkedHashMap<String, List<String>>(){
        {
            for (ParentType value : ParentType.values()) {
                this.put(value.name(), Arrays.asList(value.aliases));
            }
        }
    };
    private static final LinkedHashSet<String> RENDER_TYPES = new LinkedHashSet<String>(){
        {
            for (RenderTypes value : RenderTypes.values()) {
                this.add(value.name());
            }
        }
    };
    private static final LinkedHashSet<String> TEXTURE_TYPES = new LinkedHashSet<String>(){
        {
            for (FiguraTextureSet.OverrideType value : FiguraTextureSet.OverrideType.values()) {
                this.add(value.name());
            }
        }
    };
    private static final LinkedHashSet<String> ENTITY_POSES = new LinkedHashSet<String>(){
        {
            for (class_4050 value : class_4050.values()) {
                this.add(value.name());
            }
        }
    };
    private static final LinkedHashSet<String> ITEM_DISPLAY_MODES = new LinkedHashSet<String>(){
        {
            for (class_811 value : class_811.values()) {
                this.add(value.name());
            }
        }
    };
    private static final LinkedHashSet<String> POST_EFFECTS = new LinkedHashSet<String>(){
        {
            for (class_2960 effect : GameRendererAccessor.getEffects()) {
                String[] split = effect.method_12832().split("/");
                String name = split[split.length - 1];
                this.add(name.split("\\.")[0]);
            }
        }
    };
    private static final LinkedHashSet<String> PLAY_STATES = new LinkedHashSet<String>(){
        {
            for (Animation.PlayState value : Animation.PlayState.values()) {
                this.add(value.name());
            }
        }
    };
    private static final LinkedHashSet<String> LOOP_MODES = new LinkedHashSet<String>(){
        {
            for (Animation.LoopMode value : Animation.LoopMode.values()) {
                this.add(value.name());
            }
        }
    };
    private static final LinkedHashMap<String, List<String>> COLORS = new LinkedHashMap<String, List<String>>(){
        {
            for (ColorUtils.Colors value : ColorUtils.Colors.values()) {
                this.put(value.name(), List.of(value.name()));
            }
        }
    };
    private static final LinkedHashSet<String> PLAYER_MODEL_PARTS = new LinkedHashSet<String>(){
        {
            for (class_1664 value : class_1664.values()) {
                String name = value.name();
                this.add(name.endsWith("_LEG") ? name.substring(0, name.length() - 4) : name);
            }
        }
    };
    private static final LinkedHashSet<String> USE_ACTIONS = new LinkedHashSet<String>(){
        {
            for (class_1839 value : class_1839.values()) {
                this.add(value.name());
            }
        }
    };
    private static final LinkedHashSet<String> RENDER_MODES = new LinkedHashSet<String>(){
        {
            for (EntityRenderMode value : EntityRenderMode.values()) {
                this.add(value.name());
            }
        }
    };

    public static LiteralArgumentBuilder<FiguraClientCommandSource> getCommand() {
        LiteralArgumentBuilder root = LiteralArgumentBuilder.literal((String)"enums");
        root.executes(context -> {
            FiguraMod.sendChatMessage((class_2561)FiguraDoc.HEADER.method_27661().method_27693("\n\n").method_10852((class_2561)class_2561.method_43470((String)"\u2022 ").method_10852((class_2561)FiguraText.of("docs.text.type")).method_27693(":").method_27696(ColorUtils.Colors.PURPLE.style)).method_27693("\n\t").method_10852((class_2561)class_2561.method_43470((String)"\u2022 ").method_10852((class_2561)class_2561.method_43470((String)"enumerators")).method_27696(ColorUtils.Colors.BLUE.style)).method_27693("\n\n").method_10852((class_2561)class_2561.method_43470((String)"\u2022 ").method_10852((class_2561)FiguraText.of("docs.text.description")).method_27693(":").method_27696(ColorUtils.Colors.PURPLE.style)).method_27693("\n\t").method_10852((class_2561)class_2561.method_43470((String)"\u2022 ").method_10852((class_2561)FiguraText.of("docs.enum")).method_27696(ColorUtils.Colors.BLUE.style)));
            return 1;
        });
        for (ListDoc value : ListDoc.values()) {
            root.then(value.generateCommand());
        }
        return root;
    }

    public static JsonElement toJson(boolean translate) {
        JsonArray array = new JsonArray();
        for (ListDoc value : ListDoc.values()) {
            array.add(value.generateJson(translate));
        }
        return array;
    }

    private static enum ListDoc {
        KEYBINDS(() -> KEYBINDS, "Keybinds", "keybinds", 2),
        PARENT_TYPES(() -> PARENT_TYPES, "ParentTypes", "parent_types", 1),
        RENDER_TYPES(() -> RENDER_TYPES, "RenderTypes", "render_types", 1),
        TEXTURE_TYPES(() -> TEXTURE_TYPES, "TextureTypes", "texture_types", 1),
        KEY_IDS(() -> new LinkedHashSet<Object>(){
            {
                this.addAll(KeyMappingAccessor.getAll().keySet());
            }
        }, "KeyIDs", "key_ids", 2),
        ENTITY_POSES(() -> ENTITY_POSES, "EntityPoses", "entity_poses", 2),
        ITEM_RENDER_TYPES(() -> ITEM_DISPLAY_MODES, "ItemDisplayModes", "item_display_modes", 1),
        POST_EFFECTS(() -> POST_EFFECTS, "PostEffects", "post_effects", 2),
        PLAY_STATES(() -> PLAY_STATES, "PlayStates", "play_states", 1),
        LOOP_MODES(() -> LOOP_MODES, "LoopModes", "loop_modes", 1),
        COLORS(() -> COLORS, "Colors", "colors", 1),
        PLAYER_MODEL_PARTS(() -> PLAYER_MODEL_PARTS, "PlayerModelParts", "player_model_parts", 1),
        USE_ACTIONS(() -> USE_ACTIONS, "UseActions", "use_actions", 1),
        RENDER_MODES(() -> RENDER_MODES, "RenderModes", "render_modes", 1);

        private final Supplier<Object> supplier;
        private final String name;
        private final String id;
        private final int split;

        private ListDoc(Supplier<Object> supplier, String name, String id, int split) {
            this.supplier = supplier;
            this.name = name;
            this.id = id;
            this.split = split;
        }

        private Collection<?> get() {
            Object obj = this.supplier.get();
            if (obj instanceof LinkedHashSet) {
                LinkedHashSet set = (LinkedHashSet)obj;
                return set;
            }
            if (obj instanceof Map) {
                Map map = (Map)obj;
                return map.entrySet();
            }
            throw new UnsupportedOperationException("Invalid object " + String.valueOf(obj));
        }

        private JsonElement generateJson(boolean translate) {
            JsonObject object = new JsonObject();
            object.addProperty("name", this.name);
            object.addProperty("description", (String)(translate ? class_2477.method_10517().method_48307(FiguraText.of("docs.enum." + this.id).getString()) : "figura.docs.enum." + this.id));
            Collection<?> coll = this.get();
            if (coll.size() == 0) {
                return object;
            }
            JsonArray entries = new JsonArray();
            for (Object o : coll) {
                if (o instanceof Map.Entry) {
                    Map.Entry e = (Map.Entry)o;
                    entries.add(e.getKey().toString());
                    for (String s : (List)e.getValue()) {
                        entries.add(s);
                    }
                    continue;
                }
                entries.add(o.toString());
            }
            object.add("entries", (JsonElement)entries);
            return object;
        }

        private LiteralArgumentBuilder<FiguraClientCommandSource> generateCommand() {
            LiteralArgumentBuilder command = LiteralArgumentBuilder.literal((String)this.id);
            command.executes(context -> {
                Collection<?> coll = this.get();
                if (coll.size() == 0) {
                    FiguraMod.sendChatMessage((class_2561)FiguraText.of("docs.enum.empty"));
                    return 0;
                }
                class_5250 text = FiguraDoc.HEADER.method_27661().method_27693("\n\n").method_10852((class_2561)class_2561.method_43470((String)"\u2022 ").method_10852((class_2561)FiguraText.of("docs.text.description")).method_27693(":").method_27696(ColorUtils.Colors.PURPLE.style)).method_27693("\n\t").method_10852((class_2561)class_2561.method_43470((String)"\u2022 ").method_10852((class_2561)FiguraText.of("docs.enum." + this.id)).method_27696(ColorUtils.Colors.BLUE.style)).method_27693("\n\n").method_10852((class_2561)class_2561.method_43470((String)"\u2022 ").method_10852((class_2561)FiguraText.of("docs.text.entries")).method_27693(":").method_27696(ColorUtils.Colors.PURPLE.style));
                int i = 0;
                for (Object o : coll) {
                    class_5250 component;
                    if (o instanceof Map.Entry) {
                        Map.Entry e = (Map.Entry)o;
                        component = class_2561.method_43470((String)e.getKey().toString()).method_27692(class_124.field_1068);
                        for (String s : (List)e.getValue()) {
                            component.method_10852((class_2561)class_2561.method_43470((String)" | ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)s).method_27692(class_124.field_1080));
                        }
                    } else {
                        component = class_2561.method_43470((String)o.toString()).method_27692(class_124.field_1068);
                    }
                    text.method_27693(i % this.split == 0 ? "\n\t" : "\t");
                    text.method_10852((class_2561)class_2561.method_43470((String)"\u2022 ").method_27692(class_124.field_1054)).method_10852((class_2561)component);
                    ++i;
                }
                FiguraMod.sendChatMessage((class_2561)text);
                return 1;
            });
            Collection<?> coll = this.get();
            for (Object o : coll) {
                String string;
                if (o instanceof Map.Entry) {
                    Map.Entry e = (Map.Entry)o;
                    string = e.getKey().toString();
                } else {
                    string = o.toString();
                }
                String text = string;
                LiteralArgumentBuilder entry = LiteralArgumentBuilder.literal((String)text);
                entry.executes(context -> {
                    FiguraMod.sendChatMessage((class_2561)class_2561.method_43470((String)text).method_27696(ColorUtils.Colors.AWESOME_BLUE.style));
                    return 1;
                });
                if (o instanceof Map.Entry) {
                    Map.Entry e = (Map.Entry)o;
                    for (String s : (List)e.getValue()) {
                        LiteralArgumentBuilder child = LiteralArgumentBuilder.literal((String)s);
                        child.executes(context -> {
                            FiguraMod.sendChatMessage((class_2561)class_2561.method_43470((String)s).method_27696(ColorUtils.Colors.AWESOME_BLUE.style));
                            return 1;
                        });
                        entry.then((ArgumentBuilder)child);
                    }
                }
                command.then((ArgumentBuilder)entry);
            }
            return command;
        }
    }
}

