/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.lua.api.world;

import com.mojang.brigadier.StringReader;
import com.mojang.datafixers.util.Pair;
import fabric.org.figuramc.figura.avatar.Avatar;
import fabric.org.figuramc.figura.avatar.AvatarManager;
import fabric.org.figuramc.figura.lua.LuaNotNil;
import fabric.org.figuramc.figura.lua.LuaWhitelist;
import fabric.org.figuramc.figura.lua.ReadOnlyLuaTable;
import fabric.org.figuramc.figura.lua.api.entity.EntityAPI;
import fabric.org.figuramc.figura.lua.api.entity.PlayerAPI;
import fabric.org.figuramc.figura.lua.api.world.BiomeAPI;
import fabric.org.figuramc.figura.lua.api.world.BlockStateAPI;
import fabric.org.figuramc.figura.lua.api.world.ItemStackAPI;
import fabric.org.figuramc.figura.lua.docs.LuaMethodDoc;
import fabric.org.figuramc.figura.lua.docs.LuaMethodOverload;
import fabric.org.figuramc.figura.lua.docs.LuaTypeDoc;
import fabric.org.figuramc.figura.math.vector.FiguraVec3;
import fabric.org.figuramc.figura.utils.EntityUtils;
import fabric.org.figuramc.figura.utils.LuaUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2257;
import net.minecraft.class_2287;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_6335;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;

@LuaWhitelist
@LuaTypeDoc(name="WorldAPI", value="world")
public class WorldAPI {
    public static final WorldAPI INSTANCE = new WorldAPI();

    public static class_1937 getCurrentWorld() {
        return class_310.method_1551().field_1687;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"pos"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, value="world.get_biome")
    public static BiomeAPI getBiome(Object x, Double y, Double z) {
        FiguraVec3 pos = LuaUtils.parseVec3("getBiome", x, y, z);
        return new BiomeAPI((class_1959)WorldAPI.getCurrentWorld().method_23753(pos.asBlockPos()).comp_349(), pos.asBlockPos());
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"pos"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, value="world.get_block_state")
    public static BlockStateAPI getBlockState(Object x, Double y, Double z) {
        FiguraVec3 pos = LuaUtils.parseVec3("getBlockState", x, y, z);
        class_2338 blockPos = pos.asBlockPos();
        class_1937 world = WorldAPI.getCurrentWorld();
        if (!world.method_22340(blockPos)) {
            return new BlockStateAPI(class_2246.field_10124.method_9564(), blockPos);
        }
        return new BlockStateAPI(world.method_8320(blockPos), blockPos);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class, FiguraVec3.class}, argumentNames={"min", "max"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class, FiguraVec3.class}, argumentNames={"minX", "minY", "minZ", "max"}), @LuaMethodOverload(argumentTypes={FiguraVec3.class, Double.class, Double.class, Double.class}, argumentNames={"min", "maxX", "maxY", "maxZ"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class, Double.class, Double.class, Double.class}, argumentNames={"minX", "minY", "minZ", "maxX", "maxY", "maxZ"})}, value="world.get_blocks")
    public static List<BlockStateAPI> getBlocks(Object x, Object y, Double z, Double w, Double t, Double h) {
        Pair<FiguraVec3, FiguraVec3> pair = LuaUtils.parse2Vec3("getBlocks", x, y, z, w, t, h);
        ArrayList<BlockStateAPI> list = new ArrayList<BlockStateAPI>();
        class_2338 min = ((FiguraVec3)pair.getFirst()).asBlockPos();
        class_2338 max = ((FiguraVec3)pair.getSecond()).asBlockPos();
        max = new class_2338(Math.min(min.method_10263() + 8, max.method_10263()), Math.min(min.method_10264() + 8, max.method_10264()), Math.min(min.method_10260() + 8, max.method_10260()));
        class_1937 world = WorldAPI.getCurrentWorld();
        if (!world.method_22343(min, max)) {
            return list;
        }
        class_2338.method_20437((class_2338)min, (class_2338)max).forEach(blockPos -> list.add(new BlockStateAPI(world.method_8320(blockPos), (class_2338)blockPos)));
        return list;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"pos"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, value="world.get_redstone_power")
    public static int getRedstonePower(Object x, Double y, Double z) {
        FiguraVec3 pos = LuaUtils.parseVec3("getRedstonePower", x, y, z);
        class_2338 blockPos = pos.asBlockPos();
        if (WorldAPI.getCurrentWorld().method_8500(blockPos) == null) {
            return 0;
        }
        return WorldAPI.getCurrentWorld().method_49804(blockPos);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"pos"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, value="world.get_strong_redstone_power")
    public static int getStrongRedstonePower(Object x, Double y, Double z) {
        FiguraVec3 pos = LuaUtils.parseVec3("getStrongRedstonePower", x, y, z);
        class_2338 blockPos = pos.asBlockPos();
        if (WorldAPI.getCurrentWorld().method_8500(blockPos) == null) {
            return 0;
        }
        return WorldAPI.getCurrentWorld().method_49809(blockPos);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Double.class}, argumentNames={"delta"})}, value="world.get_time")
    public static double getTime(double delta) {
        return (double)WorldAPI.getCurrentWorld().method_8510() + delta;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Double.class}, argumentNames={"delta"})}, value="world.get_time_of_day")
    public static double getTimeOfDay(double delta) {
        return (double)WorldAPI.getCurrentWorld().method_8532() + delta;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload}, value="world.get_moon_phase")
    public static int getMoonPhase() {
        return WorldAPI.getCurrentWorld().method_30273();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload, @LuaMethodOverload(argumentTypes={Double.class}, argumentNames={"delta"})}, value="world.get_rain_gradient")
    public static double getRainGradient(Float delta) {
        if (delta == null) {
            delta = Float.valueOf(1.0f);
        }
        return WorldAPI.getCurrentWorld().method_8430(delta.floatValue());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="world.is_thundering")
    public static boolean isThundering() {
        return WorldAPI.getCurrentWorld().method_8546();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"pos"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, value="world.get_light_level")
    public static Integer getLightLevel(Object x, Double y, Double z) {
        FiguraVec3 pos = LuaUtils.parseVec3("getLightLevel", x, y, z);
        class_2338 blockPos = pos.asBlockPos();
        class_1937 world = WorldAPI.getCurrentWorld();
        if (world.method_8500(blockPos) == null) {
            return null;
        }
        world.method_8533();
        return world.method_22336().method_22363(blockPos, world.method_8594());
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"pos"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, value="world.get_sky_light_level")
    public static Integer getSkyLightLevel(Object x, Double y, Double z) {
        FiguraVec3 pos = LuaUtils.parseVec3("getSkyLightLevel", x, y, z);
        class_2338 blockPos = pos.asBlockPos();
        class_1937 world = WorldAPI.getCurrentWorld();
        if (world.method_8500(blockPos) == null) {
            return null;
        }
        return world.method_8314(class_1944.field_9284, blockPos);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"pos"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, value="world.get_block_light_level")
    public static Integer getBlockLightLevel(Object x, Double y, Double z) {
        FiguraVec3 pos = LuaUtils.parseVec3("getBlockLightLevel", x, y, z);
        class_2338 blockPos = pos.asBlockPos();
        class_1937 world = WorldAPI.getCurrentWorld();
        if (world.method_8500(blockPos) == null) {
            return null;
        }
        return world.method_8314(class_1944.field_9282, blockPos);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"pos"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, value="world.is_open_sky")
    public static Boolean isOpenSky(Object x, Double y, Double z) {
        FiguraVec3 pos = LuaUtils.parseVec3("isOpenSky", x, y, z);
        class_2338 blockPos = pos.asBlockPos();
        class_1937 world = WorldAPI.getCurrentWorld();
        if (world.method_8500(blockPos) == null) {
            return null;
        }
        return world.method_8311(blockPos);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="world.get_dimension")
    public static String getDimension() {
        class_1937 world = WorldAPI.getCurrentWorld();
        return world.method_27983().method_29177().toString();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="world.get_players")
    public static Map<String, EntityAPI<?>> getPlayers() {
        HashMap playerList = new HashMap();
        for (class_1657 player : WorldAPI.getCurrentWorld().method_18456()) {
            playerList.put(player.method_5477().getString(), PlayerAPI.wrap((class_1297)player));
        }
        return playerList;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"UUID"})}, value="world.get_entity")
    public static EntityAPI<?> getEntity(@LuaNotNil String uuid) {
        try {
            return EntityAPI.wrap(EntityUtils.getEntityByUUID(UUID.fromString(uuid)));
        }
        catch (Exception ignored) {
            throw new LuaError("Invalid UUID");
        }
    }

    public HashMap<String, Object> raycastBlock(boolean fluid, Object x, Object y, Double z, Object w, Double t, Double h) {
        Pair<FiguraVec3, FiguraVec3> pair = LuaUtils.parse2Vec3("raycastBlock", x, y, z, w, t, h);
        FiguraVec3 start = (FiguraVec3)pair.getFirst();
        FiguraVec3 end = (FiguraVec3)pair.getSecond();
        class_3965 result = WorldAPI.getCurrentWorld().method_17742(new class_3959(start.asVec3(), end.asVec3(), class_3959.class_3960.field_17559, fluid ? class_3959.class_242.field_1348 : class_3959.class_242.field_1347, (class_1297)new class_6335(class_1299.field_33456, WorldAPI.getCurrentWorld())));
        if (result == null || result.method_17783() == class_239.class_240.field_1333) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        class_2338 pos = result.method_17777();
        map.put("block", WorldAPI.getBlockState(pos.method_10263(), Double.valueOf(pos.method_10264()), Double.valueOf(pos.method_10260())));
        map.put("direction", result.method_17780().method_10151());
        map.put("pos", FiguraVec3.fromVec3(result.method_17784()));
        return map;
    }

    public HashMap<String, Object> raycastEntity(Object x, Object y, Double z, Object w, Double t, Double h) {
        Pair<FiguraVec3, FiguraVec3> pair = LuaUtils.parse2Vec3("raycastEntity", x, y, z, w, t, h);
        FiguraVec3 start = (FiguraVec3)pair.getFirst();
        FiguraVec3 end = (FiguraVec3)pair.getSecond();
        class_3966 result = class_1675.method_18075((class_1297)new class_6335(class_1299.field_33456, WorldAPI.getCurrentWorld()), (class_243)start.asVec3(), (class_243)end.asVec3(), (class_238)new class_238(start.asVec3(), end.asVec3()), entity -> true, (double)Double.MAX_VALUE);
        if (result == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("entity", EntityAPI.wrap(result.method_17782()));
        map.put("pos", FiguraVec3.fromVec3(result.method_17784()));
        return map;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="world.avatar_vars")
    public static Map<String, LuaTable> avatarVars() {
        HashMap<String, LuaTable> varList = new HashMap<String, LuaTable>();
        for (Avatar avatar : AvatarManager.getLoadedAvatars()) {
            LuaTable tbl = avatar.luaRuntime == null ? new LuaTable() : avatar.luaRuntime.avatar_meta.storedStuff;
            varList.put(avatar.owner.toString(), new ReadOnlyLuaTable((LuaValue)tbl));
        }
        return varList;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"block"}), @LuaMethodOverload(argumentTypes={String.class, FiguraVec3.class}, argumentNames={"block", "pos"}), @LuaMethodOverload(argumentTypes={String.class, Double.class, Double.class, Double.class}, argumentNames={"block", "x", "y", "z"})}, value="world.new_block")
    public static BlockStateAPI newBlock(@LuaNotNil String string, Object x, Double y, Double z) {
        class_2338 pos = LuaUtils.parseVec3("newBlock", x, y, z).asBlockPos();
        try {
            class_1937 level = WorldAPI.getCurrentWorld();
            class_2680 block = class_2257.method_9653((class_7157)class_7157.method_46722((class_7225.class_7874)level.method_30349(), (class_7699)level.method_45162())).method_9654(new StringReader(string)).method_9494();
            return new BlockStateAPI(block, pos);
        }
        catch (Exception e) {
            throw new LuaError("Could not parse block state from string: " + string);
        }
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"item"}), @LuaMethodOverload(argumentTypes={String.class, Integer.class}, argumentNames={"item", "count"}), @LuaMethodOverload(argumentTypes={String.class, Integer.class, Integer.class}, argumentNames={"item", "count", "damage"})}, value="world.new_item")
    public static ItemStackAPI newItem(@LuaNotNil String string, Integer count, Integer damage) {
        try {
            class_1937 level = WorldAPI.getCurrentWorld();
            class_1799 item = class_2287.method_9776((class_7157)class_7157.method_46722((class_7225.class_7874)level.method_30349(), (class_7699)level.method_45162())).method_9778(new StringReader(string)).method_9781(1, false);
            if (count != null) {
                item.method_7939(count.intValue());
            }
            if (damage != null) {
                item.method_7974(damage.intValue());
            }
            return new ItemStackAPI(item);
        }
        catch (Exception e) {
            throw new LuaError("Could not parse item stack from string: " + string);
        }
    }

    @LuaWhitelist
    @LuaMethodDoc(value="world.exists")
    public static boolean exists() {
        return WorldAPI.getCurrentWorld() != null;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="world.get_build_height")
    public static int[] getBuildHeight() {
        class_1937 world = WorldAPI.getCurrentWorld();
        return new int[]{world.method_31607(), world.method_31600()};
    }

    @LuaWhitelist
    @LuaMethodDoc(value="world.get_spawn_point")
    public static FiguraVec3 getSpawnPoint() {
        class_1937 world = WorldAPI.getCurrentWorld();
        return FiguraVec3.fromBlockPos(world.method_43126());
    }

    public String toString() {
        return "WorldAPI";
    }
}

