/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.lua.api.world;

import fabric.org.figuramc.figura.lua.LuaWhitelist;
import fabric.org.figuramc.figura.lua.NbtToLua;
import fabric.org.figuramc.figura.lua.ReadOnlyLuaTable;
import fabric.org.figuramc.figura.lua.api.world.ItemStackAPI;
import fabric.org.figuramc.figura.lua.api.world.WorldAPI;
import fabric.org.figuramc.figura.lua.docs.LuaFieldDoc;
import fabric.org.figuramc.figura.lua.docs.LuaMethodDoc;
import fabric.org.figuramc.figura.lua.docs.LuaMethodOverload;
import fabric.org.figuramc.figura.lua.docs.LuaTypeDoc;
import fabric.org.figuramc.figura.math.vector.FiguraVec3;
import fabric.org.figuramc.figura.mixin.BlockBehaviourAccessor;
import fabric.org.figuramc.figura.utils.ColorUtils;
import fabric.org.figuramc.figura.utils.LuaUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1922;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_776;
import net.minecraft.class_777;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;

@LuaWhitelist
@LuaTypeDoc(name="BlockState", value="blockstate")
public class BlockStateAPI {
    public final class_2680 blockState;
    private class_2338 pos;
    @LuaWhitelist
    @LuaFieldDoc(value="blockstate.id")
    public final String id;
    @LuaWhitelist
    @LuaFieldDoc(value="blockstate.properties")
    public final LuaTable properties;

    public BlockStateAPI(class_2680 blockstate, class_2338 pos) {
        this.blockState = blockstate;
        this.pos = pos;
        this.id = class_7923.field_41175.method_10221((Object)blockstate.method_26204()).toString();
        class_2487 tag = class_2512.method_10686((class_2680)blockstate);
        this.properties = new ReadOnlyLuaTable((LuaValue)(tag.method_10545("Properties") ? NbtToLua.convert(tag.method_10580("Properties")) : new LuaTable()));
    }

    protected class_2338 getBlockPos() {
        return this.pos == null ? class_2338.field_10980 : this.pos;
    }

    protected static List<List<FiguraVec3>> voxelShapeToTable(class_265 shape) {
        ArrayList<List<FiguraVec3>> shapes = new ArrayList<List<FiguraVec3>>();
        for (class_238 aabb : shape.method_1090()) {
            shapes.add(List.of(FiguraVec3.of(aabb.field_1323, aabb.field_1322, aabb.field_1321), FiguraVec3.of(aabb.field_1320, aabb.field_1325, aabb.field_1324)));
        }
        return shapes;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_id")
    public String getID() {
        return this.id;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_properties")
    public LuaTable getProperties() {
        return this.properties;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_pos")
    public FiguraVec3 getPos() {
        return FiguraVec3.fromBlockPos(this.getBlockPos());
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"pos"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, aliases={"pos"}, value="blockstate.set_pos")
    public BlockStateAPI setPos(Object x, Double y, Double z) {
        FiguraVec3 newPos = LuaUtils.parseVec3("setPos", x, y, z);
        this.pos = newPos.asBlockPos();
        return this;
    }

    @LuaWhitelist
    public BlockStateAPI pos(Object x, Double y, Double z) {
        return this.setPos(x, y, z);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.is_translucent")
    public boolean isTranslucent() {
        return this.blockState.method_26167((class_1922)WorldAPI.getCurrentWorld(), this.getBlockPos());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_opacity")
    public int getOpacity() {
        return this.blockState.method_26193((class_1922)WorldAPI.getCurrentWorld(), this.getBlockPos());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_map_color")
    public FiguraVec3 getMapColor() {
        return ColorUtils.intToRGB(this.blockState.method_26205((class_1922)WorldAPI.getCurrentWorld(), (class_2338)this.getBlockPos()).field_16011);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.is_solid_block")
    public boolean isSolidBlock() {
        return this.blockState.method_26212((class_1922)WorldAPI.getCurrentWorld(), this.getBlockPos());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.is_full_cube")
    public boolean isFullCube() {
        return this.blockState.method_26234((class_1922)WorldAPI.getCurrentWorld(), this.getBlockPos());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.has_emissive_lighting")
    public boolean hasEmissiveLighting() {
        return this.blockState.method_26208((class_1922)WorldAPI.getCurrentWorld(), this.getBlockPos());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_hardness")
    public float getHardness() {
        return this.blockState.method_26214((class_1922)WorldAPI.getCurrentWorld(), this.getBlockPos());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_comparator_output")
    public int getComparatorOutput() {
        return this.blockState.method_26176(WorldAPI.getCurrentWorld(), this.getBlockPos());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.has_block_entity")
    public boolean hasBlockEntity() {
        return this.blockState.method_31709();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.is_opaque")
    public boolean isOpaque() {
        return this.blockState.method_26225();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.emits_redstone_power")
    public boolean emitsRedstonePower() {
        return this.blockState.method_26219();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_luminance")
    public int getLuminance() {
        return this.blockState.method_26213();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_friction")
    public float getFriction() {
        return this.blockState.method_26204().method_9499();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_velocity_multiplier")
    public float getVelocityMultiplier() {
        return this.blockState.method_26204().method_23349();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_jump_velocity_multiplier")
    public float getJumpVelocityMultiplier() {
        return this.blockState.method_26204().method_23350();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_blast_resistance")
    public float getBlastResistance() {
        return this.blockState.method_26204().method_9520();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.as_item")
    public ItemStackAPI asItem() {
        return ItemStackAPI.verify(this.blockState.method_26204().method_8389().method_7854());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_tags")
    public List<String> getTags() {
        ArrayList<String> list = new ArrayList<String>();
        class_2378 registry = WorldAPI.getCurrentWorld().method_30349().method_30530(class_7924.field_41254);
        Optional key = registry.method_29113((Object)this.blockState.method_26204());
        if (key.isEmpty()) {
            return list;
        }
        for (class_6862 blockTagKey : registry.method_40290((class_5321)key.get()).method_40228().toList()) {
            list.add(blockTagKey.comp_327().toString());
        }
        return list;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.has_collision")
    public boolean hasCollision() {
        return ((BlockBehaviourAccessor)this.blockState.method_26204()).hasCollision();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_collision_shape")
    public List<List<FiguraVec3>> getCollisionShape() {
        return BlockStateAPI.voxelShapeToTable(this.blockState.method_26220((class_1922)WorldAPI.getCurrentWorld(), this.getBlockPos()));
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_outline_shape")
    public List<List<FiguraVec3>> getOutlineShape() {
        return BlockStateAPI.voxelShapeToTable(this.blockState.method_26218((class_1922)WorldAPI.getCurrentWorld(), this.getBlockPos()));
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_sounds")
    public Map<String, Object> getSounds() {
        HashMap<String, Object> sounds = new HashMap<String, Object>();
        class_2498 snd = this.blockState.method_26231();
        sounds.put("pitch", Float.valueOf(snd.method_10599()));
        sounds.put("volume", Float.valueOf(snd.method_10597()));
        sounds.put("break", snd.method_10595().method_14833().toString());
        sounds.put("fall", snd.method_10593().method_14833().toString());
        sounds.put("hit", snd.method_10596().method_14833().toString());
        sounds.put("place", snd.method_10598().method_14833().toString());
        sounds.put("step", snd.method_10594().method_14833().toString());
        return sounds;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_fluid_tags")
    public List<String> getFluidTags() {
        ArrayList<String> list = new ArrayList<String>();
        for (class_6862 fluidTagKey : this.blockState.method_26227().method_40181().toList()) {
            list.add(fluidTagKey.comp_327().toString());
        }
        return list;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_entity_data")
    public LuaTable getEntityData() {
        class_2586 entity = WorldAPI.getCurrentWorld().method_8321(this.getBlockPos());
        return (LuaTable)NbtToLua.convert((class_2520)(entity != null ? entity.method_38244() : null));
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.to_state_string")
    public String toStateString() {
        class_2586 entity = WorldAPI.getCurrentWorld().method_8321(this.getBlockPos());
        class_2487 tag = entity != null ? entity.method_38244() : new class_2487();
        return class_2259.method_9685((class_2680)this.blockState) + String.valueOf(tag);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_textures")
    public HashMap<String, Set<String>> getTextures() {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        class_2464 renderShape = this.blockState.method_26217();
        if (renderShape != class_2464.field_11458) {
            return map;
        }
        class_776 blockRenderer = class_310.method_1551().method_1541();
        class_1087 bakedModel = blockRenderer.method_3349(this.blockState);
        class_5819 randomSource = class_5819.method_43047();
        long seed = 42L;
        for (class_2350 direction : class_2350.values()) {
            map.put(direction.name(), BlockStateAPI.getTexturesForFace(this.blockState, direction, randomSource, bakedModel, seed));
        }
        map.put("NONE", BlockStateAPI.getTexturesForFace(this.blockState, null, randomSource, bakedModel, seed));
        class_1058 particle = blockRenderer.method_3351().method_3339(this.blockState);
        map.put("PARTICLE", Set.of(BlockStateAPI.getTextureName(particle)));
        return map;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.is_air")
    public boolean isAir() {
        return this.blockState.method_26215();
    }

    private static Set<String> getTexturesForFace(class_2680 blockState, class_2350 direction, class_5819 randomSource, class_1087 bakedModel, long seed) {
        randomSource.method_43052(seed);
        List quads = bakedModel.method_4707(blockState, direction, randomSource);
        HashSet<String> textures = new HashSet<String>();
        for (class_777 quad : quads) {
            textures.add(BlockStateAPI.getTextureName(quad.method_35788()));
        }
        return textures;
    }

    private static String getTextureName(class_1058 sprite) {
        class_2960 location = sprite.method_45851().method_45816();
        return location.method_12836() + ":textures/" + location.method_12832();
    }

    @LuaWhitelist
    public boolean __eq(BlockStateAPI other) {
        return this.blockState.equals(other.blockState);
    }

    @LuaWhitelist
    public Object __index(String arg) {
        if (arg == null) {
            return null;
        }
        return switch (arg) {
            case "id" -> this.id;
            case "properties" -> this.properties;
            default -> null;
        };
    }

    public String toString() {
        return this.id + " (BlockState)";
    }
}

