/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.lua.api.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.datafixers.util.Pair;
import fabric.org.figuramc.figura.avatar.Avatar;
import fabric.org.figuramc.figura.ducks.ParticleEngineAccessor;
import fabric.org.figuramc.figura.lua.LuaNotNil;
import fabric.org.figuramc.figura.lua.LuaWhitelist;
import fabric.org.figuramc.figura.lua.api.particle.LuaParticle;
import fabric.org.figuramc.figura.lua.docs.LuaMethodDoc;
import fabric.org.figuramc.figura.lua.docs.LuaMethodOverload;
import fabric.org.figuramc.figura.lua.docs.LuaTypeDoc;
import fabric.org.figuramc.figura.math.vector.FiguraVec3;
import fabric.org.figuramc.figura.utils.LuaUtils;
import net.minecraft.class_2223;
import net.minecraft.class_2394;
import net.minecraft.class_310;
import net.minecraft.class_703;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.luaj.vm2.LuaError;

@LuaWhitelist
@LuaTypeDoc(name="ParticleAPI", value="particles")
public class ParticleAPI {
    private final Avatar owner;

    public ParticleAPI(Avatar owner) {
        this.owner = owner;
    }

    public static ParticleEngineAccessor getParticleEngine() {
        return (ParticleEngineAccessor)class_310.method_1551().field_1713;
    }

    private LuaParticle generate(String id, double x, double y, double z, double w, double t, double h) {
        try {
            class_2394 options = class_2223.method_9418((StringReader)new StringReader(id), (class_7225)class_7923.field_41180.method_46771());
            class_703 p = ParticleAPI.getParticleEngine().figura$makeParticle(options, x, y, z, w, t, h);
            if (p == null) {
                throw new LuaError("Could not parse particle \"" + id + "\"");
            }
            return new LuaParticle(id, p, this.owner);
        }
        catch (Exception e) {
            throw new LuaError(e.getMessage());
        }
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class, FiguraVec3.class}, argumentNames={"name", "pos"}), @LuaMethodOverload(argumentTypes={String.class, FiguraVec3.class, FiguraVec3.class}, argumentNames={"name", "pos", "vel"}), @LuaMethodOverload(argumentTypes={String.class, Double.class, Double.class, Double.class}, argumentNames={"name", "posX", "posY", "posZ"}), @LuaMethodOverload(argumentTypes={String.class, FiguraVec3.class, Double.class, Double.class, Double.class}, argumentNames={"name", "pos", "velX", "velY", "velZ"}), @LuaMethodOverload(argumentTypes={String.class, Double.class, Double.class, Double.class, FiguraVec3.class}, argumentNames={"name", "posX", "posY", "posZ", "vel"}), @LuaMethodOverload(argumentTypes={String.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class}, argumentNames={"name", "posX", "posY", "posZ", "velX", "velY", "velZ"})}, value="particles.new_particle")
    public LuaParticle newParticle(@LuaNotNil String id, Object x, Object y, Double z, Object w, Double t, Double h) {
        Pair<FiguraVec3, FiguraVec3> pair = LuaUtils.parse2Vec3("newParticle", x, y, z, w, t, h);
        FiguraVec3 pos = (FiguraVec3)pair.getFirst();
        FiguraVec3 vel = (FiguraVec3)pair.getSecond();
        LuaParticle particle = this.generate(id, pos.x, pos.y, pos.z, vel.x, vel.y, vel.z);
        particle.spawn();
        return particle;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="particles.remove_particles")
    public ParticleAPI removeParticles() {
        ParticleAPI.getParticleEngine().figura$clearParticles(this.owner.owner);
        return this;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"id"})}, value="particles.is_present")
    public boolean isPresent(String id) {
        try {
            class_2394 options = class_2223.method_9418((StringReader)new StringReader(id), (class_7225)class_7923.field_41180.method_46771());
            return ParticleAPI.getParticleEngine().figura$makeParticle(options, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0) != null;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    @LuaWhitelist
    public LuaParticle __index(String id) {
        return this.generate(id, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public String toString() {
        return "ParticleAPI";
    }
}

