/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.lua.api;

import fabric.org.figuramc.figura.avatar.Avatar;
import fabric.org.figuramc.figura.lua.LuaNotNil;
import fabric.org.figuramc.figura.lua.LuaWhitelist;
import fabric.org.figuramc.figura.lua.docs.LuaMethodDoc;
import fabric.org.figuramc.figura.lua.docs.LuaMethodOverload;
import fabric.org.figuramc.figura.lua.docs.LuaTypeDoc;
import fabric.org.figuramc.figura.mixin.render.MissingTextureAtlasSpriteAccessor;
import fabric.org.figuramc.figura.mixin.render.TextureAtlasAccessor;
import fabric.org.figuramc.figura.model.rendering.texture.FiguraTexture;
import fabric.org.figuramc.figura.permissions.Permissions;
import fabric.org.figuramc.figura.utils.ColorUtils;
import fabric.org.figuramc.figura.utils.LuaUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1011;
import net.minecraft.class_1059;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaTable;

@LuaWhitelist
@LuaTypeDoc(name="TextureAPI", value="textures")
public class TextureAPI {
    private static final int TEXTURE_LIMIT = 128;
    private final Avatar owner;

    public TextureAPI(Avatar owner) {
        this.owner = owner;
    }

    private void check() {
        if (this.owner.renderer == null) {
            throw new LuaError("Avatar have no active renderer!");
        }
    }

    public FiguraTexture register(String name, class_1011 image, boolean ignoreSize) {
        int max = this.owner.permissions.get(Permissions.TEXTURE_SIZE);
        if (!(ignoreSize || image.method_4307() <= max && image.method_4323() <= max)) {
            this.owner.noPermissions.add(Permissions.TEXTURE_SIZE);
            throw new LuaError("Texture exceeded max size of " + max + " x " + max + " resolution, got " + image.method_4307() + " x " + image.method_4323());
        }
        FiguraTexture oldText = this.get(name);
        if (oldText != null) {
            oldText.close();
        }
        if (this.owner.renderer.customTextures.size() > 128) {
            throw new LuaError("Maximum amount of textures reached!");
        }
        FiguraTexture texture = new FiguraTexture(this.owner, name, image);
        this.owner.renderer.customTextures.put(name, texture);
        return texture;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class, Integer.class, Integer.class}, argumentNames={"name", "width", "height"})}, value="textures.new_texture")
    public FiguraTexture newTexture(@LuaNotNil String name, int width, int height) {
        class_1011 image;
        try {
            image = new class_1011(width, height, true);
        }
        catch (Exception e) {
            throw new LuaError(e.getMessage());
        }
        FiguraTexture texture = this.register(name, image, false);
        texture.fill(0, 0, width, height, ColorUtils.Colors.AWESOME_BLUE.vec.augmented(1.0), null, null, null);
        return texture;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class, String.class}, argumentNames={"name", "base64Text"}), @LuaMethodOverload(argumentTypes={String.class, LuaTable.class}, argumentNames={"name", "byteArray"})}, value="textures.read")
    public FiguraTexture read(@LuaNotNil String name, @LuaNotNil Object object) {
        class_1011 image;
        byte[] bytes;
        if (object instanceof LuaTable) {
            LuaTable table = (LuaTable)object;
            bytes = new byte[table.length()];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = (byte)table.get(i + 1).checkint();
            }
        } else if (object instanceof String) {
            String s = (String)object;
            bytes = Base64.getDecoder().decode(s);
        } else {
            throw new LuaError("Invalid type for read \"" + object.getClass().getSimpleName() + "\"");
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            image = class_1011.method_4310(null, (InputStream)bais);
            bais.close();
        }
        catch (Exception e) {
            throw new LuaError(e.getMessage());
        }
        return this.register(name, image, false);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class, FiguraTexture.class}, argumentNames={"name", "texture"})}, value="textures.copy")
    public FiguraTexture copy(@LuaNotNil String name, @LuaNotNil FiguraTexture texture) {
        class_1011 image = texture.copy();
        return this.register(name, image, false);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"name"})}, value="textures.get")
    public FiguraTexture get(@LuaNotNil String name) {
        this.check();
        return this.owner.renderer.customTextures.get(name);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="textures.get_textures")
    public List<FiguraTexture> getTextures() {
        this.check();
        return new ArrayList<FiguraTexture>(this.owner.renderer.textures.values());
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class, String.class}, argumentNames={"name", "path"})}, value="textures.from_vanilla")
    public FiguraTexture fromVanilla(@LuaNotNil String name, @LuaNotNil String path) {
        this.check();
        class_2960 resourceLocation = LuaUtils.parsePath(path);
        try {
            class_1059 atlas = class_310.method_1551().method_1554().method_24153(resourceLocation);
            atlas.method_23207();
            TextureAtlasAccessor atlasAccessor = (TextureAtlasAccessor)atlas;
            class_1011 nativeImage = new class_1011(atlasAccessor.getWidth(), atlasAccessor.getHeight(), false);
            nativeImage.method_4327(0, false);
            return this.register(name, nativeImage, false);
        }
        catch (Exception atlas) {
            try {
                Optional resource = class_310.method_1551().method_1478().method_14486(resourceLocation);
                class_1011 image = resource.isPresent() ? class_1011.method_4309((InputStream)((class_3298)resource.get()).method_14482()) : MissingTextureAtlasSpriteAccessor.generateImage(16, 16);
                return this.register(name, image, false);
            }
            catch (Exception e) {
                throw new LuaError(e.getMessage());
            }
        }
    }

    @LuaWhitelist
    public FiguraTexture __index(@LuaNotNil String name) {
        this.check();
        return this.owner.renderer.getTexture(name);
    }

    public String toString() {
        return "TextureAPI";
    }
}

