/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.lua.api;

import com.google.common.base.Suppliers;
import fabric.org.figuramc.figura.FiguraMod;
import fabric.org.figuramc.figura.lua.LuaNotNil;
import fabric.org.figuramc.figura.lua.LuaWhitelist;
import fabric.org.figuramc.figura.lua.api.TextureAtlasAPI;
import fabric.org.figuramc.figura.lua.api.entity.EntityAPI;
import fabric.org.figuramc.figura.lua.api.entity.ViewerAPI;
import fabric.org.figuramc.figura.lua.docs.LuaMethodDoc;
import fabric.org.figuramc.figura.lua.docs.LuaMethodOverload;
import fabric.org.figuramc.figura.lua.docs.LuaTypeDoc;
import fabric.org.figuramc.figura.math.vector.FiguraVec2;
import fabric.org.figuramc.figura.math.vector.FiguraVec3;
import fabric.org.figuramc.figura.mixin.gui.PlayerTabOverlayAccessor;
import fabric.org.figuramc.figura.mixin.render.ModelManagerAccessor;
import fabric.org.figuramc.figura.utils.EntityUtils;
import fabric.org.figuramc.figura.utils.LuaUtils;
import fabric.org.figuramc.figura.utils.PlatformUtils;
import fabric.org.figuramc.figura.utils.TextUtils;
import fabric.org.figuramc.figura.utils.Version;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.irisshaders.iris.api.v0.IrisApi;
import net.minecraft.class_1041;
import net.minecraft.class_1132;
import net.minecraft.class_155;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_327;
import net.minecraft.class_3288;
import net.minecraft.class_4844;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_640;
import net.minecraft.class_642;
import net.minecraft.client.ClientBrandRetriever;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaValue;

@LuaWhitelist
@LuaTypeDoc(name="ClientAPI", value="client")
public class ClientAPI {
    public static final ClientAPI INSTANCE = new ClientAPI();
    private static final HashMap<String, Boolean> LOADED_MODS = new HashMap();
    private static final boolean HAS_IRIS = PlatformUtils.isModLoaded("iris") || PlatformUtils.isModLoaded("oculus");
    public static final Supplier<Boolean> OPTIFINE_LOADED = Suppliers.memoize(() -> {
        try {
            Class.forName("net.optifine.Config");
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    });

    public static boolean hasOptifineShader() {
        try {
            Field shaderPackLoadedField = Class.forName("net.optifine.shaders.Shaders").getField("shaderPackLoaded");
            Class<?> shaderClass = shaderPackLoadedField.getType();
            if (shaderClass == Boolean.TYPE) {
                return shaderPackLoadedField.getBoolean(null);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return false;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_fps")
    public static int getFPS() {
        String s = ClientAPI.getFPSString();
        if (s.length() == 0) {
            return 0;
        }
        return Integer.parseInt(s.split(" ")[0]);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_fps_string")
    public static String getFPSString() {
        return class_310.method_1551().field_1770;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.is_paused")
    public static boolean isPaused() {
        return class_310.method_1551().method_1493();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_version")
    public static String getVersion() {
        return class_155.method_16673().method_48018();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_version_name")
    public static String getVersionName() {
        return class_155.method_16673().method_48019();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.is_snapshot")
    public static boolean isSnapshot() {
        return !class_155.method_16673().method_48022();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_client_brand")
    public static String getClientBrand() {
        return ClientBrandRetriever.getClientModName();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_server_brand")
    public static String getServerBrand() {
        if (class_310.method_1551().field_1724 == null) {
            return null;
        }
        return class_310.method_1551().method_1576() == null ? class_310.method_1551().field_1724.method_3135() : "Integrated";
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_chunk_statistics")
    public static String getChunkStatistics() {
        return class_310.method_1551().field_1769.method_3289();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_entity_statistics")
    public static String getEntityStatistics() {
        return class_310.method_1551().field_1769.method_3272();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_sound_statistics")
    public static String getSoundStatistics() {
        return class_310.method_1551().method_1483().method_20305();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_entity_count")
    public static int getEntityCount() {
        if (class_310.method_1551().field_1687 == null) {
            return 0;
        }
        return class_310.method_1551().field_1687.method_18120();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_particle_count")
    public static String getParticleCount() {
        return class_310.method_1551().field_1713.method_3052();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_current_effect")
    public static String getCurrentEffect() {
        if (class_310.method_1551().field_1773.method_3183() == null) {
            return null;
        }
        return class_310.method_1551().field_1773.method_3183().method_1260();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_java_version")
    public static String getJavaVersion() {
        return System.getProperty("java.version");
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_used_memory")
    public static long getUsedMemory() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_max_memory")
    public static long getMaxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_allocated_memory")
    public static long getAllocatedMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.is_window_focused")
    public static boolean isWindowFocused() {
        return class_310.method_1551().method_1569();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.is_hud_enabled")
    public static boolean isHudEnabled() {
        return class_310.method_1498();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.is_debug_overlay_enabled")
    public static boolean isDebugOverlayEnabled() {
        return class_310.method_1551().field_1690.field_1866;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_window_size")
    public static FiguraVec2 getWindowSize() {
        class_1041 window = class_310.method_1551().method_22683();
        return FiguraVec2.of(window.method_4489(), window.method_4506());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_fov")
    public static double getFOV() {
        return ((Integer)class_310.method_1551().field_1690.method_41808().method_41753()).intValue();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_system_time")
    public static long getSystemTime() {
        return System.currentTimeMillis();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_mouse_pos")
    public static FiguraVec2 getMousePos() {
        class_312 mouse = class_310.method_1551().field_1729;
        return FiguraVec2.of(mouse.method_1603(), mouse.method_1604());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_scaled_window_size")
    public static FiguraVec2 getScaledWindowSize() {
        class_1041 window = class_310.method_1551().method_22683();
        return FiguraVec2.of(window.method_4486(), window.method_4502());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_gui_scale")
    public static double getGuiScale() {
        return class_310.method_1551().method_22683().method_4495();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_camera_pos")
    public static FiguraVec3 getCameraPos() {
        class_243 pos = class_310.method_1551().field_1773.method_19418().method_19326();
        return FiguraVec3.fromVec3(pos);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_camera_rot")
    public static FiguraVec3 getCameraRot() {
        Quaternionf quaternion = class_310.method_1551().field_1773.method_19418().method_23767();
        Vector3f vec = new Vector3f();
        quaternion.getEulerAnglesYXZ(vec);
        double f = 57.29577951308232;
        return FiguraVec3.fromVec3f(vec).multiply(f, -f, f);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_camera_dir")
    public static FiguraVec3 getCameraDir() {
        return FiguraVec3.fromVec3f(class_310.method_1551().field_1773.method_19418().method_19335());
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"text"})}, value="client.get_text_width")
    public static int getTextWidth(@LuaNotNil String text) {
        return TextUtils.getWidth(TextUtils.splitText((class_5348)TextUtils.tryParseJson(text), "\n"), class_310.method_1551().field_1772);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"text"})}, value="client.get_text_height")
    public static int getTextHeight(String text) {
        Objects.requireNonNull(class_310.method_1551().field_1772);
        int lineHeight = 9;
        return text == null ? lineHeight : lineHeight * TextUtils.splitText((class_5348)TextUtils.tryParseJson(text), "\n").size();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"text"}), @LuaMethodOverload(argumentTypes={String.class, Integer.class, Boolean.class}, argumentNames={"text", "maxWidth", "wrap"})}, value="client.get_text_dimensions")
    public static FiguraVec2 getTextDimensions(@LuaNotNil String text, int maxWidth, Boolean wrap) {
        class_2561 component = TextUtils.tryParseJson(text);
        class_327 font = class_310.method_1551().field_1772;
        List<class_2561> list = TextUtils.formatInBounds((class_5348)component, font, maxWidth, wrap == null || wrap != false);
        int x = TextUtils.getWidth(list, font);
        int n = list.size();
        Objects.requireNonNull(font);
        int y = n * 9;
        return FiguraVec2.of(x, y);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_active_lang")
    public static String getActiveLang() {
        return class_310.method_1551().field_1690.field_1883;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"modID"})}, value="client.is_mod_loaded")
    public static boolean isModLoaded(String id) {
        if (Objects.equals(id, "optifine") || Objects.equals(id, "optifabric")) {
            return OPTIFINE_LOADED.get();
        }
        LOADED_MODS.putIfAbsent(id, PlatformUtils.isModLoaded(id));
        return LOADED_MODS.get(id);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.has_iris")
    public static boolean hasIris() {
        return HAS_IRIS || OPTIFINE_LOADED.get() != false;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.has_iris_shader")
    public static boolean hasIrisShader() {
        return HAS_IRIS && IrisApi.getInstance().isShaderPackInUse() || OPTIFINE_LOADED.get() != false && ClientAPI.hasOptifineShader();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"path"})}, value="client.has_resource")
    public static boolean hasResource(@LuaNotNil String path) {
        class_2960 resource = LuaUtils.parsePath(path);
        try {
            return class_310.method_1551().method_1478().method_14486(resource).isPresent();
        }
        catch (Exception ignored) {
            return false;
        }
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_active_resource_packs")
    public static List<String> getActiveResourcePacks() {
        ArrayList<String> list = new ArrayList<String>();
        for (class_3288 pack : class_310.method_1551().method_1520().method_14444()) {
            list.add(pack.method_14457().getString());
        }
        return list;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_figura_version")
    public static String getFiguraVersion() {
        return FiguraMod.VERSION.toString();
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class, String.class}, argumentNames={"version1", "version2"})}, value="client.compare_versions")
    public static int compareVersions(@LuaNotNil String ver1, @LuaNotNil String ver2) {
        Version v1 = new Version(ver1);
        Version v2 = new Version(ver2);
        if (v1.invalid) {
            throw new LuaError("Cannot parse version \"" + ver1 + "\"");
        }
        if (v2.invalid) {
            throw new LuaError("Cannot parse version \"" + ver2 + "\"");
        }
        return v1.compareTo(v2);
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={Integer.class, Integer.class, Integer.class, Integer.class}, argumentNames={"a", "b", "c", "d"})}, value="client.int_uuid_to_string")
    public static String intUUIDToString(int a, int b, int c, int d) {
        try {
            UUID uuid = class_4844.method_26276((int[])new int[]{a, b, c, d});
            return uuid.toString();
        }
        catch (Exception ignored) {
            throw new LuaError("Failed to parse uuid");
        }
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"uuid"})}, value="client.uuid_to_int_array")
    public static int[] uuidToIntArray(String uuid) {
        try {
            UUID id = UUID.fromString(uuid);
            return class_4844.method_26275((UUID)id);
        }
        catch (Exception ignored) {
            throw new LuaError("Failed to parse uuid");
        }
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_viewer")
    public static ViewerAPI getViewer() {
        return new ViewerAPI((class_1657)class_310.method_1551().field_1724);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_camera_entity")
    public static EntityAPI<?> getCameraEntity() {
        return EntityAPI.wrap(class_310.method_1551().method_1560());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_server_data")
    public static Map<String, String> getServerData() {
        HashMap<String, String> map = new HashMap<String, String>();
        class_1132 iServer = class_310.method_1551().method_1576();
        if (iServer != null) {
            map.put("name", iServer.method_27728().method_150());
            map.put("ip", iServer.method_3819());
            map.put("motd", iServer.method_3818());
            return map;
        }
        class_642 mServer = class_310.method_1551().method_1558();
        if (mServer != null) {
            map.put("name", mServer.field_3752);
            map.put("ip", mServer.field_3761);
            map.put("motd", mServer.field_3757.getString());
        }
        return map;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_date")
    public static Map<String, Object> getDate() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Calendar calendar = FiguraMod.CALENDAR;
        Date date = new Date();
        calendar.setTime(date);
        map.put("day", calendar.get(5));
        map.put("month", calendar.get(2) + 1);
        map.put("year", calendar.get(1));
        map.put("hour", calendar.get(11));
        map.put("minute", calendar.get(12));
        map.put("second", calendar.get(13));
        map.put("millisecond", calendar.get(14));
        map.put("week", calendar.get(3));
        map.put("year_day", calendar.get(6));
        map.put("week_day", calendar.get(7));
        map.put("daylight_saving", calendar.getTimeZone().inDaylightTime(date));
        SimpleDateFormat format = new SimpleDateFormat("Z|zzzz|G|MMMM|EEEE", Locale.US);
        String[] f = format.format(date).split("\\|");
        map.put("timezone", f[0]);
        map.put("timezone_name", f[1]);
        map.put("era", f[2]);
        map.put("month_name", f[3]);
        map.put("day_name", f[4]);
        return map;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_frame_time")
    public static double getFrameTime() {
        return class_310.method_1551().method_1488();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.list_atlases")
    public static List<String> listAtlases() {
        ArrayList<String> list = new ArrayList<String>();
        for (class_2960 res : ModelManagerAccessor.getVanillaAtlases().keySet()) {
            list.add(res.toString());
        }
        return list;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"path"})}, value="client.get_atlas")
    public static TextureAtlasAPI getAtlas(@LuaNotNil String atlas) {
        class_2960 path = LuaUtils.parsePath(atlas);
        try {
            return new TextureAtlasAPI(class_310.method_1551().method_1554().method_24153(path));
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @LuaWhitelist
    @LuaMethodDoc(value="client.get_tab_list")
    public static Map<String, Object> getTabList() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        PlayerTabOverlayAccessor accessor = (PlayerTabOverlayAccessor)class_310.method_1551().field_1705.method_1750();
        class_2561 header = accessor.getHeader();
        if (header != null) {
            map.put("header", header.getString());
            map.put("headerJson", header);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (class_640 entry : EntityUtils.getTabList()) {
            list.add(entry.method_2971() != null ? entry.method_2971().getString() : entry.method_2966().getName());
        }
        map.put("players", list);
        class_2561 footer = accessor.getFooter();
        if (footer != null) {
            map.put("footer", footer.getString());
            map.put("footerJson", footer);
        }
        return map;
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={String.class}, argumentNames={"text"}), @LuaMethodOverload(argumentTypes={String.class, LuaValue.class}, argumentNames={"text", "args"})}, value="client.get_translated_string")
    public static String getTranslatedString(@LuaNotNil String text, LuaValue args) {
        class_5250 component;
        if (args == null) {
            component = class_2561.method_43471((String)text);
        } else if (!args.istable()) {
            component = class_2561.method_43469((String)text, (Object[])new Object[]{args.tojstring()});
        } else {
            int len = args.length();
            Object[] arguments = new Object[len];
            for (int i = 0; i < len; ++i) {
                arguments[i] = args.get(i + 1).tojstring();
            }
            component = class_2561.method_43469((String)text, (Object[])arguments);
        }
        return component.getString();
    }

    public String toString() {
        return "ClientAPI";
    }
}

