/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.lua;

import fabric.org.figuramc.figura.lua.LuaNotNil;
import fabric.org.figuramc.figura.lua.LuaWhitelist;
import fabric.org.figuramc.figura.lua.docs.FiguraDocsManager;
import fabric.org.figuramc.figura.lua.docs.LuaTypeDoc;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2561;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaUserdata;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;

public class LuaTypeManager {
    private final Map<Class<?>, LuaTable> metatables = new HashMap();
    private final Map<Class<?>, String> namesCache = new HashMap();

    public void generateMetatableFor(final Class<?> clazz) {
        LuaTable superclassMetatable;
        if (this.metatables.containsKey(clazz)) {
            return;
        }
        if (!clazz.isAnnotationPresent(LuaWhitelist.class)) {
            throw new IllegalArgumentException("Tried to generate metatable for un-whitelisted class " + clazz.getName() + "!");
        }
        try {
            this.generateMetatableFor(clazz.getSuperclass());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        LuaTable metatable = new LuaTable();
        final LuaTable indexTable = new LuaTable();
        Class<?> currentClass = clazz;
        while (currentClass.isAnnotationPresent(LuaWhitelist.class)) {
            for (final Method method : currentClass.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(LuaWhitelist.class)) continue;
                String name = method.getName();
                if (name.startsWith("__")) {
                    if (metatable.rawget(name) != LuaValue.NIL) continue;
                    if (name.equals("__index")) {
                        metatable.set("__index", (LuaValue)new TwoArgFunction(){
                            final LuaFunction wrappedIndexer;
                            {
                                this.wrappedIndexer = LuaTypeManager.this.getWrapper(method);
                            }

                            public LuaValue call(LuaValue arg1, LuaValue arg2) {
                                LuaValue result = indexTable.get(arg2);
                                if (result == LuaValue.NIL) {
                                    result = this.wrappedIndexer.call(arg1, arg2);
                                }
                                return result;
                            }
                        });
                        continue;
                    }
                    metatable.set(name, (LuaValue)this.getWrapper(method));
                    continue;
                }
                indexTable.set(name, (LuaValue)this.getWrapper(method));
            }
            currentClass = currentClass.getSuperclass();
        }
        if (metatable.rawget("__index") == LuaValue.NIL) {
            metatable.set("__index", (LuaValue)indexTable);
        }
        if (metatable.rawget("__tostring") == LuaValue.NIL) {
            metatable.set("__tostring", (LuaValue)new OneArgFunction(){
                private final LuaString val;
                {
                    this.val = LuaString.valueOf((String)clazz.getName());
                }

                public LuaValue call(LuaValue arg) {
                    return this.val;
                }
            });
        }
        if (indexTable.rawget("__index") == LuaValue.NIL && (superclassMetatable = this.metatables.get(clazz.getSuperclass())) != null) {
            LuaTable newMetatable = new LuaTable();
            newMetatable.set("__index", superclassMetatable.get("__index"));
            indexTable.setmetatable((LuaValue)newMetatable);
        }
        this.metatables.put(clazz, metatable);
    }

    public void dumpMetatables(LuaTable table) {
        for (Map.Entry<Class<?>, LuaTable> entry : this.metatables.entrySet()) {
            if (!entry.getKey().isAnnotationPresent(LuaTypeDoc.class)) continue;
            String name = entry.getKey().getAnnotation(LuaTypeDoc.class).name();
            if (table.get(name) != LuaValue.NIL) {
                throw new IllegalStateException("Two classes have the same type name: " + name);
            }
            table.set(name, (LuaValue)entry.getValue());
        }
    }

    public String getTypeName(Class<?> clazz) {
        return this.namesCache.computeIfAbsent(clazz, someClass -> {
            if (someClass.isAnnotationPresent(LuaTypeDoc.class)) {
                return someClass.getAnnotation(LuaTypeDoc.class).name();
            }
            return someClass.getSimpleName();
        });
    }

    private static boolean[] getRequiredNotNil(Method method) {
        Parameter[] params = method.getParameters();
        boolean[] result = new boolean[params.length];
        for (int i = 0; i < params.length; ++i) {
            if (!params[i].isAnnotationPresent(LuaNotNil.class)) continue;
            result[i] = true;
        }
        return result;
    }

    public VarArgFunction getWrapper(final Method method) {
        return new VarArgFunction(){
            private final boolean isStatic;
            private Object caller;
            private final Class<?> clazz;
            private final Class<?>[] argumentTypes;
            private final Object[] actualArgs;
            private final boolean[] requiredNotNil;
            {
                this.isStatic = Modifier.isStatic(method.getModifiers());
                this.clazz = method.getDeclaringClass();
                this.argumentTypes = method.getParameterTypes();
                this.actualArgs = new Object[this.argumentTypes.length];
                this.requiredNotNil = LuaTypeManager.getRequiredNotNil(method);
            }

            public Varargs invoke(Varargs args) {
                Varargs v;
                Object result;
                if (!this.isStatic) {
                    this.caller = args.checkuserdata(1, this.clazz);
                }
                int offset = this.isStatic && this.argumentTypes.length > 0 && !this.argumentTypes[0].isAssignableFrom(this.clazz) && args.isuserdata(1) && this.clazz.isAssignableFrom(args.checkuserdata(1).getClass()) ? 1 : 0;
                for (int i = 0; i < this.argumentTypes.length; ++i) {
                    int argIndex = i + (this.isStatic ? 1 : 2) + offset;
                    boolean nil = args.isnil(argIndex);
                    if (nil && this.requiredNotNil[i]) {
                        throw new LuaError("bad argument: " + method.getName() + " " + argIndex + " do not allow nil values, expected " + FiguraDocsManager.getNameFor(this.argumentTypes[i]));
                    }
                    if (argIndex <= args.narg() && !nil) {
                        try {
                            this.actualArgs[i] = switch (this.argumentTypes[i].getName()) {
                                case "java.lang.Number", "java.lang.Double", "double" -> args.checkdouble(argIndex);
                                case "java.lang.String" -> args.checkjstring(argIndex);
                                case "java.lang.Boolean", "boolean" -> args.toboolean(argIndex);
                                case "java.lang.Float", "float" -> Float.valueOf((float)args.checkdouble(argIndex));
                                case "java.lang.Integer", "int" -> args.checkint(argIndex);
                                case "java.lang.Long", "long" -> args.checklong(argIndex);
                                case "org.luaj.vm2.LuaTable" -> args.checktable(argIndex);
                                case "org.luaj.vm2.LuaFunction" -> args.checkfunction(argIndex);
                                case "org.luaj.vm2.LuaValue" -> args.arg(argIndex);
                                case "java.lang.Object" -> LuaTypeManager.this.luaToJava(args.arg(argIndex));
                                default -> this.argumentTypes[i].getName().startsWith("[") ? LuaTypeManager.this.luaVarargToJava(args, argIndex, this.argumentTypes[i]) : args.checkuserdata(argIndex, this.argumentTypes[i]);
                            };
                            continue;
                        }
                        catch (LuaError err) {
                            String expectedType = FiguraDocsManager.getNameFor(this.argumentTypes[i]);
                            String actualType = args.arg(argIndex).type() == 7 ? FiguraDocsManager.getNameFor(args.arg(argIndex).checkuserdata().getClass()) : args.arg(argIndex).typename();
                            throw new LuaError("Invalid argument " + argIndex + " to function " + method.getName() + ". Expected " + expectedType + ", but got " + actualType);
                        }
                    }
                    this.actualArgs[i] = switch (this.argumentTypes[i].getName()) {
                        case "double" -> 0.0;
                        case "int" -> 0;
                        case "long" -> 0L;
                        case "float" -> Float.valueOf(0.0f);
                        case "boolean" -> Boolean.valueOf(false);
                        default -> null;
                    };
                }
                try {
                    result = method.invoke(this.caller, this.actualArgs);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    LuaError l;
                    Object object = e.getCause();
                    throw object instanceof LuaError ? (l = (LuaError)((Object)object)) : new LuaError(e.getCause());
                }
                return result instanceof Varargs ? (v = (Varargs)result) : LuaTypeManager.this.javaToLua(result);
            }

            public String tojstring() {
                return "function: " + method.getName();
            }
        };
    }

    private LuaValue wrap(Object instance) {
        Class<?> clazz = instance.getClass();
        LuaTable metatable = this.metatables.get(clazz);
        while (metatable == null) {
            if ((clazz = clazz.getSuperclass()) == Object.class) {
                throw new RuntimeException("Attempt to wrap illegal type " + instance.getClass().getName() + " (not registered in LuaTypeManager's \"metatables\" map)!");
            }
            metatable = this.metatables.get(clazz);
        }
        LuaUserdata result = new LuaUserdata(instance);
        result.setmetatable((LuaValue)metatable);
        return result;
    }

    private LuaValue wrapMap(Map<?, ?> map) {
        LuaTable table = new LuaTable();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            LuaValue key = this.javaToLua(entry.getKey()).arg1();
            LuaValue val = this.javaToLua(entry.getValue()).arg1();
            table.set(key, val);
        }
        return table;
    }

    private LuaValue wrapCollection(Collection<?> collection) {
        LuaTable table = new LuaTable();
        int i = 1;
        for (Object o : collection) {
            table.set(i++, this.javaToLua(o).arg1());
        }
        return table;
    }

    private Varargs wrapArray(Object array) {
        int len = Array.getLength(array);
        LuaValue[] args = new LuaValue[len];
        for (int i = 0; i < len; ++i) {
            args[i] = this.javaToLua(Array.get(array, i)).arg1();
        }
        return LuaValue.varargsOf((LuaValue[])args);
    }

    public Object luaVarargToJava(Varargs args, int argIndex, Class<?> argumentType) {
        if (args.arg(argIndex).istable()) {
            return this.luaVarargToJava(args.checktable(argIndex).unpack(), 1, argumentType);
        }
        Object[] obj = new Object[args.narg() - argIndex + 1];
        int start = argIndex;
        while (argIndex <= args.narg()) {
            obj[argIndex - start] = switch (argumentType.getName()) {
                case "[Ljava.lang.Number;", "[Ljava.lang.Double;", "[D" -> args.checkdouble(argIndex);
                case "[Ljava.lang.String;" -> args.checkjstring(argIndex);
                case "[Ljava.lang.Boolean;", "[B" -> args.toboolean(argIndex);
                case "[Ljava.lang.Float;", "[F" -> Float.valueOf((float)args.checkdouble(argIndex));
                case "[Ljava.lang.Integer;", "[I" -> args.checkint(argIndex);
                case "[Ljava.lang.Long;", "[J" -> args.checklong(argIndex);
                case "[Lorg.luaj.vm2.LuaTable;" -> args.checktable(argIndex);
                case "[Lorg.luaj.vm2.LuaFunction;" -> args.checkfunction(argIndex);
                case "[Lorg.luaj.vm2.LuaValue;" -> args.arg(argIndex);
                case "[Ljava.lang.Object;" -> this.luaToJava(args.arg(argIndex));
                default -> args.checkuserdata(argIndex, argumentType);
            };
            ++argIndex;
        }
        return Arrays.copyOf(obj, obj.length, argumentType);
    }

    public Object luaToJava(LuaValue val) {
        if (val.istable()) {
            return val.checktable();
        }
        if (val.isnumber()) {
            if (val instanceof LuaInteger) {
                LuaInteger i = (LuaInteger)val;
                return i.checkint();
            }
            if (val.isint() && val instanceof LuaString) {
                LuaString s = (LuaString)val;
                return s.checkint();
            }
            return val.checkdouble();
        }
        if (val.isstring()) {
            return val.checkjstring();
        }
        if (val.isboolean()) {
            return val.checkboolean();
        }
        if (val.isfunction()) {
            return val.checkfunction();
        }
        if (val.isuserdata()) {
            return val.checkuserdata(Object.class);
        }
        return null;
    }

    public Varargs javaToLua(Object val) {
        if (val == null) {
            return LuaValue.NIL;
        }
        if (val instanceof LuaValue) {
            LuaValue l = (LuaValue)val;
            return l;
        }
        if (val instanceof Double) {
            Double d = (Double)val;
            return LuaValue.valueOf((double)d);
        }
        if (val instanceof String) {
            String s = (String)val;
            return LuaValue.valueOf((String)s);
        }
        if (val instanceof Boolean) {
            Boolean b = (Boolean)val;
            return LuaValue.valueOf((boolean)b);
        }
        if (val instanceof Integer) {
            Integer i = (Integer)val;
            return LuaValue.valueOf((int)i);
        }
        if (val instanceof Float) {
            Float f = (Float)val;
            return LuaValue.valueOf((double)f.floatValue());
        }
        if (val instanceof Byte) {
            Byte b = (Byte)val;
            return LuaValue.valueOf((int)b.byteValue());
        }
        if (val instanceof Long) {
            Long l = (Long)val;
            return LuaValue.valueOf((double)l.longValue());
        }
        if (val instanceof Character) {
            Character c = (Character)val;
            return LuaValue.valueOf((int)c.charValue());
        }
        if (val instanceof Short) {
            Short s = (Short)val;
            return LuaValue.valueOf((int)s.shortValue());
        }
        if (val instanceof Map) {
            Map map = (Map)val;
            return this.wrapMap(map);
        }
        if (val instanceof Collection) {
            Collection collection = (Collection)val;
            return this.wrapCollection(collection);
        }
        if (val.getClass().isArray()) {
            return this.wrapArray(val);
        }
        if (val instanceof class_2561) {
            class_2561 c = (class_2561)val;
            return LuaValue.valueOf((String)class_2561.class_2562.method_10867((class_2561)c));
        }
        return this.wrap(val);
    }
}

