/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.lua;

import fabric.org.figuramc.figura.FiguraMod;
import fabric.org.figuramc.figura.avatar.Avatar;
import fabric.org.figuramc.figura.lua.FiguraAPIManager;
import fabric.org.figuramc.figura.lua.FiguraLuaExtras;
import fabric.org.figuramc.figura.lua.FiguraLuaPrinter;
import fabric.org.figuramc.figura.lua.LuaTypeManager;
import fabric.org.figuramc.figura.lua.ReadOnlyLuaTable;
import fabric.org.figuramc.figura.lua.api.AvatarAPI;
import fabric.org.figuramc.figura.lua.api.HostAPI;
import fabric.org.figuramc.figura.lua.api.RendererAPI;
import fabric.org.figuramc.figura.lua.api.TextureAPI;
import fabric.org.figuramc.figura.lua.api.action_wheel.ActionWheelAPI;
import fabric.org.figuramc.figura.lua.api.entity.EntityAPI;
import fabric.org.figuramc.figura.lua.api.entity.NullEntity;
import fabric.org.figuramc.figura.lua.api.event.EventsAPI;
import fabric.org.figuramc.figura.lua.api.event.LuaEvent;
import fabric.org.figuramc.figura.lua.api.keybind.KeybindAPI;
import fabric.org.figuramc.figura.lua.api.nameplate.NameplateAPI;
import fabric.org.figuramc.figura.lua.api.ping.PingAPI;
import fabric.org.figuramc.figura.lua.api.vanilla_model.VanillaModelAPI;
import fabric.org.figuramc.figura.permissions.Permissions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.compiler.LuaC;
import org.luaj.vm2.lib.Bit32Lib;
import org.luaj.vm2.lib.DebugLib;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.TableLib;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;
import org.luaj.vm2.lib.jse.JseBaseLib;
import org.luaj.vm2.lib.jse.JseMathLib;
import org.luaj.vm2.lib.jse.JseStringLib;

public class FiguraLuaRuntime {
    public EntityAPI<?> entityAPI;
    public EventsAPI events;
    public VanillaModelAPI vanilla_model;
    public KeybindAPI keybinds;
    public HostAPI host;
    public NameplateAPI nameplate;
    public RendererAPI renderer;
    public ActionWheelAPI action_wheel;
    public AvatarAPI avatar_meta;
    public PingAPI ping;
    public TextureAPI texture;
    public final Avatar owner;
    private final Globals userGlobals = new Globals();
    private final LuaValue setHookFunction;
    protected final Map<String, String> scripts = new HashMap<String, String>();
    private final Map<String, Varargs> loadedScripts = new HashMap<String, Varargs>();
    private final Stack<String> loadingScripts = new Stack();
    public final LuaTypeManager typeManager = new LuaTypeManager();
    private final VarArgFunction requireFunction = new VarArgFunction(){

        public Varargs invoke(Varargs arg) {
            String name = arg.checkjstring(1).replaceAll("[/\\\\]", ".");
            if (FiguraLuaRuntime.this.loadingScripts.contains(name)) {
                throw new LuaError("Detected circular dependency in script " + FiguraLuaRuntime.this.loadingScripts.peek());
            }
            if (FiguraLuaRuntime.this.scripts.get(name) == null && arg.isfunction(2)) {
                return arg.checkfunction(2).invoke((Varargs)LuaValue.valueOf((String)name));
            }
            return FiguraLuaRuntime.this.INIT_SCRIPT.apply(name);
        }

        public String tojstring() {
            return "function: require";
        }
    };
    private static final Function<FiguraLuaRuntime, LuaValue> LOADSTRING_FUNC = runtime -> new VarArgFunction((FiguraLuaRuntime)runtime){
        final /* synthetic */ FiguraLuaRuntime val$runtime;
        {
            this.val$runtime = figuraLuaRuntime;
        }

        public Varargs invoke(Varargs args) {
            try {
                InputStream ld;
                LuaValue val = args.arg(1);
                if (val.isfunction()) {
                    ld = new FuncStream(val.checkfunction());
                } else if (val.isstring()) {
                    ld = new ByteArrayInputStream(val.checkstring().m_bytes);
                } else {
                    throw new LuaError("chunk source is neither a string nor function");
                }
                val = args.arg(2);
                String chunkName = val.isstring() ? val.tojstring() : "loadstring";
                val = args.arg(3);
                LuaTable environment = val.istable() ? val.checktable() : this.val$runtime.userGlobals;
                return this.val$runtime.userGlobals.load(ld, chunkName, "t", (LuaValue)environment);
            }
            catch (LuaError e) {
                return 2.varargsOf((LuaValue)NIL, (Varargs)e.getMessageObject());
            }
        }

        public String tojstring() {
            return "function: loadstring";
        }

        private static class FuncStream
        extends InputStream {
            private final LuaFunction function;
            private String string = "";
            private int index = 0;

            public FuncStream(LuaFunction function) {
                this.function = function;
            }

            @Override
            public int read() {
                if (++this.index >= this.string.length()) {
                    this.index = 0;
                    Varargs result = this.function.invoke();
                    if (!result.isstring(1) || result.arg1().length() < 1) {
                        return -1;
                    }
                    this.string = new String(result.checkstring((int)1).m_bytes, StandardCharsets.UTF_8);
                }
                return this.string.charAt(this.index);
            }
        }
    };
    private final TwoArgFunction listFiles = new TwoArgFunction(){

        public LuaValue call(LuaValue arg1, LuaValue arg2) {
            String path = arg1.isnil() ? "" : arg1.checkjstring();
            path = path.replaceAll("[/\\\\]", ".");
            int depth = path.isBlank() ? 1 : path.split("\\.").length + 1;
            boolean subFolders = !arg2.isnil() && arg2.checkboolean();
            int i = 1;
            LuaTable table = new LuaTable();
            for (String s : FiguraLuaRuntime.this.scripts.keySet()) {
                String[] split = s.split("\\.");
                if (!s.startsWith(path) || split.length > depth && !subFolders) continue;
                table.set(i++, (LuaValue)LuaValue.valueOf((String)s));
            }
            return table;
        }
    };
    private final Function<String, Varargs> INIT_SCRIPT = str -> {
        String name = str.replaceAll("[/\\\\]", ".");
        Varargs val = this.loadedScripts.get(name);
        if (val != null) {
            return val;
        }
        String src = this.scripts.get(name);
        if (src == null) {
            throw new LuaError("Tried to require nonexistent script \"" + str + "\"!");
        }
        this.loadingScripts.push(name);
        int split = name.lastIndexOf(46);
        String path = split == -1 ? "" : name.substring(0, split);
        String fileName = split == -1 ? name : name.substring(split + 1);
        Varargs value = this.userGlobals.load(src, name).invoke(LuaValue.varargsOf((LuaValue)LuaValue.valueOf((String)path), (Varargs)LuaValue.valueOf((String)fileName)));
        if (value == LuaValue.NIL) {
            value = LuaValue.TRUE;
        }
        this.loadedScripts.put(name, value);
        this.loadingScripts.pop();
        return value;
    };
    private final ZeroArgFunction onReachedLimit = new ZeroArgFunction(){

        public LuaValue call() {
            FiguraMod.LOGGER.warn("Avatar {} bypassed resource limits with {} instructions", (Object)FiguraLuaRuntime.this.owner.owner, (Object)FiguraLuaRuntime.this.getInstructions());
            LuaError error = new LuaError("Script overran resource limits!");
            FiguraLuaRuntime.this.owner.noPermissions.add(Permissions.INIT_INST);
            FiguraLuaRuntime.this.setInstructionLimit(1);
            throw error;
        }
    };

    public FiguraLuaRuntime(Avatar avatar, Map<String, String> scripts) {
        this.owner = avatar;
        this.scripts.putAll(scripts);
        this.userGlobals.load((LuaValue)new JseBaseLib());
        this.userGlobals.load((LuaValue)new Bit32Lib());
        this.userGlobals.load((LuaValue)new TableLib());
        this.userGlobals.load((LuaValue)new JseStringLib());
        this.userGlobals.load((LuaValue)new JseMathLib());
        LuaC.install((Globals)this.userGlobals);
        this.userGlobals.load((LuaValue)new DebugLib());
        this.setHookFunction = this.userGlobals.get("debug").get("sethook");
        this.setupFiguraSandbox();
        FiguraAPIManager.setupTypesAndAPIs(this);
        this.setUser(null);
        this.loadExtraLibraries();
        LuaTable figuraMetatables = new LuaTable();
        this.typeManager.dumpMetatables(figuraMetatables);
        this.setGlobal("figuraMetatables", figuraMetatables);
    }

    public void registerClass(Class<?> clazz) {
        this.typeManager.generateMetatableFor(clazz);
    }

    public void setGlobal(String name, Object obj) {
        this.userGlobals.set(name, this.typeManager.javaToLua(obj).arg1());
    }

    public void setUser(class_1297 user) {
        Object val;
        if (user == null) {
            this.entityAPI = null;
            val = NullEntity.INSTANCE;
        } else {
            this.entityAPI = EntityAPI.wrap(user);
            val = this.entityAPI;
        }
        this.userGlobals.set("user", this.typeManager.javaToLua(val).arg1());
        this.userGlobals.set("player", this.userGlobals.get("user"));
    }

    public class_1297 getUser() {
        return this.entityAPI != null && this.entityAPI.isLoaded() ? (class_1297)this.entityAPI.getEntity() : null;
    }

    private void setupFiguraSandbox() {
        try (InputStream inputStream = FiguraMod.class.getResourceAsStream("/assets/figura/scripts/sandbox.lua");){
            if (inputStream == null) {
                throw new IOException("Unable to get resource");
            }
            this.userGlobals.load(new String(inputStream.readAllBytes()), "sandbox").call();
        }
        catch (Exception e) {
            this.error(new LuaError("Failed to load builtin sandbox script:\n" + e.getMessage()));
        }
        LuaString.s_metatable = new ReadOnlyLuaTable(LuaString.s_metatable);
    }

    private void loadExtraLibraries() {
        this.userGlobals.set("require", (LuaValue)this.requireFunction);
        FiguraLuaPrinter.loadPrintFunctions(this);
        FiguraLuaExtras.loadFunctions(this);
        LuaValue loadstring = LOADSTRING_FUNC.apply(this);
        this.setGlobal("load", loadstring);
        this.setGlobal("loadstring", loadstring);
        this.setGlobal("listFiles", this.listFiles);
        try (InputStream inputStream = FiguraMod.class.getResourceAsStream("/assets/figura/scripts/math.lua");){
            if (inputStream == null) {
                throw new IOException("Unable to get resource");
            }
            this.userGlobals.load(new String(inputStream.readAllBytes()), "math").call();
        }
        catch (Exception e) {
            this.error(new LuaError("Failed to load builtin math script:\n" + e.getMessage()));
        }
        this.setGlobal("type", new OneArgFunction(){

            public LuaValue call(LuaValue arg) {
                LuaValue __type;
                if (arg.type() == 7) {
                    return LuaString.valueOf((String)FiguraLuaRuntime.this.typeManager.getTypeName(arg.checkuserdata().getClass()));
                }
                if (arg.type() == 5 && arg.getmetatable() != null && !(__type = arg.getmetatable().rawget("__type")).isnil()) {
                    return __type;
                }
                return LuaString.valueOf((String)arg.typename());
            }

            public String tojstring() {
                return this.typename() + ": type";
            }
        });
        final LuaFunction globalPairs = this.userGlobals.get("pairs").checkfunction();
        this.setGlobal("pairs", new VarArgFunction(){

            public Varargs invoke(Varargs varargs) {
                LuaValue __pairs;
                LuaValue arg1 = varargs.arg1();
                if (arg1.type() == 5 && arg1.getmetatable() != null && (__pairs = arg1.getmetatable().rawget("__pairs")).isfunction()) {
                    return __pairs.invoke(varargs);
                }
                return globalPairs.invoke(varargs);
            }

            public String tojstring() {
                return this.typename() + ": pairs";
            }
        });
        final LuaFunction globalIPairs = this.userGlobals.get("ipairs").checkfunction();
        this.setGlobal("ipairs", new VarArgFunction(){

            public Varargs invoke(Varargs varargs) {
                LuaValue __ipairs;
                LuaValue arg1 = varargs.arg1();
                if (arg1.type() == 5 && arg1.getmetatable() != null && (__ipairs = arg1.getmetatable().rawget("__ipairs")).isfunction()) {
                    return __ipairs.invoke(varargs);
                }
                return globalIPairs.invoke(varargs);
            }

            public String tojstring() {
                return this.typename() + ": ipairs";
            }
        });
    }

    public boolean init(class_2499 autoScripts) {
        if (this.scripts.isEmpty()) {
            return false;
        }
        this.owner.luaRuntime = this;
        try {
            if (autoScripts == null) {
                for (String name : this.scripts.keySet()) {
                    this.INIT_SCRIPT.apply(name);
                }
            } else {
                for (class_2520 name : autoScripts) {
                    this.INIT_SCRIPT.apply(name.method_10714());
                }
            }
        }
        catch (Exception | StackOverflowError e) {
            this.error(e);
            return false;
        }
        return true;
    }

    public void error(Throwable e) {
        FiguraLuaPrinter.sendLuaError(FiguraLuaRuntime.parseError(e), this.owner);
        this.owner.scriptError = true;
        this.owner.luaRuntime = null;
        this.owner.clearParticles();
        this.owner.clearSounds();
    }

    public static LuaError parseError(Throwable e) {
        LuaError lua;
        return e instanceof LuaError ? (lua = (LuaError)e) : (e instanceof StackOverflowError ? new LuaError("Stack Overflow") : new LuaError(e));
    }

    public void setInstructionLimit(int limit) {
        this.userGlobals.running.state.bytecodes = 0;
        this.setHookFunction.invoke(LuaValue.varargsOf((LuaValue)this.onReachedLimit, (LuaValue)LuaValue.EMPTYSTRING, (Varargs)LuaValue.valueOf((int)Math.max(limit, 1))));
    }

    public int getInstructions() {
        return this.userGlobals.running.state.bytecodes;
    }

    public void takeInstructions(int amount) {
        this.userGlobals.running.state.bytecodes += amount;
    }

    public LuaValue load(String name, String src) {
        return this.userGlobals.load(src, name, (LuaTable)this.userGlobals);
    }

    public Varargs run(Object toRun, Avatar.Instructions limit, Object ... args) {
        LuaValue[] values = new LuaValue[args.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.typeManager.javaToLua(args[i]).arg1();
        }
        Varargs val = LuaValue.varargsOf((LuaValue[])values);
        this.setInstructionLimit(limit.remaining);
        try {
            Varargs ret;
            if (toRun instanceof LuaEvent) {
                LuaEvent event = (LuaEvent)toRun;
                ret = event.call(val);
            } else if (toRun instanceof String) {
                String event = (String)toRun;
                ret = this.events.__index(event).call(val);
            } else if (toRun instanceof LuaValue) {
                LuaValue func = (LuaValue)toRun;
                ret = func.invoke(val);
            } else {
                throw new IllegalArgumentException("Internal event error - Invalid type to run! (" + toRun.getClass().getSimpleName() + ")");
            }
            limit.use(this.getInstructions());
            return ret;
        }
        catch (Exception | StackOverflowError e) {
            this.error(e);
            return null;
        }
    }
}

