/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.gui.widgets.lists;

import fabric.org.figuramc.figura.avatar.Avatar;
import fabric.org.figuramc.figura.gui.widgets.AbstractContainerElement;
import fabric.org.figuramc.figura.gui.widgets.Label;
import fabric.org.figuramc.figura.gui.widgets.ParentedButton;
import fabric.org.figuramc.figura.gui.widgets.lists.AbstractList;
import fabric.org.figuramc.figura.lua.api.sound.LuaSound;
import fabric.org.figuramc.figura.lua.api.sound.SoundAPI;
import fabric.org.figuramc.figura.utils.FiguraIdentifier;
import fabric.org.figuramc.figura.utils.FiguraText;
import fabric.org.figuramc.figura.utils.MathUtils;
import fabric.org.figuramc.figura.utils.TextUtils;
import fabric.org.figuramc.figura.utils.ui.UIHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1144;
import net.minecraft.class_124;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4231;
import net.minecraft.class_5348;

public class SoundsList
extends AbstractList {
    private final List<SoundElement> sounds = new ArrayList<SoundElement>();
    private final Avatar owner;
    private SoundElement selected;

    public SoundsList(int x, int y, int width, int height, Avatar owner) {
        super(x, y, width, height);
        this.owner = owner;
        this.updateList();
        Label noOwner = new Label(FiguraText.of("gui.error.no_avatar").method_27692(class_124.field_1054), x + width / 2, y + height / 2, TextUtils.Alignment.CENTER, 0);
        this.children.add(noOwner);
        Label noSounds = new Label(FiguraText.of("gui.error.no_sounds").method_27692(class_124.field_1054), x + width / 2, y + height / 2, TextUtils.Alignment.CENTER, 0);
        this.children.add(noSounds);
        noSounds.centerVertically = true;
        noOwner.centerVertically = true;
        noOwner.setVisible(owner == null);
        noSounds.setVisible(!noOwner.isVisible() && this.sounds.isEmpty());
    }

    @Override
    public void method_25394(class_332 gui, int mouseX, int mouseY, float delta) {
        UIHelper.blitSliced(gui, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), UIHelper.OUTLINE_FILL);
        this.enableScissors(gui);
        if (!this.sounds.isEmpty()) {
            this.updateEntries();
        }
        super.method_25394(gui, mouseX, mouseY, delta);
        gui.method_44380();
    }

    private void updateEntries() {
        int totalHeight = -4;
        for (SoundElement sound : this.sounds) {
            totalHeight += sound.method_25364() + 8;
        }
        int entryHeight = this.sounds.isEmpty() ? 0 : totalHeight / this.sounds.size();
        this.scrollBar.setVisible(totalHeight > this.method_25364());
        this.scrollBar.setScrollRatio(entryHeight, totalHeight - this.method_25364());
        int xOffset = this.scrollBar.isVisible() ? 4 : 11;
        int yOffset = this.scrollBar.isVisible() ? (int)(-class_3532.method_16436((double)this.scrollBar.getScrollProgress(), (double)-4.0, (double)(totalHeight - this.method_25364()))) : 4;
        for (SoundElement sound : this.sounds) {
            sound.method_46421(this.method_46426() + xOffset);
            sound.method_46419(this.method_46427() + yOffset);
            yOffset += sound.method_25364() + 8;
        }
    }

    private void updateList() {
        this.sounds.forEach(this.children::remove);
        if (this.owner == null) {
            return;
        }
        for (Map.Entry<String, class_4231> entry : this.owner.customSounds.entrySet()) {
            SoundElement sound = new SoundElement(this.method_25368() - 22, entry.getKey(), entry.getValue(), this, this.owner);
            this.sounds.add(sound);
            this.children.add(sound);
        }
        this.sounds.sort(SoundElement::compareTo);
        if (!this.sounds.isEmpty()) {
            this.selected = this.sounds.get(0);
        }
    }

    public LuaSound getSound() {
        return this.selected != null ? this.selected.getSound() : null;
    }

    private static class SoundElement
    extends AbstractContainerElement
    implements Comparable<SoundElement> {
        private final class_2561 size;
        private final String name;
        private final class_4231 sound;
        private final Avatar owner;
        private final SoundsList parent;
        private final ParentedButton play;
        private final ParentedButton stop;

        public SoundElement(int width, String name, class_4231 sound, SoundsList parent, Avatar owner) {
            super(0, 0, width, 20);
            this.name = name;
            this.sound = sound;
            this.owner = owner;
            this.parent = parent;
            int len = owner.nbt.method_10562("sounds").method_10547(name).length;
            this.size = class_2561.method_43470((String)("(" + MathUtils.asFileSize(len) + ")")).method_27692(class_124.field_1080);
            this.play = new ParentedButton(0, 0, 20, 20, 0, 0, 20, new FiguraIdentifier("textures/gui/play.png"), 60, 20, (class_2561)FiguraText.of("gui.sound.play"), this, button -> {}){

                public void method_25354(class_1144 soundManager) {
                    class_243 vec = class_310.method_1551().field_1724 == null ? new class_243(0.0, 0.0, 0.0) : class_310.method_1551().field_1724.method_19538();
                    this.getSound().pos(vec.field_1352, vec.field_1351, vec.field_1350).play();
                }
            };
            this.children.add(0, this.play);
            this.stop = new ParentedButton(0, 0, 20, 20, 0, 0, 20, (class_2960)new FiguraIdentifier("textures/gui/stop.png"), 60, 20, (class_2561)FiguraText.of("gui.sound.stop"), this, button -> SoundAPI.getSoundEngine().figura$stopSound(owner.owner, name));
            this.children.add(this.stop);
        }

        @Override
        public void method_25394(class_332 gui, int mouseX, int mouseY, float delta) {
            if (!this.isVisible()) {
                return;
            }
            int x = this.method_46426();
            int y = this.method_46427();
            int width = this.method_25368();
            int height = this.method_25364();
            if (this.parent.selected == this) {
                UIHelper.fillOutline(gui, x - 1, y - 1, width + 2, height + 2, -1);
            }
            class_327 font = class_310.method_1551().field_1772;
            int n = y + height / 2;
            Objects.requireNonNull(font);
            int textY = n - 9 / 2;
            this.setHovered(this.method_25405(mouseX, mouseY));
            if (this.isHovered()) {
                gui.method_27535(font, HOVERED_ARROW, x + 4, textY, 0xFFFFFF);
            }
            gui.method_25303(font, this.name, x + 16, textY, 0xFFFFFF);
            gui.method_27535(font, this.size, x + width - 96 - font.method_27525((class_5348)this.size), textY, 0xFFFFFF);
            super.method_25394(gui, mouseX, mouseY, delta);
        }

        @Override
        public boolean method_25405(double mouseX, double mouseY) {
            return this.parent.isInsideScissors(mouseX, mouseY) && super.method_25405(mouseX, mouseY);
        }

        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            boolean clicked = super.method_25402(mouseX, mouseY, button);
            if (!clicked && this.method_25405(mouseX, mouseY)) {
                this.parent.selected = this;
                return true;
            }
            return clicked;
        }

        @Override
        public void method_46421(int x) {
            super.method_46421(x);
            this.play.method_46421(x + this.method_25368() - 64);
            this.stop.method_46421(x + this.method_25368() - 40);
        }

        @Override
        public void method_46419(int y) {
            super.method_46419(y);
            this.play.method_46419(y);
            this.stop.method_46419(y);
        }

        public LuaSound getSound() {
            return new LuaSound(this.sound, this.name, this.owner);
        }

        @Override
        public int compareTo(SoundElement o) {
            return this.name.compareTo(o.name);
        }
    }
}

