/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.gui.widgets.config;

import fabric.org.figuramc.figura.FiguraMod;
import fabric.org.figuramc.figura.config.ConfigType;
import fabric.org.figuramc.figura.config.Configs;
import fabric.org.figuramc.figura.gui.screens.ConfigScreen;
import fabric.org.figuramc.figura.gui.widgets.AbstractContainerElement;
import fabric.org.figuramc.figura.gui.widgets.ContainerButton;
import fabric.org.figuramc.figura.gui.widgets.config.AbstractConfigElement;
import fabric.org.figuramc.figura.gui.widgets.config.BooleanElement;
import fabric.org.figuramc.figura.gui.widgets.config.ButtonElement;
import fabric.org.figuramc.figura.gui.widgets.config.EnumElement;
import fabric.org.figuramc.figura.gui.widgets.config.InputElement;
import fabric.org.figuramc.figura.gui.widgets.config.KeybindElement;
import fabric.org.figuramc.figura.gui.widgets.lists.ConfigList;
import fabric.org.figuramc.figura.utils.ui.UIHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public class CategoryWidget
extends AbstractContainerElement {
    protected final List<AbstractConfigElement> entries = new ArrayList<AbstractConfigElement>();
    private final ConfigType.Category config;
    private final ConfigList parent;
    private ContainerButton parentConfig;

    public CategoryWidget(int width, ConfigType.Category config, ConfigList parent) {
        super(0, 0, width, 20);
        this.config = config;
        this.parent = parent;
        this.parentConfig = new ContainerButton(parent, 0, 0, width, 20, (class_2561)(config == null ? class_2561.method_43473() : config.name), config == null ? null : config.tooltip, button -> {
            boolean toggled = this.parentConfig.isToggled();
            this.setShowChildren(toggled);
            ConfigScreen.CATEGORY_DATA.put(config, toggled);
            parent.updateScroll();
        });
        Boolean expanded = ConfigScreen.CATEGORY_DATA.get(config);
        this.parentConfig.setToggled(expanded == null || expanded != false);
        this.parentConfig.shouldHaveBackground(false);
        this.children.add(this.parentConfig);
    }

    @Override
    public void method_25394(class_332 gui, int mouseX, int mouseY, float delta) {
        if (!this.isVisible()) {
            return;
        }
        if (this.parentConfig.isToggled() && this.entries.size() > 0) {
            gui.method_25294(this.method_46426(), this.method_46427() + 21, this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), 0x11FFFFFF);
        }
        if (this.config == Configs.PAPERDOLL) {
            this.parent.parentScreen.renderPaperdoll = this.parentConfig.isToggled() && this.parent.method_25405(mouseX, mouseY) && this.method_25405(mouseX, mouseY);
        }
        super.method_25394(gui, mouseX, mouseY, delta);
    }

    @Override
    public boolean method_25405(double mouseX, double mouseY) {
        return UIHelper.isMouseOver(this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), mouseX, mouseY);
    }

    public void addConfig(ConfigType<?> config) {
        AbstractConfigElement element;
        if (config.hidden && !FiguraMod.debugModeEnabled()) {
            return;
        }
        int width = this.method_25368();
        if (config instanceof ConfigType.BoolConfig) {
            ConfigType.BoolConfig boolConfig = (ConfigType.BoolConfig)config;
            element = new BooleanElement(width, boolConfig, this.parent, this);
        } else if (config instanceof ConfigType.EnumConfig) {
            ConfigType.EnumConfig enumConfig = (ConfigType.EnumConfig)config;
            element = new EnumElement(width, enumConfig, this.parent, this);
        } else if (config instanceof ConfigType.InputConfig) {
            ConfigType.InputConfig inputConfig = (ConfigType.InputConfig)config;
            element = new InputElement(width, inputConfig, this.parent, this);
        } else if (config instanceof ConfigType.KeybindConfig) {
            ConfigType.KeybindConfig keybindConfig = (ConfigType.KeybindConfig)config;
            element = new KeybindElement(width, keybindConfig, this.parent, this);
        } else if (config instanceof ConfigType.ButtonConfig) {
            ConfigType.ButtonConfig buttonConfig = (ConfigType.ButtonConfig)config;
            element = new ButtonElement(width, buttonConfig, this.parent, this);
        } else {
            return;
        }
        this.setHeight(super.method_25364() + 22);
        this.children.add(element);
        this.entries.add(element);
    }

    public boolean isChanged() {
        for (AbstractConfigElement entry : this.entries) {
            if (!entry.isChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int method_25364() {
        if (!this.parentConfig.isToggled()) {
            return 20;
        }
        int height = 20;
        for (AbstractConfigElement entry : this.entries) {
            if (!entry.isVisible()) continue;
            height += entry.method_25364() + 2;
        }
        return height;
    }

    @Override
    public void method_46421(int x) {
        super.method_46421(x);
        this.parentConfig.method_46421(x);
        for (AbstractConfigElement entry : this.entries) {
            entry.method_46421(x);
        }
    }

    @Override
    public void method_46419(int y) {
        super.method_46419(y);
        this.parentConfig.method_46419(y);
        int i = 0;
        for (AbstractConfigElement entry : this.entries) {
            if (!entry.isVisible()) continue;
            entry.method_46419(y + 22 * (i + 1));
            ++i;
        }
    }

    public void setShowChildren(boolean bool) {
        this.parentConfig.setToggled(bool);
        for (AbstractConfigElement element : this.entries) {
            element.setVisible(bool);
        }
    }

    public boolean isShowingChildren() {
        return this.parentConfig.isToggled();
    }

    public void updateKeybinds() {
        for (AbstractConfigElement element : this.entries) {
            if (!(element instanceof KeybindElement)) continue;
            KeybindElement keybind = (KeybindElement)element;
            keybind.updateText();
        }
    }

    public void updateFilter(String query) {
        boolean visible = false;
        for (AbstractConfigElement entry : this.entries) {
            entry.updateFilter(query);
            visible |= entry.matchesFilter();
        }
        this.setVisible(visible);
        if (visible) {
            this.method_46419(this.method_46427());
        }
        this.parent.updateScroll();
    }
}

