/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.gui.widgets.config;

import fabric.org.figuramc.figura.config.ConfigType;
import fabric.org.figuramc.figura.gui.widgets.AbstractContainerElement;
import fabric.org.figuramc.figura.gui.widgets.Button;
import fabric.org.figuramc.figura.gui.widgets.ParentedButton;
import fabric.org.figuramc.figura.gui.widgets.config.CategoryWidget;
import fabric.org.figuramc.figura.gui.widgets.lists.ConfigList;
import fabric.org.figuramc.figura.utils.ui.UIHelper;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public abstract class AbstractConfigElement
extends AbstractContainerElement {
    protected final ConfigType<?> config;
    protected final ConfigList parentList;
    protected final CategoryWidget parentCategory;
    protected Button resetButton;
    protected Object initValue;
    private String filter = "";

    public AbstractConfigElement(int width, ConfigType<?> config, ConfigList parentList, CategoryWidget parentCategory) {
        super(0, 0, width, 20);
        this.config = config;
        this.parentList = parentList;
        this.parentCategory = parentCategory;
        this.initValue = config.value;
        this.resetButton = new ParentedButton(0, 0, 60, 20, (class_2561)class_2561.method_43471((String)"controls.reset"), this, button -> config.resetTemp());
        this.children.add(this.resetButton);
    }

    @Override
    public void method_25394(class_332 gui, int mouseX, int mouseY, float delta) {
        if (!this.isVisible()) {
            return;
        }
        class_327 font = class_310.method_1551().field_1772;
        int n = this.method_46427() + this.method_25364() / 2;
        Objects.requireNonNull(font);
        int textY = n - 9 / 2;
        this.setHovered(this.method_25405(mouseX, mouseY));
        if (this.isHovered()) {
            gui.method_27535(font, HOVERED_ARROW, (int)((float)(this.method_46426() + 8) - (float)font.method_27525((class_5348)HOVERED_ARROW) / 2.0f), textY, 0xFFFFFF);
        }
        this.renderTitle(gui, font, textY);
        super.method_25394(gui, mouseX, mouseY, delta);
    }

    public void renderTitle(class_332 gui, class_327 font, int y) {
        gui.method_27535(font, this.config.name, this.method_46426() + 16, y, (this.config.disabled ? class_124.field_1063 : class_124.field_1068).method_532().intValue());
    }

    @Override
    public boolean method_25405(double mouseX, double mouseY) {
        boolean over;
        boolean bl = over = this.parentList.isInsideScissors(mouseX, mouseY) && super.method_25405(mouseX, mouseY);
        if (over && mouseX < (double)(this.method_46426() + this.method_25368() - 158)) {
            UIHelper.setTooltip((class_2561)this.getTooltip());
        }
        return over;
    }

    public class_5250 getTooltip() {
        return this.config.tooltip.method_27661();
    }

    public boolean isDefault() {
        return this.config.isDefault();
    }

    public boolean isChanged() {
        return !Objects.equals(this.config.tempValue, this.initValue);
    }

    @Override
    public void method_46421(int x) {
        super.method_46421(x);
        this.resetButton.method_46421(x + this.method_25368() - 60);
    }

    @Override
    public void method_46419(int y) {
        super.method_46419(y);
        this.resetButton.method_46419(y);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible && this.parentCategory.isShowingChildren() && this.matchesFilter());
    }

    public void updateFilter(String query) {
        this.filter = query;
    }

    public boolean matchesFilter() {
        return this.config.name.getString().toLowerCase().contains(this.filter) || this.config.tooltip.getString().toLowerCase().contains(this.filter);
    }
}

